/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.ItemStackUtils;
import ad_astra_giselle_addon.common.menu.FuelLoaderMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHoldingBlock;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.SimpleUpdatingFluidContainer;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FuelLoaderBlockEntity
extends AddonMachineBlockEntity
implements FluidHoldingBlock,
IRangedWorkingAreaBlockEntity {
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final int SLOTS_FLUID = 2;
    public static final int SLOT_FLUID_SOURCE = 0;
    public static final int SLOT_FLUID_SINK = 1;
    private boolean workingAreaVisible;
    private SimpleUpdatingFluidContainer fluidTank;

    public FuelLoaderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockEntityTypes.FUEL_LOADER.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.workingAreaVisible = nbt.m_128471_(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    public int m_6893_() {
        return 1;
    }

    public SimpleUpdatingFluidContainer getFluidContainer() {
        if (this.fluidTank == null) {
            this.fluidTank = new SimpleUpdatingFluidContainer((Updatable)this, tank -> MachinesConfig.FUEL_LOADER_FLUID_CAPACITY, 1, FluidPredicates::isFuel);
            return this.fluidTank;
        }
        return this.fluidTank;
    }

    public void update() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public int getInventorySize() {
        return super.getInventorySize() + this.getSlotsFluid();
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction dir) {
        stack = ItemStackUtils.deriveCount(stack, 1);
        if (slot == this.getSlotFluidSource()) {
            if (FluidHooks.isFluidContainingItem((ItemStack)stack)) {
                UniveralFluidHandler itemFluidHandler = UniveralFluidHandler.from(new ItemStackHolder(stack));
                return itemFluidHandler.getFluidTanks().stream().anyMatch(FluidPredicates::isFuel);
            }
            return false;
        }
        if (slot == this.getSlotFluidSink()) {
            return dir == null;
        }
        return super.m_7155_(slot, stack, dir);
    }

    public boolean m_7157_(int slot, ItemStack stack, @Nullable Direction dir) {
        if (slot == this.getSlotFluidSource()) {
            if (FluidHooks.isFluidContainingItem((ItemStack)stack)) {
                UniveralFluidHandler itemFluidHandler = UniveralFluidHandler.from(new ItemStackHolder(stack));
                return !itemFluidHandler.getFluidTanks().stream().anyMatch(FluidPredicates::isFuel);
            }
        } else if (slot == this.getSlotFluidSink()) {
            return dir == null;
        }
        return super.m_7157_(slot, stack, dir);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new FuelLoaderMenu(windowId, inv, this);
    }

    public void tick() {
        Level level = this.m_58904_();
        if (!level.m_5776_()) {
            this.processTank();
            this.exchangeFuelItemAround();
        }
    }

    public void processTank() {
        UniveralFluidHandler tank = UniveralFluidHandler.from((FluidContainer)this.getFluidContainer());
        UniveralFluidHandler.fromSafe(this.getItemRef(this.getSlotFluidSource())).ifPresent(source -> FluidHooks2.moveFluidAny(source, tank, FluidPredicates::isFuel, false));
        UniveralFluidHandler.fromSafe(this.getItemRef(this.getSlotFluidSink())).ifPresent(sink -> FluidHooks2.moveFluidAny(tank, sink, null, false));
    }

    public ItemStackReference getItemRef(int slot) {
        return new ItemStackReference(this.m_8020_(slot), ItemStackConsumers.index(slot, this::m_6836_));
    }

    public void exchangeFuelItemAround() {
        Level level = this.m_58904_();
        AABB workingArea = this.getWorkingArea();
        List vehicles = level.m_45976_(Vehicle.class, workingArea);
        for (Vehicle vehicle : vehicles) {
            this.giveFuel(vehicle);
        }
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.m_6596_();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.FUEL_LOADER_WORKING_RANGE;
    }

    @Override
    public AABB getWorkingArea(double range) {
        return this.getWorkingArea(this.m_58899_(), range);
    }

    public FluidHolder giveFuel(Vehicle vehicle) {
        return this.giveFuel(vehicle, MachinesConfig.FUEL_LOADER_FLUID_TRANSFER);
    }

    private FluidHolder giveFuel(Vehicle vehicle, long transfer) {
        UniveralFluidHandler from = UniveralFluidHandler.from((FluidContainer)this.getFluidContainer());
        UniveralFluidHandler to = UniveralFluidHandler.from((FluidContainer)vehicle.getTank());
        return FluidHooks2.moveFluidAny(from, to, FluidPredicates::isFuel, transfer, false);
    }

    public int getSlotFluidStart() {
        return 0;
    }

    public int getSlotFluidEnd() {
        return this.getSlotFluidStart() + this.getSlotsFluid();
    }

    public int getSlotsFluid() {
        return 2;
    }

    public int getSlotFluidSource() {
        return this.getSlotFluidStart() + 0;
    }

    public int getSlotFluidSink() {
        return this.getSlotFluidStart() + 1;
    }
}

