/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.client.screen;

import ad_astra_giselle_addon.client.screen.AddonMachineScreen;
import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.FuelLoaderBlockEntity;
import ad_astra_giselle_addon.common.menu.FuelLoaderMenu;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class FuelLoaderScreen
extends AddonMachineScreen<FuelLoaderBlockEntity, FuelLoaderMenu> {
    public static final ResourceLocation TEXTURE = AdAstraGiselleAddon.rl("textures/gui/container/fuel_loader.png");
    public static final int TANK_LEFT = 67;
    public static final int TANK_TOP = 27;

    public FuelLoaderScreen(FuelLoaderMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, TEXTURE);
        this.f_97726_ = 176;
        this.f_97727_ = 182;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(stack, partialTicks, mouseX, mouseY);
        FluidHolder fluid = this.getFluid();
        long capacity = this.getCapacity();
        Rectangle bounds = this.getFluidTankBounds();
        GuiUtil.drawFluidTank((PoseStack)stack, (int)bounds.x, (int)bounds.y, (long)capacity, (FluidHolder)fluid);
    }

    @Override
    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float delta) {
        super.m_6305_(stack, mouseX, mouseY, delta);
        if (GuiUtil.isHovering((Rectangle)this.getFluidTankBounds(), (double)mouseX, (double)mouseY) && FuelLoaderScreen.shouldShowRecipeTooltip()) {
            this.m_96597_(stack, this.getFluidTankTooltip(), mouseX, mouseY);
        }
    }

    public Rectangle getFluidTankBounds() {
        return GuiUtil.getFluidTankBounds((int)(this.f_97735_ + 67), (int)(this.f_97736_ + 27));
    }

    public List<Component> getFluidTankTooltip() {
        FluidHolder fluid = this.getFluid();
        long capacity = this.getCapacity();
        return TranslationUtils.fluid(fluid, capacity);
    }

    public FluidHolder getFluid() {
        return (FluidHolder)((FuelLoaderMenu)this.m_6262_()).getFluids().get(0);
    }

    public long getCapacity() {
        return ((FuelLoaderBlockEntity)((FuelLoaderMenu)this.m_6262_()).getMachine()).getFluidContainer().getTankCapacity(0);
    }
}

