/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.List;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class ProjectorBlock
extends DisguisableBlock {
    private static final MutableComponent TOOLTIP = Component.m_237115_((String)"tooltip.securitycraft:projector").m_6270_(Utils.GRAY_STYLE);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    private static final VoxelShape FLOOR_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)9.0, (double)2.0, (double)15.0, (double)14.0, (double)7.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0)});
    private static final VoxelShape FLOOR_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)7.0, (double)7.0, (double)1.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0)});
    private static final VoxelShape FLOOR_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)7.0, (double)7.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0)});
    private static final VoxelShape FLOOR_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.m_49796_((double)0.0, (double)2.0, (double)9.0, (double)1.0, (double)7.0, (double)14.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)4.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)4.0)});
    private static final VoxelShape CEILING_NORTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)9.0, (double)6.0, (double)15.0, (double)14.0, (double)11.0, (double)16.0), Block.m_49796_((double)7.0, (double)11.0, (double)4.0, (double)9.0, (double)16.0, (double)6.0)});
    private static final VoxelShape CEILING_SOUTH = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)6.0, (double)0.0, (double)7.0, (double)11.0, (double)1.0), Block.m_49796_((double)7.0, (double)11.0, (double)10.0, (double)9.0, (double)16.0, (double)12.0)});
    private static final VoxelShape CEILING_WEST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)15.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)7.0), Block.m_49796_((double)4.0, (double)11.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0)});
    private static final VoxelShape CEILING_EAST = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)6.0, (double)9.0, (double)1.0, (double)11.0, (double)14.0), Block.m_49796_((double)10.0, (double)11.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0)});

    public ProjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = ProjectorBlock.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        if (!((Boolean)disguisedState.m_61143_((Property)HANGING)).booleanValue()) {
            return switch ((Direction)disguisedState.m_61143_((Property)FACING)) {
                case Direction.NORTH -> FLOOR_NORTH;
                case Direction.EAST -> FLOOR_EAST;
                case Direction.SOUTH -> FLOOR_SOUTH;
                case Direction.WEST -> FLOOR_WEST;
                default -> Shapes.m_83144_();
            };
        }
        return switch ((Direction)disguisedState.m_61143_((Property)FACING)) {
            case Direction.NORTH -> CEILING_NORTH;
            case Direction.EAST -> CEILING_EAST;
            case Direction.SOUTH -> CEILING_SOUTH;
            case Direction.WEST -> CEILING_WEST;
            default -> Shapes.m_83144_();
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ProjectorBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ProjectorBlockEntity be = (ProjectorBlockEntity)blockEntity;
        boolean isOwner = be.isOwnedBy(player);
        if (!level.f_46443_ && isOwner) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)be, (BlockPos)pos);
        }
        return isOwner ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return direction != null && direction.m_122434_() != Direction.Axis.Y;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ProjectorBlockEntity) {
            ProjectorBlockEntity be = (ProjectorBlockEntity)blockEntity;
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), be.getStackInSlot(36));
            LevelUtils.addScheduledTask((LevelAccessor)level, () -> level.m_7967_((Entity)item));
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isActivatedByRedstone()) {
            be.setActive(level.m_46753_(pos));
            level.m_7260_(pos, state, state, 3);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        ProjectorBlockEntity be;
        BlockEntity blockEntity;
        if (!level.m_46753_(pos) && (blockEntity = level.m_7702_(pos)) instanceof ProjectorBlockEntity && (be = (ProjectorBlockEntity)blockEntity).isActivatedByRedstone()) {
            be.setActive(false);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_43723_().m_6350_().m_122424_())).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(ctx.m_43719_() == Direction.DOWN));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HANGING, WATERLOGGED});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ProjectorBlockEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)TOOLTIP);
    }
}

