/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeyPanelBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyPanelBlockEntity
extends CustomizableBlockEntity
implements IPasswordProtected,
ILockable {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            if (!KeyPanelBlockEntity.this.isDisabled()) {
                KeyPanelBlockEntity.this.f_58857_.m_46597_(KeyPanelBlockEntity.this.f_58858_, (BlockState)KeyPanelBlockEntity.this.m_58900_().m_61124_((Property)KeyPanelBlock.POWERED, (Comparable)((Boolean)this.get())));
                KeyPanelBlockEntity.this.f_58857_.m_46672_(KeyPanelBlockEntity.this.f_58858_, (Block)SCContent.KEY_PANEL_BLOCK.get());
            }
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption("signalLength", 60, 5, 400, 5, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption(() -> ((KeyPanelBlockEntity)this).m_58899_());
    private long cooldownEnd = 0L;

    public KeyPanelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEY_PANEL_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
        tag.m_128356_("cooldownLeft", this.getCooldownEnd() - System.currentTimeMillis());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.passcode = tag.m_128461_("passcode");
        this.cooldownEnd = System.currentTimeMillis() + tag.m_128454_("cooldownLeft");
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.m_6596_();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeyPanelBlock) {
            KeyPanelBlock block2 = (KeyPanelBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, (Integer)this.signalLength.get());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)state.m_61143_((Property)KeyPanelBlock.POWERED) == false && IPasswordProtected.super.shouldAttemptCodebreak(state, player);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        if (option.getName().equals("disabled")) {
            boolean isDisabled = (Boolean)((Option.BooleanOption)option).get();
            if (isDisabled && ((Boolean)this.m_58900_().m_61143_((Property)KeyPanelBlock.POWERED)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)KeyPanelBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            } else if (!isDisabled && ((Boolean)this.isAlwaysActive.get()).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)KeyPanelBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

