/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.screens.CreateFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FlatLevelGeneratorPresetTags;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.slf4j.Logger;

public class PresetFlatWorldScreen
extends Screen {
    static final Logger f_96368_ = LogUtils.getLogger();
    private static final int f_169346_ = 128;
    private static final int f_169347_ = 18;
    private static final int f_169348_ = 20;
    private static final int f_169349_ = 1;
    private static final int f_169350_ = 1;
    private static final int f_169351_ = 2;
    private static final int f_169352_ = 2;
    private static final ResourceKey<Biome> f_169353_ = Biomes.f_48202_;
    public static final Component f_232751_ = Component.m_237115_("flat_world_preset.unknown");
    private final CreateFlatWorldScreen f_96370_;
    private Component f_96371_;
    private Component f_96372_;
    private PresetsList f_96373_;
    private Button f_96374_;
    EditBox f_96375_;
    FlatLevelGeneratorSettings f_96376_;

    public PresetFlatWorldScreen(CreateFlatWorldScreen p_96379_) {
        super(Component.m_237115_("createWorld.customize.presets.title"));
        this.f_96370_ = p_96379_;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static FlatLayerInfo m_257877_(HolderGetter<Block> p_259695_, String p_259185_, int p_259723_) {
        void $$13;
        int $$8;
        String $$7;
        List $$3 = Splitter.on((char)'*').limit(2).splitToList((CharSequence)p_259185_);
        if ($$3.size() == 2) {
            String $$4 = (String)$$3.get(1);
            try {
                int $$5 = Math.max(Integer.parseInt((String)$$3.get(0)), 0);
            }
            catch (NumberFormatException $$6) {
                f_96368_.error("Error while parsing flat world string", (Throwable)$$6);
                return null;
            }
        } else {
            $$7 = (String)$$3.get(0);
            $$8 = 1;
        }
        int $$9 = Math.min(p_259723_ + $$8, DimensionType.f_156651_);
        int $$10 = $$9 - p_259723_;
        try {
            Optional<Holder.Reference<Block>> $$11 = p_259695_.m_254902_(ResourceKey.m_135785_(Registries.f_256747_, new ResourceLocation($$7)));
        }
        catch (Exception $$12) {
            f_96368_.error("Error while parsing flat world string", (Throwable)$$12);
            return null;
        }
        if ($$13.isEmpty()) {
            f_96368_.error("Error while parsing flat world string => Unknown block, {}", (Object)$$7);
            return null;
        }
        return new FlatLayerInfo($$10, (Block)((Holder.Reference)$$13.get()).m_203334_());
    }

    private static List<FlatLayerInfo> m_257841_(HolderGetter<Block> p_259080_, String p_260301_) {
        ArrayList $$2 = Lists.newArrayList();
        String[] $$3 = p_260301_.split(",");
        int $$4 = 0;
        for (String $$5 : $$3) {
            FlatLayerInfo $$6 = PresetFlatWorldScreen.m_257877_(p_259080_, $$5, $$4);
            if ($$6 == null) {
                return Collections.emptyList();
            }
            $$2.add($$6);
            $$4 += $$6.m_70337_();
        }
        return $$2;
    }

    public static FlatLevelGeneratorSettings m_257717_(HolderGetter<Block> p_259084_, HolderGetter<Biome> p_259583_, HolderGetter<StructureSet> p_259610_, HolderGetter<PlacedFeature> p_259243_, String p_259508_, FlatLevelGeneratorSettings p_259417_) {
        Holder.Reference<Biome> $$8;
        Iterator $$6 = Splitter.on((char)';').split((CharSequence)p_259508_).iterator();
        if (!$$6.hasNext()) {
            return FlatLevelGeneratorSettings.m_254980_(p_259583_, p_259610_, p_259243_);
        }
        List<FlatLayerInfo> $$7 = PresetFlatWorldScreen.m_257841_(p_259084_, (String)$$6.next());
        if ($$7.isEmpty()) {
            return FlatLevelGeneratorSettings.m_254980_(p_259583_, p_259610_, p_259243_);
        }
        Holder<Biome> $$9 = $$8 = p_259583_.m_255043_(f_169353_);
        if ($$6.hasNext()) {
            String $$10 = (String)$$6.next();
            $$9 = Optional.ofNullable(ResourceLocation.m_135820_($$10)).map(p_258126_ -> ResourceKey.m_135785_(Registries.f_256952_, p_258126_)).flatMap(p_259583_::m_254902_).orElseGet(() -> {
                f_96368_.warn("Invalid biome: {}", (Object)$$10);
                return $$8;
            });
        }
        return p_259417_.m_254853_($$7, p_259417_.m_209810_(), $$9);
    }

    static String m_205393_(FlatLevelGeneratorSettings p_205394_) {
        StringBuilder $$1 = new StringBuilder();
        for (int $$2 = 0; $$2 < p_205394_.m_70401_().size(); ++$$2) {
            if ($$2 > 0) {
                $$1.append(",");
            }
            $$1.append(p_205394_.m_70401_().get($$2));
        }
        $$1.append(";");
        $$1.append(p_205394_.m_204921_().m_203543_().map(ResourceKey::m_135782_).orElseThrow(() -> new IllegalStateException("Biome not registered")));
        return $$1.toString();
    }

    @Override
    protected void m_7856_() {
        this.f_96371_ = Component.m_237115_("createWorld.customize.presets.share");
        this.f_96372_ = Component.m_237115_("createWorld.customize.presets.list");
        this.f_96375_ = new EditBox(this.f_96547_, 50, 40, this.f_96543_ - 100, 20, this.f_96371_);
        this.f_96375_.m_94199_(1230);
        WorldCreationContext $$0 = this.f_96370_.f_95814_.m_267748_().m_267573_();
        RegistryAccess.Frozen $$1 = $$0.m_246480_();
        FeatureFlagSet $$2 = $$0.f_243842_().f_243973_();
        HolderLookup.RegistryLookup<Biome> $$3 = $$1.m_255025_(Registries.f_256952_);
        HolderLookup.RegistryLookup<StructureSet> $$4 = $$1.m_255025_(Registries.f_256998_);
        HolderLookup.RegistryLookup<PlacedFeature> $$5 = $$1.m_255025_(Registries.f_256988_);
        HolderLookup<Block> $$6 = $$1.m_255025_(Registries.f_256747_).m_245140_($$2);
        this.f_96375_.m_94144_(PresetFlatWorldScreen.m_205393_(this.f_96370_.m_95846_()));
        this.f_96376_ = this.f_96370_.m_95846_();
        this.m_7787_(this.f_96375_);
        this.f_96373_ = new PresetsList($$1, $$2);
        this.m_7787_(this.f_96373_);
        this.f_96374_ = this.m_142416_(Button.m_253074_(Component.m_237115_("createWorld.customize.presets.select"), p_280822_ -> {
            FlatLevelGeneratorSettings $$5 = PresetFlatWorldScreen.m_257717_($$6, $$3, $$4, $$5, this.f_96375_.m_94155_(), this.f_96376_);
            this.f_96370_.m_95825_($$5);
            this.f_96541_.m_91152_(this.f_96370_);
        }).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ - 28, 150, 20).m_253136_());
        this.m_142416_(Button.m_253074_(CommonComponents.f_130656_, p_280823_ -> this.f_96541_.m_91152_(this.f_96370_)).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ - 28, 150, 20).m_253136_());
        this.m_96449_(this.f_96373_.m_93511_() != null);
    }

    @Override
    public boolean m_6050_(double p_96381_, double p_96382_, double p_96383_) {
        return this.f_96373_.m_6050_(p_96381_, p_96382_, p_96383_);
    }

    @Override
    public void m_6574_(Minecraft p_96390_, int p_96391_, int p_96392_) {
        String $$3 = this.f_96375_.m_94155_();
        this.m_6575_(p_96390_, p_96391_, p_96392_);
        this.f_96375_.m_94144_($$3);
    }

    @Override
    public void m_7379_() {
        this.f_96541_.m_91152_(this.f_96370_);
    }

    @Override
    public void m_88315_(GuiGraphics p_282713_, int p_281914_, int p_283700_, float p_283598_) {
        this.m_280273_(p_282713_);
        this.f_96373_.m_88315_(p_282713_, p_281914_, p_283700_, p_283598_);
        p_282713_.m_280168_().m_85836_();
        p_282713_.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
        p_282713_.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        p_282713_.m_280430_(this.f_96547_, this.f_96371_, 50, 30, 0xA0A0A0);
        p_282713_.m_280430_(this.f_96547_, this.f_96372_, 50, 70, 0xA0A0A0);
        p_282713_.m_280168_().m_85849_();
        this.f_96375_.m_88315_(p_282713_, p_281914_, p_283700_, p_283598_);
        super.m_88315_(p_282713_, p_281914_, p_283700_, p_283598_);
    }

    @Override
    public void m_86600_() {
        this.f_96375_.m_94120_();
        super.m_86600_();
    }

    public void m_96449_(boolean p_96450_) {
        this.f_96374_.f_93623_ = p_96450_ || this.f_96375_.m_94155_().length() > 1;
    }

    class PresetsList
    extends ObjectSelectionList<Entry> {
        public PresetsList(RegistryAccess p_259278_, FeatureFlagSet p_259076_) {
            super(PresetFlatWorldScreen.this.f_96541_, PresetFlatWorldScreen.this.f_96543_, PresetFlatWorldScreen.this.f_96544_, 80, PresetFlatWorldScreen.this.f_96544_ - 37, 24);
            for (Holder<FlatLevelGeneratorPreset> $$2 : p_259278_.m_175515_(Registries.f_256724_).m_206058_(FlatLevelGeneratorPresetTags.f_215848_)) {
                Set $$3 = $$2.m_203334_().f_226246_().m_70401_().stream().map(p_259579_ -> p_259579_.m_70344_().m_60734_()).filter(p_259421_ -> !p_259421_.m_245993_(p_259076_)).collect(Collectors.toSet());
                if (!$$3.isEmpty()) {
                    f_96368_.info("Discarding flat world preset {} since it contains experimental blocks {}", (Object)$$2.m_203543_().map(p_259357_ -> p_259357_.m_135782_().toString()).orElse("<unknown>"), $$3);
                    continue;
                }
                this.m_7085_(new Entry($$2));
            }
        }

        @Override
        public void m_6987_(@Nullable Entry p_96472_) {
            super.m_6987_(p_96472_);
            PresetFlatWorldScreen.this.m_96449_(p_96472_ != null);
        }

        @Override
        public boolean m_7933_(int p_96466_, int p_96467_, int p_96468_) {
            if (super.m_7933_(p_96466_, p_96467_, p_96468_)) {
                return true;
            }
            if (CommonInputs.m_278691_(p_96466_) && this.m_93511_() != null) {
                ((Entry)this.m_93511_()).m_96479_();
            }
            return false;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            private static final ResourceLocation f_279577_ = new ResourceLocation("textures/gui/container/stats_icons.png");
            private final FlatLevelGeneratorPreset f_169357_;
            private final Component f_232755_;

            public Entry(Holder<FlatLevelGeneratorPreset> p_232758_) {
                this.f_169357_ = p_232758_.m_203334_();
                this.f_232755_ = p_232758_.m_203543_().map(p_232760_ -> Component.m_237115_(p_232760_.m_135782_().m_214296_("flat_world_preset"))).orElse(f_232751_);
            }

            @Override
            public void m_6311_(GuiGraphics p_283649_, int p_281641_, int p_281959_, int p_281428_, int p_282594_, int p_283493_, int p_283234_, int p_283185_, boolean p_282302_, float p_282855_) {
                this.m_280449_(p_283649_, p_281428_, p_281959_, this.f_169357_.f_226245_().m_203334_());
                p_283649_.m_280614_(PresetFlatWorldScreen.this.f_96547_, this.f_232755_, p_281428_ + 18 + 5, p_281959_ + 6, 0xFFFFFF, false);
            }

            @Override
            public boolean m_6375_(double p_96481_, double p_96482_, int p_96483_) {
                if (p_96483_ == 0) {
                    this.m_96479_();
                }
                return false;
            }

            void m_96479_() {
                PresetsList.this.m_6987_(this);
                PresetFlatWorldScreen.this.f_96376_ = this.f_169357_.f_226246_();
                PresetFlatWorldScreen.this.f_96375_.m_94144_(PresetFlatWorldScreen.m_205393_(PresetFlatWorldScreen.this.f_96376_));
                PresetFlatWorldScreen.this.f_96375_.m_94198_();
            }

            private void m_280449_(GuiGraphics p_283196_, int p_282036_, int p_281683_, Item p_282242_) {
                this.m_280169_(p_283196_, p_282036_ + 1, p_281683_ + 1);
                p_283196_.m_280203_(new ItemStack(p_282242_), p_282036_ + 2, p_281683_ + 2);
            }

            private void m_280169_(GuiGraphics p_281359_, int p_282978_, int p_283152_) {
                p_281359_.m_280398_(f_279577_, p_282978_, p_283152_, 0, 0.0f, 0.0f, 18, 18, 128, 128);
            }

            @Override
            public Component m_142172_() {
                return Component.m_237110_("narrator.select", this.f_232755_);
            }
        }
    }
}

