/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.lib.configurate.hocon;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.lxgaming.sledgehammer.lib.checkerframework.checker.nullness.qual.NonNull;
import io.github.lxgaming.sledgehammer.lib.config.Config;
import io.github.lxgaming.sledgehammer.lib.config.ConfigFactory;
import io.github.lxgaming.sledgehammer.lib.config.ConfigList;
import io.github.lxgaming.sledgehammer.lib.config.ConfigObject;
import io.github.lxgaming.sledgehammer.lib.config.ConfigOrigin;
import io.github.lxgaming.sledgehammer.lib.config.ConfigOriginFactory;
import io.github.lxgaming.sledgehammer.lib.config.ConfigParseOptions;
import io.github.lxgaming.sledgehammer.lib.config.ConfigRenderOptions;
import io.github.lxgaming.sledgehammer.lib.config.ConfigValue;
import io.github.lxgaming.sledgehammer.lib.config.ConfigValueFactory;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.ConfigurationOptions;
import io.github.lxgaming.sledgehammer.lib.configurate.commented.CommentedConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.commented.SimpleCommentedConfigurationNode;
import io.github.lxgaming.sledgehammer.lib.configurate.loader.AbstractConfigurationLoader;
import io.github.lxgaming.sledgehammer.lib.configurate.loader.CommentHandler;
import io.github.lxgaming.sledgehammer.lib.configurate.loader.CommentHandlers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class HoconConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    public static final Pattern CRLF_MATCH;
    private static final ConfigRenderOptions DEFAULT_RENDER_OPTIONS;
    private static final ConfigOrigin CONFIGURATE_ORIGIN;
    private final ConfigRenderOptions render;
    private final ConfigParseOptions parse;
    private static final Constructor<? extends ConfigValue> CONFIG_OBJECT_CONSTRUCTOR;
    private static final Constructor<? extends ConfigValue> CONFIG_LIST_CONSTRUCTOR;

    public static ConfigRenderOptions defaultRenderOptions() {
        return DEFAULT_RENDER_OPTIONS;
    }

    public static ConfigParseOptions defaultParseOptions() {
        return ConfigParseOptions.defaults();
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private HoconConfigurationLoader(Builder build) {
        super(build, new CommentHandler[]{CommentHandlers.HASH, CommentHandlers.DOUBLE_SLASH});
        this.render = build.getRenderOptions();
        this.parse = build.getParseOptions();
    }

    @Override
    public void loadInternal(CommentedConfigurationNode node, BufferedReader reader) throws IOException {
        Config hoconConfig = ConfigFactory.parseReader(reader, this.parse);
        hoconConfig = hoconConfig.resolve();
        for (Map.Entry ent : hoconConfig.root().entrySet()) {
            HoconConfigurationLoader.readConfigValue((ConfigValue)ent.getValue(), node.getNode(ent.getKey()));
        }
    }

    private static void readConfigValue(ConfigValue value, CommentedConfigurationNode node) {
        if (!value.origin().comments().isEmpty()) {
            node.setComment(CRLF_MATCH.matcher(Joiner.on((char)'\n').join(value.origin().comments())).replaceAll(""));
        }
        switch (value.valueType()) {
            case OBJECT: {
                if (((ConfigObject)value).isEmpty()) {
                    node.setValue(ImmutableMap.of());
                    break;
                }
                for (Map.Entry ent : ((ConfigObject)value).entrySet()) {
                    HoconConfigurationLoader.readConfigValue((ConfigValue)ent.getValue(), node.getNode(ent.getKey()));
                }
                break;
            }
            case LIST: {
                ConfigList values = (ConfigList)value;
                for (int i = 0; i < values.size(); ++i) {
                    HoconConfigurationLoader.readConfigValue((ConfigValue)values.get(i), node.getNode(i));
                }
                break;
            }
            case NULL: {
                return;
            }
            default: {
                node.setValue(value.unwrapped());
            }
        }
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        if (!node.hasMapChildren()) {
            if (node.getValue() == null) {
                writer.write(SYSTEM_LINE_SEPARATOR);
                return;
            }
            throw new IOException("HOCON cannot write nodes not in map format!");
        }
        ConfigValue value = HoconConfigurationLoader.fromValue(node);
        String renderedValue = value.render(this.render);
        writer.write(renderedValue);
    }

    private static ConfigValue fromValue(ConfigurationNode node) {
        ConfigValue ret;
        Object children;
        if (node.hasMapChildren()) {
            children = node.getOptions().getMapFactory().create();
            for (Map.Entry entry : node.getChildrenMap().entrySet()) {
                children.put(String.valueOf(entry.getKey()), HoconConfigurationLoader.fromValue((ConfigurationNode)entry.getValue()));
            }
            ret = HoconConfigurationLoader.newConfigObject((Map<String, ConfigValue>)children);
        } else if (node.hasListChildren()) {
            children = new ArrayList();
            for (ConfigurationNode configurationNode : node.getChildrenList()) {
                children.add(HoconConfigurationLoader.fromValue(configurationNode));
            }
            ret = HoconConfigurationLoader.newConfigList((List<ConfigValue>)children);
        } else {
            ret = ConfigValueFactory.fromAnyRef(node.getValue(), "configurate-hocon");
        }
        if (node instanceof CommentedConfigurationNode) {
            CommentedConfigurationNode commentedNode = (CommentedConfigurationNode)node;
            ConfigValue finalRet = ret;
            ret = commentedNode.getComment().map(comment -> finalRet.withOrigin(finalRet.origin().withComments(LINE_SPLITTER.splitToList((CharSequence)comment)))).orElse(ret);
        }
        return ret;
    }

    static ConfigValue newConfigObject(Map<String, ConfigValue> vals) {
        try {
            return CONFIG_OBJECT_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static ConfigValue newConfigList(List<ConfigValue> vals) {
        try {
            return CONFIG_LIST_CONSTRUCTOR.newInstance(CONFIGURATE_ORIGIN, vals);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public @NonNull CommentedConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        options = options.setAcceptedTypes((Set<Class<?>>)ImmutableSet.of(Map.class, List.class, Double.class, Long.class, Integer.class, Boolean.class, (Object[])new Class[]{String.class, Number.class}));
        return SimpleCommentedConfigurationNode.root(options);
    }

    static {
        Class<ConfigValue> listClass;
        Class<ConfigValue> objectClass;
        CRLF_MATCH = Pattern.compile("\r?");
        DEFAULT_RENDER_OPTIONS = ConfigRenderOptions.defaults().setOriginComments(false).setJson(false);
        CONFIGURATE_ORIGIN = ConfigOriginFactory.newSimple("configurate-hocon");
        try {
            objectClass = Class.forName("io.github.lxgaming.sledgehammer.lib.config.impl.SimpleConfigObject").asSubclass(ConfigValue.class);
            listClass = Class.forName("io.github.lxgaming.sledgehammer.lib.config.impl.SimpleConfigList").asSubclass(ConfigValue.class);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        try {
            CONFIG_OBJECT_CONSTRUCTOR = objectClass.getDeclaredConstructor(ConfigOrigin.class, Map.class);
            CONFIG_OBJECT_CONSTRUCTOR.setAccessible(true);
            CONFIG_LIST_CONSTRUCTOR = listClass.getDeclaredConstructor(ConfigOrigin.class, List.class);
            CONFIG_LIST_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private ConfigRenderOptions render = HoconConfigurationLoader.defaultRenderOptions();
        private ConfigParseOptions parse = HoconConfigurationLoader.defaultParseOptions();

        protected Builder() {
        }

        public @NonNull Builder setRenderOptions(@NonNull ConfigRenderOptions options) {
            this.render = options;
            return this;
        }

        public @NonNull ConfigRenderOptions getRenderOptions() {
            return this.render;
        }

        public @NonNull Builder setParseOptions(ConfigParseOptions options) {
            this.parse = options;
            return this;
        }

        public @NonNull ConfigParseOptions getParseOptions() {
            return this.parse;
        }

        @Override
        public @NonNull HoconConfigurationLoader build() {
            return new HoconConfigurationLoader(this);
        }
    }
}

