/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.xalcon.torchmaster.common.CommonProxy;
import net.xalcon.torchmaster.common.EntityFilterRegistry;
import net.xalcon.torchmaster.common.EventHandlerServer;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.ModGuiHandler;
import net.xalcon.torchmaster.common.TorchmasterConfig;
import net.xalcon.torchmaster.common.commands.CommandTorchmasterEntityDump;
import net.xalcon.torchmaster.common.commands.CommandTorchmasterTorchList;
import net.xalcon.torchmaster.common.network.TorchmasterNetwork;
import net.xalcon.torchmaster.compat.EntityFilterRegisterEvent;
import net.xalcon.torchmaster.compat.RegistryBackwardsCompat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="torchmaster", version="1.8.5.0", dependencies="required-after:forge@[14.21.1.2394,)", certificateFingerprint="5e9a436b366831c8f54a7e80b015784da69278c6", acceptedMinecraftVersions="[1.12, 1.13)")
public class TorchMasterMod {
    public static final Logger Log = LogManager.getLogger((String)"torchmaster");
    public static final String MODID = "torchmaster";
    public static final String VERSION = "1.8.5.0";
    private EventHandlerServer eventHandlerServer;
    private ModGuiHandler guiHandler;
    public static final EntityFilterRegistry MegaTorchFilterRegistry = new EntityFilterRegistry();
    public static final EntityFilterRegistry DreadLampFilterRegistry = new EntityFilterRegistry();
    @Mod.Instance
    public static TorchMasterMod instance;
    @SidedProxy(clientSide="net.xalcon.torchmaster.client.ClientProxy", serverSide="net.xalcon.torchmaster.common.CommonProxy")
    public static CommonProxy Proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.eventHandlerServer = new EventHandlerServer();
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandlerServer);
        MinecraftForge.EVENT_BUS.register((Object)new RegistryBackwardsCompat());
        ModCaps.registerModCaps();
        TorchmasterNetwork.initNetwork();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.guiHandler = new ModGuiHandler();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MinecraftForge.EVENT_BUS.post((Event)new EntityFilterRegisterEvent.MegaTorch(MegaTorchFilterRegistry));
        MinecraftForge.EVENT_BUS.post((Event)new EntityFilterRegisterEvent.DreadLamp(DreadLampFilterRegistry));
        Log.info("Applying mega torch entity block list overrides...");
        MegaTorchFilterRegistry.applyListOverrides(TorchmasterConfig.MegaTorchEntityBlockListOverrides);
        Log.info("Applying dread lamp entity block list overrides...");
        DreadLampFilterRegistry.applyListOverrides(TorchmasterConfig.DreadLampEntityBlockListOverrides);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTorchmasterEntityDump());
        event.registerServerCommand((ICommand)new CommandTorchmasterTorchList());
    }
}

