/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.helper;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ReflectionHelper {
    private static Map<Class<?>, Map<String, MethodHandle>> handles = new IdentityHashMap();

    public static <T, C> T getPrivate(Class<? super C> fieldClass, String fieldName, C object) throws ClassCastException {
        try {
            return (T)handles.computeIfAbsent(fieldClass, c -> new HashMap()).computeIfAbsent(fieldName, ReflectionHelper.computeHandle(fieldClass, fieldName)).invoke(object);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, C> T getStatic(Class<? super C> fieldClass, String fieldName) throws ClassCastException {
        try {
            return (T)handles.computeIfAbsent(fieldClass, c -> new HashMap()).computeIfAbsent(fieldName, ReflectionHelper.computeHandle(fieldClass, fieldName)).invoke();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static <C> Function<String, MethodHandle> computeHandle(Class<? super C> fieldClass, String fieldName) {
        return p -> {
            try {
                return MethodHandles.publicLookup().unreflectGetter((Field)Preconditions.checkNotNull((Object)FieldUtils.getField((Class)fieldClass, (String)fieldName, (boolean)true), (String)"Couldn't find field %s of %s.", (Object)fieldName, (Object)fieldClass));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Couldn't access field %s of %s", fieldName, fieldClass), e);
            }
        };
    }
}

