/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.gregtech.tile;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.data.IData;
import crafttweaker.api.formatting.IFormattedText;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.mc1120.world.MCBlockPos;
import eutros.multiblocktweaker.crafttweaker.CustomMultiblock;
import eutros.multiblocktweaker.crafttweaker.functions.IPatternBuilderFunction;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCControllerTile;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCIMultiblockPart;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCPatternMatchContext;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCRecipe;
import eutros.multiblocktweaker.gregtech.recipes.CustomMultiblockRecipeLogic;
import eutros.multiblocktweaker.gregtech.renderer.IBlockStateRenderer;
import gregtech.api.block.machines.BlockMachine;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternError;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.PatternStringError;
import gregtech.api.recipes.Recipe;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class TileControllerCustom
extends RecipeMapMultiblockController {
    public static final String TAG_PERSISTENT = "multiblocktweaker:persistent";
    public final CustomMultiblock multiblock;
    private IPatternBuilderFunction patternBuilderFunction;
    @Nullable
    public IData persistentData;

    public TileControllerCustom(@Nonnull CustomMultiblock multiblock) {
        super(multiblock.loc, multiblock.recipeMap);
        this.multiblock = multiblock;
        this.recipeMapWorkable = new CustomMultiblockRecipeLogic(this);
        this.patternBuilderFunction = multiblock.pattern;
    }

    public CustomMultiblockRecipeLogic getRecipeLogic() {
        return (CustomMultiblockRecipeLogic)this.recipeMapWorkable;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        int eut;
        super.addDisplayText(textList);
        if (this.isStructureFormed() && this.recipeMapWorkable.isWorkingEnabled() && this.recipeMapWorkable.isActive() && (eut = this.recipeMapWorkable.getRecipeEUt()) < 0) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.generation_eu", new Object[]{Math.min((long)(-eut), this.energyContainer.getOutputVoltage())}));
        }
        if (this.multiblock.displayTextFunction == null) {
            return;
        }
        try {
            IFormattedText[] added = this.multiblock.displayTextFunction.addDisplayText(new MCControllerTile(this));
            if (added != null) {
                for (IFormattedText component : added) {
                    textList.add((ITextComponent)new TextComponentString(component.getText()));
                }
            }
        }
        catch (RuntimeException e) {
            this.logFailure("displayTextFunction", e);
            this.multiblock.displayTextFunction = null;
        }
    }

    public void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.energyContainer = new EnergyContainerList(Stream.of(MultiblockAbility.INPUT_ENERGY, MultiblockAbility.OUTPUT_ENERGY).map(arg_0 -> ((TileControllerCustom)this).getAbilities(arg_0)).flatMap(Collection::stream).collect(Collectors.toList()));
        for (IMultiblockPart part : this.getMultiblockParts()) {
            IBlockState blockState;
            ICubeRenderer renderer;
            if (!(part instanceof MetaTileEntity) || !((renderer = this.getBaseTexture(part)) instanceof IBlockStateRenderer) || ((IBlockStateRenderer)renderer).state.func_185914_p() || !((Boolean)(blockState = this.getWorld().func_180495_p(((MetaTileEntity)part).getPos())).func_177229_b((IProperty)BlockMachine.OPAQUE)).booleanValue()) continue;
            this.getWorld().func_175656_a(((MetaTileEntity)part).getPos(), blockState.func_177226_a((IProperty)BlockMachine.OPAQUE, (Comparable)Boolean.valueOf(false)));
        }
        if (this.multiblock.formStructureFunction == null) {
            return;
        }
        try {
            this.multiblock.formStructureFunction.formStructure(new MCControllerTile(this), new MCPatternMatchContext(context));
        }
        catch (RuntimeException e) {
            this.logFailure("formStructureFunction", e);
            this.multiblock.formStructureFunction = null;
        }
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        if (this.multiblock.invalidateStructureFunction != null) {
            try {
                this.multiblock.invalidateStructureFunction.run(new MCControllerTile(this));
            }
            catch (RuntimeException e) {
                this.logFailure("invalidateStructureFunction", e);
                this.multiblock.invalidateStructureFunction = null;
            }
        }
    }

    public boolean checkRecipe(Recipe recipe, boolean consumeIfSuccess) {
        if (this.multiblock.checkRecipeFunction == null) {
            return true;
        }
        try {
            return this.multiblock.checkRecipeFunction.test(new MCControllerTile(this), new MCRecipe(recipe), consumeIfSuccess);
        }
        catch (RuntimeException e) {
            this.logFailure("recipePredicate", e);
            this.multiblock.checkRecipeFunction = null;
            return true;
        }
    }

    public boolean isOpaqueCube() {
        ICubeRenderer renderer = this.getBaseTexture(null);
        if (renderer instanceof IBlockStateRenderer) {
            return ((IBlockStateRenderer)renderer).state.func_185914_p();
        }
        return super.isOpaqueCube();
    }

    public void onRemoval() {
        super.onRemoval();
        if (this.multiblock.removalFunction == null) {
            return;
        }
        try {
            this.multiblock.removalFunction.onRemoval(new MCControllerTile(this));
        }
        catch (RuntimeException e) {
            this.logFailure("removalFunction", e);
            this.multiblock.removalFunction = null;
        }
    }

    private void logFailure(String func, Throwable t) {
        CraftTweakerAPI.logError((String)String.format("Couldn't run %s function of %s.", func, this.multiblock), (Throwable)t);
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        if (this.multiblock.addInformationFunction != null) {
            try {
                tooltip.addAll(Arrays.stream(this.multiblock.addInformationFunction.addTips(new MCControllerTile(this))).collect(Collectors.toList()));
            }
            catch (RuntimeException e) {
                this.logFailure("addInformationFunction", e);
                this.multiblock.addInformationFunction = null;
            }
        }
    }

    public void updateFormedValid() {
        super.updateFormedValid();
        if (this.multiblock.updateFormedValidFunction != null) {
            try {
                this.multiblock.updateFormedValidFunction.run(new MCControllerTile(this));
            }
            catch (RuntimeException e) {
                this.logFailure("updateFormedValidFunction", e);
                this.multiblock.updateFormedValidFunction = null;
            }
        }
    }

    public void causeMaintenanceProblems() {
        super.causeMaintenanceProblems();
    }

    public BlockPattern createStructurePattern() {
        if (this.patternBuilderFunction != null) {
            try {
                return this.patternBuilderFunction.build(new MCControllerTile(this)).getInternal();
            }
            catch (RuntimeException e) {
                this.logFailure("pattern", e);
                this.patternBuilderFunction = null;
            }
        }
        return FactoryBlockPattern.start().aisle(new String[]{"S", "E"}).where('E', TileControllerCustom.tilePredicate((worldState, mte) -> {
            worldState.setError((PatternError)new PatternStringError("MBT controller pattern error"));
            return false;
        }, null)).where('S', this.selfPredicate()).build();
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        if (this.multiblock.designs != null) {
            return this.multiblock.designs;
        }
        return super.getMatchingShapes();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart part) {
        if (this.multiblock.getBaseTextureFunction != null) {
            try {
                return this.multiblock.getBaseTextureFunction.get(new MCControllerTile(this), part instanceof MetaTileEntityMultiblockPart ? new MCIMultiblockPart((MetaTileEntityMultiblockPart)part) : null);
            }
            catch (RuntimeException e) {
                this.logFailure("getBaseTextureFunction", e);
                this.multiblock.getBaseTextureFunction = null;
            }
        }
        return this.multiblock.baseTexture;
    }

    @NotNull
    public ICubeRenderer getFrontOverlay() {
        return this.multiblock.frontOverlay == null ? super.getFrontOverlay() : this.multiblock.frontOverlay;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity holder) {
        return new TileControllerCustom(this.multiblock);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        data = super.writeToNBT(data);
        if (this.persistentData != null) {
            data.func_74782_a(TAG_PERSISTENT, CraftTweakerMC.getNBT((IData)this.persistentData));
        }
        return data;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.persistentData = CraftTweakerMC.getIData((NBTBase)data.func_74781_a(TAG_PERSISTENT));
    }

    public void replaceVariantBlocksActive(boolean isActive) {
        super.replaceVariantBlocksActive(isActive);
    }

    public List<IBlockPos> getVariantActiveBlocks() {
        return this.variantActiveBlocks.stream().map(MCBlockPos::new).collect(Collectors.toList());
    }

    public boolean hasMaintenanceMechanics() {
        return this.multiblock.hasMaintenanceMechanics == null ? super.hasMaintenanceMechanics() : this.multiblock.hasMaintenanceMechanics.booleanValue();
    }

    public boolean hasMufflerMechanics() {
        return this.multiblock.hasMufflerMechanics == null ? super.hasMufflerMechanics() : this.multiblock.hasMufflerMechanics.booleanValue();
    }

    protected boolean allowSameFluidFillForOutputs() {
        return this.multiblock.allowSameFluidFillForOutputs == null ? super.allowSameFluidFillForOutputs() : this.multiblock.allowSameFluidFillForOutputs.booleanValue();
    }

    public boolean canBeDistinct() {
        return this.multiblock.canBeDistinct == null ? super.canBeDistinct() : this.multiblock.canBeDistinct.booleanValue();
    }

    protected boolean shouldShowVoidingModeButton() {
        return this.multiblock.shouldShowVoidingModeButton == null ? super.shouldShowVoidingModeButton() : this.multiblock.shouldShowVoidingModeButton.booleanValue();
    }
}

