/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.gregtech.renderer;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import com.google.common.base.Preconditions;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IICubeRenderer;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.client.renderer.cclop.LightMapOperation;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.common.ConfigHolder;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class SidedCubeRenderer
implements IICubeRenderer {
    private Map<EnumFacing, String> paths;
    @SideOnly(value=Side.CLIENT)
    private Map<EnumFacing, TextureAtlasSprite> sprites;
    @SideOnly(value=Side.CLIENT)
    private Map<EnumFacing, TextureAtlasSprite> spritesEmissive;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite particles;

    public SidedCubeRenderer(String key, Map<EnumFacing, String> paths) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.paths = paths;
            this.sprites = new EnumMap<EnumFacing, TextureAtlasSprite>(EnumFacing.class);
            this.spritesEmissive = new EnumMap<EnumFacing, TextureAtlasSprite>(EnumFacing.class);
        }
        Textures.CUBE_RENDERER_REGISTRY.put(key, this);
        Textures.iconRegisters.add(this);
    }

    public static <T> EnumMap<EnumFacing, T> fillBlanks(Map<EnumFacing, T> map) {
        Preconditions.checkNotNull(map.get(EnumFacing.UP), (Object)"UP side has no texture! Consider using mods.gregtech.multiblock.Builder#withTexture to specify the texture explicitly.");
        EnumMap retMap = new EnumMap(map);
        retMap.computeIfAbsent(EnumFacing.DOWN, k -> retMap.get(EnumFacing.UP));
        retMap.computeIfAbsent(EnumFacing.NORTH, a -> retMap.computeIfAbsent(EnumFacing.EAST, b -> retMap.computeIfAbsent(EnumFacing.SOUTH, c -> retMap.computeIfAbsent(EnumFacing.WEST, k -> retMap.get(EnumFacing.UP)))));
        retMap.computeIfAbsent(EnumFacing.WEST, k -> retMap.get(EnumFacing.NORTH));
        retMap.computeIfAbsent(EnumFacing.SOUTH, k -> retMap.get(EnumFacing.NORTH));
        retMap.computeIfAbsent(EnumFacing.EAST, k -> retMap.get(EnumFacing.NORTH));
        return retMap;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.particles;
    }

    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing side, boolean b, boolean b1) {
        Textures.renderFace((CCRenderState)renderState, (Matrix4)translation, (IVertexOperation[])pipeline, (EnumFacing)side, (Cuboid6)bounds, (TextureAtlasSprite)this.sprites.get(side), (BlockRenderLayer)BlockRenderLayer.CUTOUT_MIPPED);
        if (this.spritesEmissive.get(side) != null) {
            if (ConfigHolder.client.machinesEmissiveTextures) {
                IVertexOperation[] lightPipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new LightMapOperation(240, 240));
                Textures.renderFace((CCRenderState)renderState, (Matrix4)translation, (IVertexOperation[])lightPipeline, (EnumFacing)side, (Cuboid6)bounds, (TextureAtlasSprite)this.spritesEmissive.get(side), (BlockRenderLayer)BloomEffectUtil.getRealBloomLayer());
            } else {
                Textures.renderFace((CCRenderState)renderState, (Matrix4)translation, (IVertexOperation[])pipeline, (EnumFacing)side, (Cuboid6)bounds, (TextureAtlasSprite)this.spritesEmissive.get(side), (BlockRenderLayer)BlockRenderLayer.CUTOUT_MIPPED);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(CCRenderState state, Matrix4 translate, IVertexOperation[] ops, Cuboid6 cuboid) {
        for (EnumFacing side : EnumFacing.values()) {
            this.renderSided(side, cuboid, state, ops, translate);
        }
    }

    @Override
    public void registerIcons(TextureMap textureMap) {
        for (EnumFacing facing : EnumFacing.values()) {
            this.sprites.put(facing, textureMap.func_174942_a(new ResourceLocation(this.paths.get(facing))));
            ResourceLocation emissiveLocation = new ResourceLocation(this.paths.get(facing) + "_emissive");
            if (!ResourceHelper.isTextureExist((ResourceLocation)emissiveLocation)) continue;
            this.spritesEmissive.put(facing, textureMap.func_174942_a(emissiveLocation));
        }
        this.particles = this.sprites.get(EnumFacing.UP);
    }
}

