/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.gregtech.renderer;

import codechicken.lib.render.CCQuad;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.IICubeRenderer;
import gregtech.client.renderer.CubeRendererState;
import gregtech.client.renderer.handler.FacadeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.AdvCCRSConsumer;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.FacadeBlockAccess;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IBlockStateRenderer
implements IICubeRenderer {
    private static final Map<IBlockState, IBlockStateRenderer> CACHE = new Object2ObjectOpenHashMap();
    public final IBlockState state;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite particle;
    @SideOnly(value=Side.CLIENT)
    EnumMap<EnumFacing, List<CCQuad>> itemQuads;

    private IBlockStateRenderer(IBlockState state) {
        this.state = state;
    }

    public static IBlockStateRenderer create(IBlockState state) {
        return CACHE.computeIfAbsent(state, IBlockStateRenderer::new);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleSprite() {
        return this.particle == null ? (this.particle = Minecraft.func_71410_x().func_175602_ab().func_184389_a(this.state).func_177554_e()) : this.particle;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOrientedState(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 bounds, EnumFacing face, boolean b, boolean b1) {
        CubeRendererState rendererState = (CubeRendererState)Textures.RENDER_STATE.get();
        if (rendererState == null || rendererState.layer == null) {
            if (this.itemQuads == null) {
                this.itemQuads = new EnumMap(EnumFacing.class);
                Minecraft minecraft = Minecraft.func_71410_x();
                RenderItem renderItem = minecraft.func_175599_af();
                ItemStack renderStack = new ItemStack(Item.func_150898_a((Block)this.state.func_177230_c()), 1, this.state.func_177230_c().func_180651_a(this.state));
                IBakedModel itemModel = renderItem.func_184393_a(renderStack, null, null);
                for (EnumFacing side : EnumFacing.values()) {
                    ArrayList quads = new ArrayList();
                    if (side == EnumFacing.UP) {
                        quads.addAll(itemModel.func_188616_a(null, null, 0L));
                    }
                    quads.addAll(itemModel.func_188616_a(null, side, 0L));
                    this.itemQuads.put(side, FacadeRenderer.applyItemTint((List)CCQuad.fromArray(quads), (ItemStack)renderStack));
                }
            }
            AdvCCRSConsumer consumer = new AdvCCRSConsumer(renderState);
            for (CCQuad quad : this.itemQuads.get(face)) {
                quad.pipe((IVertexConsumer)consumer);
            }
            return;
        }
        BlockRenderLayer[] layers = rendererState.layer == BlockRenderLayer.CUTOUT_MIPPED ? new BlockRenderLayer[]{BlockRenderLayer.SOLID, BlockRenderLayer.CUTOUT_MIPPED, BlockRenderLayer.CUTOUT} : (rendererState.layer == BlockRenderLayer.TRANSLUCENT ? new BlockRenderLayer[]{BlockRenderLayer.TRANSLUCENT} : (rendererState.layer == BloomEffectUtil.BLOOM ? new BlockRenderLayer[]{BloomEffectUtil.BLOOM} : new BlockRenderLayer[]{}));
        for (BlockRenderLayer layer : layers) {
            if (!this.state.func_177230_c().canRenderInLayer(this.state, layer)) continue;
            BlockPos pos = new BlockPos(translation.m03, translation.m13, translation.m23);
            if (!this.state.func_185894_c(rendererState.world, pos, face)) {
                return;
            }
            FacadeBlockAccess coverAccess = new FacadeBlockAccess(rendererState.world, pos, face, this.state);
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            IBlockState state = this.state;
            try {
                state = state.func_185899_b((IBlockAccess)coverAccess, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IBakedModel model = brd.func_184389_a(state);
            try {
                state = state.func_177230_c().getExtendedState(state, (IBlockAccess)coverAccess, pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long posRand = MathHelper.func_180186_a((Vec3i)pos);
            LinkedList bakedQuads = new LinkedList(model.func_188616_a(state, null, posRand));
            bakedQuads.addAll(model.func_188616_a(state, face, posRand));
            List quads = CCQuad.fromArray(bakedQuads);
            if (!quads.isEmpty()) {
                VertexLighterFlat lighter = FacadeRenderer.setupLighter((CCRenderState)renderState, (Matrix4)translation, (IBlockState)state, (IBlockAccess)coverAccess, (BlockPos)pos, (IBakedModel)model);
                FacadeRenderer.renderBlockQuads((VertexLighterFlat)lighter, (IBlockAccess)coverAccess, (IBlockState)state, (List)quads, (BlockPos)pos);
            }
            return;
        }
    }
}

