/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.world.IFacing;
import crafttweaker.mc1120.world.MCFacing;
import eutros.multiblocktweaker.crafttweaker.brackethandler.CubeRendererBracketHandler;
import eutros.multiblocktweaker.crafttweaker.gtwrap.constants.ConstantOverlayFace;
import eutros.multiblocktweaker.crafttweaker.gtwrap.impl.MCICubeRenderer;
import eutros.multiblocktweaker.gregtech.renderer.IBlockStateRenderer;
import eutros.multiblocktweaker.gregtech.renderer.SidedCubeRenderer;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.SimpleOverlayRenderer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.render.ICubeRenderer")
@ZenRegister
public interface IICubeRenderer
extends ICubeRenderer {
    @ZenMethod
    @Nullable
    public static IICubeRenderer byPath(@NotNull String path) {
        ICubeRenderer renderer = Textures.CUBE_RENDERER_REGISTRY.getOrDefault(path, null);
        if (renderer != null) {
            return new MCICubeRenderer(renderer);
        }
        return null;
    }

    @ZenMethod
    public static IICubeRenderer simpleOverlay(String key, String path) {
        return CubeRendererBracketHandler.cache.computeIfAbsent(key, $ -> new MCICubeRenderer((ICubeRenderer)new SimpleOverlayRenderer(path)));
    }

    @ZenMethod
    public static IICubeRenderer sidedOverlay(String key, Map<IFacing, String> map) {
        EnumMap<EnumFacing, String> result = new EnumMap<EnumFacing, String>(EnumFacing.class);
        for (Map.Entry<IFacing, String> e : map.entrySet()) {
            if (result.put((EnumFacing)e.getKey().getInternal(), e.getValue()) == null) continue;
            CraftTweakerAPI.logError((String)("Duplicate key: " + e.getKey().getName()));
        }
        return CubeRendererBracketHandler.cache.computeIfAbsent(key, $ -> new MCICubeRenderer(new SidedCubeRenderer(key, SidedCubeRenderer.fillBlanks(result))));
    }

    @ZenMethod
    public static IICubeRenderer sidedOverlay(String key, @Nonnull String up, @Optional String north, @Optional String east, @Optional String south, @Optional String west, @Optional String down) {
        HashMap<IFacing, String> builder = new HashMap<IFacing, String>();
        builder.put((IFacing)new MCFacing(EnumFacing.UP), up);
        if (north != null) {
            builder.put((IFacing)new MCFacing(EnumFacing.NORTH), north);
        }
        if (east != null) {
            builder.put((IFacing)new MCFacing(EnumFacing.EAST), east);
        }
        if (west != null) {
            builder.put((IFacing)new MCFacing(EnumFacing.WEST), west);
        }
        if (south != null) {
            builder.put((IFacing)new MCFacing(EnumFacing.SOUTH), south);
        }
        if (down != null) {
            builder.put((IFacing)new MCFacing(EnumFacing.DOWN), down);
        }
        return IICubeRenderer.sidedOverlay(key, builder);
    }

    @ZenMethod
    public static IICubeRenderer orientedOverlay(String key, String path, ConstantOverlayFace ... faces) {
        return CubeRendererBracketHandler.cache.computeIfAbsent(key, $ -> new MCICubeRenderer((ICubeRenderer)new OrientedOverlayRenderer(path, (OrientedOverlayRenderer.OverlayFace[])Arrays.stream(faces).map(f -> f.val).toArray(OrientedOverlayRenderer.OverlayFace[]::new))));
    }

    @ZenMethod
    public static IICubeRenderer fromBlock(IBlock block) {
        return IBlockStateRenderer.create(CraftTweakerMC.getBlock((IBlock)block).func_176223_P());
    }

    @ZenMethod
    public static IICubeRenderer fromBlock(IItemStack stack) {
        return IBlockStateRenderer.create(CraftTweakerMC.getBlock((IItemStack)stack).func_176223_P());
    }

    @ZenMethod
    public static IICubeRenderer fromState(IBlockState state) {
        return IBlockStateRenderer.create(CraftTweakerMC.getBlockState((IBlockState)state));
    }

    @SideOnly(value=Side.CLIENT)
    default public void registerIcons(TextureMap textureMap) {
    }
}

