/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker.construction;

import crafttweaker.annotations.ZenRegister;
import eutros.multiblocktweaker.crafttweaker.gtwrap.constants.ConstantMoveType;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.ISound;
import eutros.multiblocktweaker.crafttweaker.gtwrap.interfaces.ITextureArea;
import eutros.multiblocktweaker.gregtech.recipes.CustomRecipeBuilder;
import eutros.multiblocktweaker.gregtech.recipes.CustomRecipeProperty;
import eutros.multiblocktweaker.gregtech.recipes.RecipeMapMultiblock;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.crafttweaker.CTRecipeBuilder;
import net.minecraft.util.SoundEvent;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.recipe.FactoryRecipeMap")
@ZenRegister
public class RecipeMapBuilder {
    private final String name;
    private int minInputs = 0;
    private int maxInputs = 0;
    private int minOutputs = 0;
    private int maxOutputs = 0;
    private int minFluidInputs = 0;
    private int maxFluidInputs = 0;
    private int minFluidOutputs = 0;
    private int maxFluidOutputs = 0;
    private boolean isHidden = false;
    public CTRecipeBuilder defaultRecipe;
    private final TByteObjectMap<TextureArea> slotOverlays = new TByteObjectHashMap();
    private ProgressWidget.MoveType moveType = null;
    private TextureArea progressBarTexture = null;
    private SoundEvent sound;

    @ZenMethod
    public static CTRecipeBuilder startBuilder(CustomRecipeProperty ... recipeProperties) {
        return new CTRecipeBuilder((RecipeBuilder)new CustomRecipeBuilder(recipeProperties));
    }

    public RecipeMapBuilder(String name, CustomRecipeProperty ... recipeProperties) {
        this.name = name;
        this.defaultRecipe = RecipeMapBuilder.startBuilder(recipeProperties);
    }

    @ZenMethod
    public static RecipeMapBuilder start(String name, CustomRecipeProperty ... recipeProperties) {
        return new RecipeMapBuilder(name, recipeProperties);
    }

    @ZenMethod
    public static RecipeMapBuilder start(String name) {
        return new RecipeMapBuilder(name, new CustomRecipeProperty[0]);
    }

    @ZenMethod
    public RecipeMapBuilder minInputs(int val) {
        this.minInputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder maxInputs(int val) {
        this.maxInputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder minFluidInputs(int val) {
        this.minFluidInputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder maxFluidInputs(int val) {
        this.maxFluidInputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder minOutputs(int val) {
        this.minOutputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder maxOutputs(int val) {
        this.maxOutputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder minFluidOutputs(int val) {
        this.minFluidOutputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder maxFluidOutputs(int val) {
        this.maxFluidOutputs = val;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder setHidden(boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder setDefaultRecipe(CTRecipeBuilder builder) {
        this.defaultRecipe = builder;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder setProgressBar(ITextureArea progressBar, ConstantMoveType moveType) {
        this.progressBarTexture = progressBar.getInternal();
        this.moveType = moveType.delegate;
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder setSlotOverlay(boolean isOutput, boolean isFluid, ITextureArea slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    @ZenMethod
    public RecipeMapBuilder setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, ITextureArea slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay.getInternal());
        return this;
    }

    @ZenMethod
    public RecipeMapBuilder setSound(ISound sound) {
        this.sound = sound == null ? null : sound.getInternal();
        return this;
    }

    @ZenMethod
    public RecipeMap<?> build() {
        RecipeMapMultiblock map = new RecipeMapMultiblock(this.name, this.minInputs, this.maxInputs, this.minOutputs, this.maxOutputs, this.minFluidInputs, this.maxFluidInputs, this.minFluidOutputs, this.maxFluidOutputs, (CustomRecipeBuilder)this.defaultRecipe.backingBuilder, this.isHidden);
        if (this.sound != null) {
            map.setSound(this.sound);
        }
        for (byte key : this.slotOverlays.keys()) {
            map.setSlotOverlay((key & 2) != 0, (key & 1) != 0, (key & 4) != 0, (TextureArea)this.slotOverlays.get(key));
        }
        if (this.progressBarTexture != null && this.moveType != null) {
            map.setProgressBar(this.progressBarTexture, this.moveType);
        }
        return map;
    }
}

