/*
 * Decompiled with CFR 0.152.
 */
package eutros.multiblocktweaker.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import eutros.multiblocktweaker.crafttweaker.CustomMultiblock;
import eutros.multiblocktweaker.gregtech.tile.TileControllerCustom;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.metatileentities.MetaTileEntities;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.multiblock.MultiblockRegistry")
@ZenRegister
public class MultiblockRegistry {
    private static final Int2ObjectMap<CustomMultiblock> metaIdMap = new Int2ObjectOpenHashMap();
    private static final Map<ResourceLocation, CustomMultiblock> resourceLocMap = new HashMap<ResourceLocation, CustomMultiblock>();

    public static void registerMultiblock(@NotNull CustomMultiblock multiblock) {
        resourceLocMap.put(multiblock.loc, multiblock);
        metaIdMap.put(multiblock.metaId, (Object)multiblock);
        MetaTileEntities.registerMetaTileEntity((int)multiblock.metaId, (MetaTileEntity)new TileControllerCustom(multiblock));
    }

    @Nullable
    @ZenMethod
    public static CustomMultiblock get(int metaId) {
        return (CustomMultiblock)metaIdMap.get(metaId);
    }

    @Nullable
    @ZenMethod
    public static CustomMultiblock get(@NotNull String location) {
        ResourceLocation loc = new ResourceLocation(location);
        if (loc.func_110624_b().equals("minecraft")) {
            loc = new ResourceLocation("multiblocktweaker", loc.func_110623_a());
        }
        return MultiblockRegistry.get(loc);
    }

    @ZenMethod
    public static List<CustomMultiblock> all() {
        return new ArrayList<CustomMultiblock>(MultiblockRegistry.getAll());
    }

    @Nullable
    public static CustomMultiblock get(@NotNull ResourceLocation resourceLocation) {
        return resourceLocMap.get(resourceLocation);
    }

    @NotNull
    public static Collection<CustomMultiblock> getAll() {
        return metaIdMap.values();
    }
}

