/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.driver;

import java.util.Arrays;
import java.util.Objects;
import mcjty.lostcities.dimensions.world.driver.IIndex;
import mcjty.lostcities.dimensions.world.driver.IPrimerDriver;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.chunk.ChunkPrimer;

public class OptimizedDriver
implements IPrimerDriver {
    private ChunkPrimer primer;
    private int current;

    @Override
    public void setPrimer(ChunkPrimer primer) {
        this.primer = primer;
    }

    @Override
    public ChunkPrimer getPrimer() {
        return this.primer;
    }

    @Override
    public IPrimerDriver current(int x, int y, int z) {
        this.current = OptimizedDriver.getBlockIndex(x, y, z);
        return this;
    }

    @Override
    public IPrimerDriver current(IIndex index) {
        this.current = ((Index)index).index;
        return this;
    }

    @Override
    public IIndex getCurrent() {
        return new Index(this.current);
    }

    @Override
    public void incY() {
        ++this.current;
    }

    @Override
    public void incY(int amount) {
        this.current += amount;
    }

    @Override
    public void decY() {
        --this.current;
    }

    @Override
    public void incX() {
        this.current += 4096;
    }

    @Override
    public void incZ() {
        this.current += 256;
    }

    @Override
    public int getX() {
        return this.current >> 12 & 0xF;
    }

    @Override
    public int getY() {
        return this.current & 0xFF;
    }

    @Override
    public int getZ() {
        return this.current >> 8 & 0xF;
    }

    @Override
    public void setBlockRange(int x, int y, int z, int y2, char c) {
        int s = OptimizedDriver.getBlockIndex(x, y, z);
        int e = s + y2 - y;
        Arrays.fill(this.primer.field_177860_a, s, e, c);
    }

    @Override
    public void setBlockRangeSafe(int x, int y, int z, int y2, char c) {
        if (y2 <= y) {
            return;
        }
        int s = OptimizedDriver.getBlockIndex(x, y, z);
        int e = s + y2 - y;
        Arrays.fill(this.primer.field_177860_a, s, e, c);
    }

    @Override
    public IPrimerDriver block(char c) {
        this.primer.field_177860_a[this.current] = c;
        return this;
    }

    @Override
    public IPrimerDriver block(IBlockState c) {
        this.primer.field_177860_a[this.current] = (char)Block.field_176229_d.func_148747_b((Object)c);
        return this;
    }

    @Override
    public IPrimerDriver add(char c) {
        this.primer.field_177860_a[this.current++] = c;
        return this;
    }

    @Override
    public char getBlock() {
        return this.primer.field_177860_a[this.current];
    }

    @Override
    public char getBlockDown() {
        return this.primer.field_177860_a[this.current - 1];
    }

    @Override
    public char getBlockEast() {
        return this.primer.field_177860_a[this.current + 4096];
    }

    @Override
    public char getBlockWest() {
        return this.primer.field_177860_a[this.current - 4096];
    }

    @Override
    public char getBlockSouth() {
        return this.primer.field_177860_a[this.current + 256];
    }

    @Override
    public char getBlockNorth() {
        return this.primer.field_177860_a[this.current - 256];
    }

    @Override
    public char getBlock(int x, int y, int z) {
        return this.primer.field_177860_a[OptimizedDriver.getBlockIndex(x, y, z)];
    }

    @Override
    public IIndex getIndex(int x, int y, int z) {
        return new Index(OptimizedDriver.getBlockIndex(x, y, z));
    }

    private static int getBlockIndex(int x, int y, int z) {
        return x << 12 | z << 8 | y;
    }

    @Override
    public IPrimerDriver copy() {
        OptimizedDriver driver = new OptimizedDriver();
        driver.current = this.current;
        driver.primer = this.primer;
        return driver;
    }

    private class Index
    implements IIndex {
        private final int index;

        Index(int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index1 = (Index)o;
            return this.index == index1.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }
    }
}

