/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.config;

import java.util.HashMap;
import java.util.Map;

public enum BiomeSelectionStrategy {
    ORIGINAL("original"),
    RANDOMIZED("randomized"),
    VARIED("varied");

    private final String name;
    private static final Map<String, BiomeSelectionStrategy> NAME_TO_TYPE;

    private BiomeSelectionStrategy(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static BiomeSelectionStrategy getTypeByName(String name) {
        return NAME_TO_TYPE.get(name);
    }

    static {
        NAME_TO_TYPE = new HashMap<String, BiomeSelectionStrategy>();
        for (BiomeSelectionStrategy type : BiomeSelectionStrategy.values()) {
            NAME_TO_TYPE.put(type.getName(), type);
        }
    }
}

