/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.worlddata;

import com.teamwizardry.librarianlib.features.network.PacketCustomWorldData;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.librarianlib.features.network.TargetWorld;
import com.teamwizardry.librarianlib.features.saving.AbstractSaveHandler;
import com.teamwizardry.librarianlib.features.saving.SaveInPlace;
import com.teamwizardry.librarianlib.features.worlddata.WorldDataContainer;
import com.teamwizardry.librarianlib.features.worlddata.WorldDataRegistry;
import com.teamwizardry.librarianlib.features.worlddata.WorldDataRegistryItem;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SaveInPlace
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0013J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0014J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/teamwizardry/librarianlib/features/worlddata/WorldData;", "", "container", "Lcom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer;", "(Lcom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer;)V", "getContainer", "()Lcom/teamwizardry/librarianlib/features/worlddata/WorldDataContainer;", "value", "Lnet/minecraft/util/ResourceLocation;", "name", "getName", "()Lnet/minecraft/util/ResourceLocation;", "setName", "(Lnet/minecraft/util/ResourceLocation;)V", "world", "Lnet/minecraft/world/World;", "getWorld", "()Lnet/minecraft/world/World;", "loadCustomNBT", "", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "loadFromNBT", "tag", "markDirty", "readCustomBytes", "buf", "Lio/netty/buffer/ByteBuf;", "readFromBytes", "saveCustomNBT", "saveToNBT", "writeCustomBytes", "writeToBytes", "Companion", "librarianlib-1.12.2"})
public class WorldData {
    @NotNull
    private final World world;
    @Nullable
    private ResourceLocation name;
    @NotNull
    private final WorldDataContainer container;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final World getWorld() {
        return this.world;
    }

    @Nullable
    public final ResourceLocation getName() {
        return this.name;
    }

    public final void setName(@Nullable ResourceLocation value) {
        if (this.name != null) {
            throw (Throwable)new IllegalStateException("Name already set");
        }
        this.name = value;
    }

    @Nullable
    protected NBTTagCompound saveCustomNBT() {
        return null;
    }

    protected void loadCustomNBT(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull(nbt, "nbt");
    }

    protected void writeCustomBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
    }

    protected void readCustomBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
    }

    public final void markDirty() {
        if (this.world instanceof WorldServer) {
            ResourceLocation resourceLocation = this.name;
            if (resourceLocation == null) {
                Intrinsics.throwNpe();
            }
            PacketCustomWorldData packet = new PacketCustomWorldData(resourceLocation, this);
            PacketHandler.CHANNEL.update(new TargetWorld(this.world), packet);
            this.container.func_76185_a();
        }
    }

    @NotNull
    public final NBTTagCompound saveToNBT(@NotNull NBTTagCompound tag) {
        block0: {
            NBTTagCompound nBTTagCompound;
            Intrinsics.checkParameterIsNotNull(tag, "tag");
            tag.func_74782_a("auto", AbstractSaveHandler.writeAutoNBT(this, false));
            NBTTagCompound nBTTagCompound2 = this.saveCustomNBT();
            if (nBTTagCompound2 == null) break block0;
            NBTTagCompound it = nBTTagCompound = nBTTagCompound2;
            tag.func_74782_a("custom", (NBTBase)it);
        }
        return tag;
    }

    public final void loadFromNBT(@NotNull NBTTagCompound tag) {
        NBTBase nBTBase;
        NBTBase it;
        Intrinsics.checkParameterIsNotNull(tag, "tag");
        NBTBase nBTBase2 = it = (nBTBase = tag.func_74781_a("auto"));
        Intrinsics.checkExpressionValueIsNotNull(nBTBase2, "it");
        AbstractSaveHandler.readAutoNBT(this, nBTBase2, false);
        NBTBase nBTBase3 = it = (nBTBase = tag.func_74775_l("custom"));
        Intrinsics.checkExpressionValueIsNotNull(nBTBase3, "it");
        this.loadCustomNBT((NBTTagCompound)nBTBase3);
    }

    public final void writeToBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
        AbstractSaveHandler.writeAutoBytes(this, buf, false);
        this.writeCustomBytes(buf);
    }

    public final void readFromBytes(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull(buf, "buf");
        AbstractSaveHandler.readAutoBytes(this, buf, false);
        this.readCustomBytes(buf);
    }

    @NotNull
    public final WorldDataContainer getContainer() {
        return this.container;
    }

    public WorldData(@NotNull WorldDataContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, "container");
        this.container = container;
        this.world = this.container.getWorld();
    }

    @JvmStatic
    @Nullable
    public static final <T extends WorldData> T get(@NotNull World world, @NotNull Class<T> type) {
        return Companion.get(world, type);
    }

    @JvmStatic
    @Nullable
    public static final WorldData get(@NotNull World world, @NotNull ResourceLocation name) {
        return Companion.get(world, name);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\b\b\u0000\u0010\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00040\tH\u0007\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001e\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/teamwizardry/librarianlib/features/worlddata/WorldData$Companion;", "", "()V", "get", "T", "Lcom/teamwizardry/librarianlib/features/worlddata/WorldData;", "world", "Lnet/minecraft/world/World;", "type", "Ljava/lang/Class;", "(Lnet/minecraft/world/World;Ljava/lang/Class;)Lcom/teamwizardry/librarianlib/features/worlddata/WorldData;", "name", "Lnet/minecraft/util/ResourceLocation;", "getInternal", "librarianlib-1.12.2"})
    public static final class Companion {
        private final WorldData getInternal(World world, Class<?> type) {
            return WorldDataContainer.Companion.get(world).getDatas().get(type);
        }

        @JvmStatic
        @Nullable
        public final <T extends WorldData> T get(@NotNull World world, @NotNull Class<T> type) {
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(type, "type");
            return (T)this.getInternal(world, type);
        }

        @JvmStatic
        @Nullable
        public final WorldData get(@NotNull World world, @NotNull ResourceLocation name) {
            Intrinsics.checkParameterIsNotNull(world, "world");
            Intrinsics.checkParameterIsNotNull(name, "name");
            Object object = WorldDataRegistry.get(name);
            if (object == null || (object = ((WorldDataRegistryItem)object).getClazz()) == null) {
                return null;
            }
            Object clazz = object;
            return this.getInternal(world, (Class<?>)clazz);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

