/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.particle;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.helpers.Vec3dPool;
import com.teamwizardry.librarianlib.features.particle.ParticleBase;
import com.teamwizardry.librarianlib.features.particle.ParticleRenderInfo;
import com.teamwizardry.librarianlib.features.particle.ParticleRenderManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u0014H&J\u0006\u0010\u001c\u001a\u00020\u0014J\b\u0010\u001d\u001a\u00020\u0014H&J\u0006\u0010\u001e\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/teamwizardry/librarianlib/features/particle/ParticleRenderLayer;", "", "name", "", "shouldSort", "", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "<set-?>", "", "Lcom/teamwizardry/librarianlib/features/particle/ParticleBase;", "particleList", "getParticleList", "()Ljava/util/List;", "setParticleList", "(Ljava/util/List;)V", "getShouldSort", "()Z", "add", "", "particle", "clean", "clear", "render", "renderInfo", "Lcom/teamwizardry/librarianlib/features/particle/ParticleRenderInfo;", "setup", "sort", "teardown", "update", "librarianlib-1.12.2"})
public abstract class ParticleRenderLayer {
    @NotNull
    private List<ParticleBase> particleList;
    @NotNull
    private final String name;
    private final boolean shouldSort;

    @NotNull
    public final List<ParticleBase> getParticleList() {
        return this.particleList;
    }

    private final void setParticleList(List<ParticleBase> list2) {
        this.particleList = list2;
    }

    public abstract void setup();

    public abstract void teardown();

    public final void add(@NotNull ParticleBase particle) {
        Intrinsics.checkParameterIsNotNull(particle, "particle");
        this.particleList.add(particle);
    }

    public final void update() {
        Iterable $receiver$iv = this.particleList;
        for (Object element$iv : $receiver$iv) {
            ParticleBase it = (ParticleBase)element$iv;
            it.onUpdate();
        }
    }

    public final void render(@NotNull ParticleRenderInfo renderInfo) {
        Tessellator tessellator;
        Intrinsics.checkParameterIsNotNull(renderInfo, "renderInfo");
        Tessellator tessellator2 = tessellator = Tessellator.func_178181_a();
        Intrinsics.checkExpressionValueIsNotNull(tessellator2, "tessellator");
        BufferBuilder vb = tessellator2.func_178180_c();
        this.setup();
        Iterable $receiver$iv = this.particleList;
        for (Object element$iv : $receiver$iv) {
            ParticleBase it = (ParticleBase)element$iv;
            BufferBuilder bufferBuilder = vb;
            Intrinsics.checkExpressionValueIsNotNull(bufferBuilder, "vb");
            it.render(bufferBuilder, renderInfo);
        }
        this.teardown();
    }

    public final void clear() {
        this.particleList.clear();
    }

    public final void clean() {
        Iterator<ParticleBase> iter;
        Iterator<ParticleBase> iterator2;
        if (this.particleList.size() > 100000) {
            this.clear();
        }
        Iterator<ParticleBase> iterator3 = iterator2 = (iter = this.particleList.iterator());
        while (iterator3.hasNext()) {
            ParticleBase particle = iterator3.next();
            if (particle.isAlive()) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sort() {
        void y$iv;
        void x$iv;
        if (!this.shouldSort) {
            return;
        }
        float partialTicks = ClientTickHandler.getPartialTicks();
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull(minecraft, "Minecraft.getMinecraft()");
        Entity entity = minecraft.func_175606_aa();
        if (entity == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(entity, "Minecraft.getMinecraft()\u2026enderViewEntity ?: return");
        Entity entity2 = entity;
        double d0 = entity2.field_70142_S + (entity2.field_70165_t - entity2.field_70142_S) * (double)partialTicks;
        double d1 = entity2.field_70137_T + (entity2.field_70163_u - entity2.field_70137_T) * (double)partialTicks;
        double d2 = entity2.field_70136_U + (entity2.field_70161_v - entity2.field_70136_U) * (double)partialTicks;
        double d = d0;
        double d3 = d1;
        double z$iv = d2;
        Vec3d playerPos = Vec3dPool.create((double)x$iv, (double)y$iv, z$iv);
        Vec3d look = playerPos.func_178787_e(entity2.func_70676_i(partialTicks));
        for (ParticleBase particle : this.particleList) {
            Vec3d vec3d = look;
            Intrinsics.checkExpressionValueIsNotNull(vec3d, "look");
            particle.setDepthSquared$librarianlib_1_12_2(ParticleRenderManager.INSTANCE.projectToRay$librarianlib_1_12_2(playerPos, vec3d, particle.getPos()).func_189985_c());
        }
        List<ParticleBase> $receiver$iv = this.particleList;
        if ($receiver$iv.size() > 1) {
            List<ParticleBase> list2 = $receiver$iv;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    ParticleBase it = (ParticleBase)b;
                    Comparable comparable = Double.valueOf(it.getDepthSquared$librarianlib_1_12_2());
                    it = (ParticleBase)a;
                    Comparable comparable2 = comparable;
                    Double d = it.getDepthSquared$librarianlib_1_12_2();
                    return ComparisonsKt.compareValues(comparable2, (Comparable)d);
                }
            };
            CollectionsKt.sortWith(list2, comparator);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getShouldSort() {
        return this.shouldSort;
    }

    public ParticleRenderLayer(@NotNull String name, boolean shouldSort) {
        List list2;
        Intrinsics.checkParameterIsNotNull(name, "name");
        this.name = name;
        this.shouldSort = shouldSort;
        ParticleRenderLayer particleRenderLayer = this;
        particleRenderLayer.particleList = list2 = (List)new ArrayList();
    }
}

