/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.search;

import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.components.ComponentText;
import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.facade.provided.book.search.ISearchAlgorithm;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ComponentSearchResults;", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "results", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "index", "", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;Ljava/util/List;I)V", "margin", "pageHeader", "Lcom/teamwizardry/librarianlib/features/facade/components/ComponentText;", "resultSection", "Companion", "librarianlib-1.12.2"})
public final class ComponentSearchResults
extends GuiComponent {
    private final int margin = 16;
    private final ComponentText pageHeader;
    private GuiComponent resultSection;
    public static final Companion Companion = new Companion(null);

    public ComponentSearchResults(@NotNull IBookGui book, @Nullable List<? extends ISearchAlgorithm.Result> results, int index) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(book, "book");
        super(16, 16, book.getMainBookComponent().getSize().getXi() - 32, book.getMainBookComponent().getSize().getYi() - 32);
        this.margin = 16;
        this.pageHeader = new ComponentText(0, 0, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
        this.resultSection = new GuiComponent(0, this.margin, this.getSize().getXi(), this.getSize().getYi() - this.margin);
        String string = I18n.func_135052_a((String)"librarianlib.book.results.notfound", (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull(string, "I18n.format(\"${Librarian\u2026}.book.results.notfound\")");
        this.pageHeader.setText(string);
        this.pageHeader.setUnicode(true);
        this.pageHeader.setWrap(this.getSize().getXi());
        this.add(this.pageHeader);
        this.add(this.resultSection);
        if (results != null && !(collection = (Collection)results).isEmpty()) {
            ISearchAlgorithm.Result forTyping = results.get(0);
            if (forTyping.isSpecificResult()) {
                String string2;
                if (results.size() == 1) {
                    String string3 = I18n.func_135052_a((String)"librarianlib.book.results.oneresult", (Object[])new Object[0]);
                    string2 = string3;
                    Intrinsics.checkExpressionValueIsNotNull(string3, "I18n.format(\"${Librarian\u2026.book.results.oneresult\")");
                } else {
                    String string4 = I18n.func_135052_a((String)"librarianlib.book.results.nresults", (Object[])new Object[]{results.size()});
                    string2 = string4;
                    Intrinsics.checkExpressionValueIsNotNull(string4, "I18n.format(\"${Librarian\u2026.nresults\", results.size)");
                }
                this.pageHeader.setText(string2);
            } else {
                String string5 = I18n.func_135052_a((String)"librarianlib.book.results.toobroad", (Object[])new Object[]{results.size()});
                Intrinsics.checkExpressionValueIsNotNull(string5, "I18n.format(\"${Librarian\u2026.toobroad\", results.size)");
                this.pageHeader.setText(string5);
            }
            GuiComponent pageComponent = new GuiComponent(0, 0, this.getSize().getXi(), this.getSize().getYi());
            this.resultSection.add(pageComponent);
            double largestFrequency = 0.0;
            double smallestFrequency = Integer.MAX_VALUE;
            for (ISearchAlgorithm.Result result : results) {
                if (result.getFrequency() > largestFrequency) {
                    largestFrequency = result.getFrequency();
                }
                if (!(result.getFrequency() < smallestFrequency)) continue;
                smallestFrequency = result.getFrequency();
            }
            int n = 8;
            int count = -n * index;
            for (ISearchAlgorithm.Result result : results) {
                String exactResult;
                String simplifiedResult;
                TextFormatting color2;
                if (count < 0) {
                    ++count;
                    continue;
                }
                double matchPercentage = Math.round(result.getFrequency() * 100.0);
                if (matchPercentage <= 0.0) continue;
                Entry resultEntry = result.getEntry();
                final ComponentText textComponent = new ComponentText(25, Minecraft.func_71410_x().field_71466_p.field_78288_b + 2, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
                GuiComponent indexButton2 = book.makeNavigationButton(count, resultEntry, (Function1<? super GuiComponent, Unit>)new Function1<GuiComponent, Unit>(textComponent){
                    final /* synthetic */ ComponentText $textComponent;

                    public final void invoke(@NotNull GuiComponent it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        it.add(this.$textComponent);
                    }
                    {
                        this.$textComponent = componentText;
                        super(1);
                    }
                });
                pageComponent.add(indexButton2);
                if (forTyping.isSpecificResult()) {
                    color2 = matchPercentage <= (double)25 ? TextFormatting.DARK_RED : (matchPercentage <= (double)50 ? TextFormatting.YELLOW : (matchPercentage <= (double)75 ? TextFormatting.GREEN : TextFormatting.DARK_GREEN));
                    Intrinsics.checkExpressionValueIsNotNull(I18n.func_135052_a((String)"librarianlib.book.results.match", (Object[])new Object[]{matchPercentage}), "I18n.format(\"${Librarian\u2026.match\", matchPercentage)");
                    Intrinsics.checkExpressionValueIsNotNull(I18n.func_135052_a((String)"librarianlib.book.results.match", (Object[])new Object[]{Math.round(matchPercentage)}), "I18n.format(\"${Librarian\u2026h.round(matchPercentage))");
                } else {
                    String string6;
                    color2 = TextFormatting.RESET;
                    if (result.getFrequency() == 1.0) {
                        String string7 = I18n.func_135052_a((String)"librarianlib.book.results.kwd", (Object[])new Object[0]);
                        string6 = string7;
                        Intrinsics.checkExpressionValueIsNotNull(string7, "I18n.format(\"${Librarian\u2026MODID}.book.results.kwd\")");
                    } else {
                        String string8 = I18n.func_135052_a((String)"librarianlib.book.results.kwds", (Object[])new Object[]{(int)result.getFrequency()});
                        string6 = string8;
                        Intrinsics.checkExpressionValueIsNotNull(string8, "I18n.format(\"${Librarian\u2026ltItem.frequency.toInt())");
                    }
                    exactResult = simplifiedResult = string6;
                }
                textComponent.setUnicode(true);
                textComponent.setText("| " + color2 + simplifiedResult);
                indexButton2.BUS.hook(GuiComponentEvents.MouseMoveInEvent.class, (Function1)new Function1<GuiComponentEvents.MouseMoveInEvent, Unit>(){

                    @Override
                    public final void invoke(@NotNull GuiComponentEvents.MouseMoveInEvent it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        textComponent.setText("  | " + color2 + TextFormatting.ITALIC + exactResult);
                    }
                });
                indexButton2.BUS.hook(GuiComponentEvents.MouseMoveOutEvent.class, (Function1)new Function1<GuiComponentEvents.MouseMoveOutEvent, Unit>(){

                    @Override
                    public final void invoke(@NotNull GuiComponentEvents.MouseMoveOutEvent it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        textComponent.setText("| " + color2 + simplifiedResult);
                    }
                });
                if (++count < n) continue;
                break;
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ComponentSearchResults$Companion;", "", "()V", "numberOfPages", "", "results", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "librarianlib-1.12.2"})
    public static final class Companion {
        public final int numberOfPages(@Nullable List<? extends ISearchAlgorithm.Result> results) {
            if (results == null || results.isEmpty()) {
                return 1;
            }
            double d = (double)results.size() / 8.0;
            return (int)Math.ceil(d);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

