/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class LibLibTransformer
implements IClassTransformer,
Opcodes {
    private static final String ASM_HOOKS = "com/teamwizardry/librarianlib/asm/LibLibAsmHooks";
    private static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();
    private static final String icuDotNotation = "com.ibm.icu";
    private static final String shadedIcuDotNotation = "com.teamwizardry.librarianlib.shade.icu";
    private static final String icuSlashNotation = "com/ibm/icu";
    private static final String shadedIcuSlashNotation = "com/teamwizardry/librarianlib/shade/icu";

    private static byte[] transformRenderItem(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("renderItem", "func_180454_a", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
        MethodSignature sig2 = new MethodSignature("renderEffect", "func_191966_a", "(Lnet/minecraft/client/renderer/block/model/IBakedModel;)V");
        MethodSignature target = new MethodSignature("renderModel", "func_191961_a", "(Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/item/ItemStack;)V");
        byte[] transformedClass = LibLibTransformer.transform(basicClass, sig1, "Item render hook", LibLibTransformer.combine(node -> (node.getOpcode() == 183 || node.getOpcode() == 182) && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderHook", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V", false));
            method.instructions.insert(node, newInstructions);
            return true;
        }));
        transformedClass = LibLibTransformer.transform(transformedClass, sig2, "Enchantment glint glow activation", method -> {
            InsnList instructions = method.instructions;
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, ASM_HOOKS, "INSTANCE", "Lcom/teamwizardry/librarianlib/asm/LibLibAsmHooks;"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, ASM_HOOKS, "maximizeGlowLightmap", "()V", false));
            instructions.insertBefore(instructions.getFirst(), newInstructions);
            return true;
        });
        return LibLibTransformer.transform(transformedClass, sig2, "Enchantment glint glow return", LibLibTransformer.combine(node -> node.getOpcode() == 177, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, ASM_HOOKS, "INSTANCE", "Lcom/teamwizardry/librarianlib/asm/LibLibAsmHooks;"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, ASM_HOOKS, "returnGlowLightmap", "()V", false));
            method.instructions.insertBefore(node, newInstructions);
            return false;
        }));
    }

    private static byte[] transformLayerArmorBase(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("renderEnchantedGlint", "func_188364_a", "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/client/model/ModelBase;FFFFFFF)V");
        byte[] transformedClass = LibLibTransformer.transform(basicClass, sig, "Enchantment glint glow activation", method -> {
            InsnList instructions = method.instructions;
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, ASM_HOOKS, "INSTANCE", "Lcom/teamwizardry/librarianlib/asm/LibLibAsmHooks;"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, ASM_HOOKS, "maximizeGlowLightmap", "()V", false));
            instructions.insertBefore(instructions.getFirst(), newInstructions);
            return true;
        });
        return LibLibTransformer.transform(transformedClass, sig, "Enchantment glint glow return", LibLibTransformer.combine(node -> node.getOpcode() == 177, (method, node) -> {
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, ASM_HOOKS, "INSTANCE", "Lcom/teamwizardry/librarianlib/asm/LibLibAsmHooks;"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, ASM_HOOKS, "returnGlowLightmap", "()V", false));
            method.instructions.insertBefore(node, newInstructions);
            return false;
        }));
    }

    private static byte[] transformBlockRenderDispatcher(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("renderBlock", "func_175018_a", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/BufferBuilder;)Z");
        MethodSignature target1 = new MethodSignature("renderModel", "func_178267_a", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;Z)Z");
        MethodSignature target2 = new MethodSignature("renderFluid", "func_178270_a", "(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;)Z");
        byte[] transformedClass = LibLibTransformer.transform(basicClass, sig, "Block render hook", LibLibTransformer.combine(node -> node.getOpcode() == 182 && target1.matches((MethodInsnNode)node), (method, node) -> {
            boolean deobf = method.name.equals(sig.funcName);
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/BlockRendererDispatcher", deobf ? "blockModelRenderer" : "field_175027_c", "Lnet/minecraft/client/renderer/BlockModelRenderer;"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 6));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderHook", "(Lnet/minecraft/client/renderer/BlockModelRenderer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;)V", false));
            method.instructions.insert(node, newInstructions);
            return true;
        }));
        return LibLibTransformer.transform(transformedClass, sig, "Fluid render hook", LibLibTransformer.combine(node -> node.getOpcode() == 182 && target2.matches((MethodInsnNode)node), (method, node) -> {
            boolean deobf = method.name.equals(sig.funcName);
            InsnList newInstructions = new InsnList();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/client/renderer/BlockRendererDispatcher", deobf ? "fluidRenderer" : "field_175025_e", "Lnet/minecraft/client/renderer/BlockFluidRenderer;"));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "renderHook", "(Lnet/minecraft/client/renderer/BlockFluidRenderer;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;)V", false));
            method.instructions.insert(node, newInstructions);
            return true;
        }));
    }

    private static byte[] transformParticle(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("getBrightnessForRender", "func_189214_a", "(F)I");
        return LibLibTransformer.transform(basicClass, sig, "Potion particle glow", method -> {
            InsnList instructions = method.instructions;
            InsnList newInstructions = new InsnList();
            LabelNode node = new LabelNode();
            newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            newInstructions.add((AbstractInsnNode)new TypeInsnNode(193, "net/minecraft/client/particle/ParticleSpell"));
            newInstructions.add((AbstractInsnNode)new FieldInsnNode(178, ASM_HOOKS, "INSTANCE", "Lcom/teamwizardry/librarianlib/asm/LibLibAsmHooks;"));
            newInstructions.add((AbstractInsnNode)new MethodInsnNode(182, ASM_HOOKS, "usePotionGlow", "()Z", false));
            newInstructions.add((AbstractInsnNode)new InsnNode(126));
            newInstructions.add((AbstractInsnNode)new JumpInsnNode(153, node));
            newInstructions.add((AbstractInsnNode)new LdcInsnNode((Object)0xF000F0));
            newInstructions.add((AbstractInsnNode)new InsnNode(172));
            newInstructions.add((AbstractInsnNode)node);
            instructions.insertBefore(instructions.getFirst(), newInstructions);
            instructions.resetLabels();
            return true;
        });
    }

    private static byte[] transformWorld(byte[] basicClass) {
        MethodSignature sig1 = new MethodSignature("updateEntities", "func_72939_s", "()V");
        MethodSignature sig2 = new MethodSignature("updateEntityWithOptionalForce", "func_72866_a", "(Lnet/minecraft/entity/Entity;Z)V");
        MethodSignature target = new MethodSignature("onUpdate", "func_70071_h_", "()V");
        byte[] transformedClass = LibLibTransformer.transform(basicClass, sig1, "Update hook", LibLibTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList instructions = method.instructions;
            InsnList beforeInstructions = new InsnList();
            InsnList afterInstructions = new InsnList();
            LabelNode notCanceled = new LabelNode();
            LabelNode escapeMethod = new LabelNode();
            beforeInstructions.add((AbstractInsnNode)new InsnNode(89));
            beforeInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "preUpdate", "(Lnet/minecraft/entity/Entity;)Z", false));
            beforeInstructions.add((AbstractInsnNode)new JumpInsnNode(153, notCanceled));
            beforeInstructions.add((AbstractInsnNode)new InsnNode(87));
            beforeInstructions.add((AbstractInsnNode)new JumpInsnNode(167, escapeMethod));
            beforeInstructions.add((AbstractInsnNode)notCanceled);
            beforeInstructions.add((AbstractInsnNode)new InsnNode(89));
            afterInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "postUpdate", "(Lnet/minecraft/entity/Entity;)V", false));
            afterInstructions.add((AbstractInsnNode)escapeMethod);
            instructions.insertBefore(node, beforeInstructions);
            instructions.insert(node, afterInstructions);
            instructions.resetLabels();
            return false;
        }));
        return LibLibTransformer.transform(transformedClass, sig2, "Update hook", LibLibTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList instructions = method.instructions;
            InsnList beforeInstructions = new InsnList();
            InsnList afterInstructions = new InsnList();
            LabelNode notCanceled = new LabelNode();
            LabelNode escapeMethod = new LabelNode();
            beforeInstructions.add((AbstractInsnNode)new InsnNode(89));
            beforeInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "preUpdate", "(Lnet/minecraft/entity/Entity;)Z", false));
            beforeInstructions.add((AbstractInsnNode)new JumpInsnNode(153, notCanceled));
            beforeInstructions.add((AbstractInsnNode)new InsnNode(87));
            beforeInstructions.add((AbstractInsnNode)new JumpInsnNode(167, escapeMethod));
            beforeInstructions.add((AbstractInsnNode)notCanceled);
            beforeInstructions.add((AbstractInsnNode)new InsnNode(89));
            afterInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "postUpdate", "(Lnet/minecraft/entity/Entity;)V", false));
            afterInstructions.add((AbstractInsnNode)escapeMethod);
            instructions.insertBefore(node, beforeInstructions);
            instructions.insert(node, afterInstructions);
            instructions.resetLabels();
            return false;
        }));
    }

    private static byte[] transformNetHandlerPlayServer(byte[] basicClass) {
        MethodSignature sig = new MethodSignature("update", "func_73660_a", "()V");
        MethodSignature target = new MethodSignature("onUpdateEntity", "func_71127_g", "()V");
        return LibLibTransformer.transform(basicClass, sig, "Update hook", LibLibTransformer.combine(node -> node.getOpcode() == 182 && target.matches((MethodInsnNode)node), (method, node) -> {
            InsnList instructions = method.instructions;
            InsnList beforeInstructions = new InsnList();
            InsnList afterInstructions = new InsnList();
            LabelNode notCanceled = new LabelNode();
            LabelNode escapeMethod = new LabelNode();
            beforeInstructions.add((AbstractInsnNode)new InsnNode(89));
            beforeInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "preUpdateMP", "(Lnet/minecraft/entity/player/EntityPlayerMP;)Z", false));
            beforeInstructions.add((AbstractInsnNode)new JumpInsnNode(153, notCanceled));
            beforeInstructions.add((AbstractInsnNode)new InsnNode(87));
            beforeInstructions.add((AbstractInsnNode)new JumpInsnNode(167, escapeMethod));
            beforeInstructions.add((AbstractInsnNode)notCanceled);
            beforeInstructions.add((AbstractInsnNode)new InsnNode(89));
            afterInstructions.add((AbstractInsnNode)new MethodInsnNode(184, ASM_HOOKS, "postUpdateMP", "(Lnet/minecraft/entity/player/EntityPlayerMP;)V", false));
            afterInstructions.add((AbstractInsnNode)escapeMethod);
            instructions.insertBefore(node, beforeInstructions);
            instructions.insert(node, afterInstructions);
            instructions.resetLabels();
            return false;
        }));
    }

    private static byte[] transformICU(String transformedName, byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(cr, 0);
        final AtomicInteger count = new AtomicInteger(0);
        cr.accept(new ClassVisitor(327680, (ClassVisitor)cw){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object cst) {
                if (cst instanceof String) {
                    String tmp = LibLibTransformer.transformICU((String)cst);
                    if (!tmp.equals(cst)) {
                        count.incrementAndGet();
                    }
                    cst = tmp;
                }
                return super.visitField(access, name, desc, signature, cst);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, mv){

                    public void visitLdcInsn(Object cst) {
                        if (cst instanceof String) {
                            String tmp = LibLibTransformer.transformICU((String)cst);
                            if (!tmp.equals(cst)) {
                                count.incrementAndGet();
                            }
                            cst = tmp;
                        }
                        super.visitLdcInsn(cst);
                    }
                };
            }
        }, 0);
        if (count.get() > 0) {
            String[] arr = transformedName.split("\\.");
            LibLibTransformer.log("Shaded " + count.get() + " string constants in " + arr[arr.length - 1]);
        }
        return cw.toByteArray();
    }

    private static String transformICU(String constant) {
        if (constant.startsWith(icuDotNotation)) {
            return shadedIcuDotNotation + constant.substring(icuDotNotation.length());
        }
        if (constant.startsWith(icuSlashNotation)) {
            return shadedIcuSlashNotation + constant.substring(icuSlashNotation.length());
        }
        return constant;
    }

    public static byte[] transform(byte[] basicClass, MethodSignature sig, String simpleDesc, MethodAction action) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        LibLibTransformer.log("Applying Transformation to method (" + sig + ")");
        LibLibTransformer.log("Attempting to insert: " + simpleDesc);
        boolean didAnything = LibLibTransformer.findMethodAndTransform(node, sig, action);
        if (didAnything) {
            SafeClassWriter writer = new SafeClassWriter(2);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        for (MethodNode method : node.methods) {
            if (!sig.matches(method)) continue;
            boolean finish = pred.test(method);
            LibLibTransformer.log("Patch result: " + (finish ? "Success" : "!!!!!!! Failure !!!!!!!"));
            return finish;
        }
        LibLibTransformer.log("Patch result: !!!!!!! Couldn't locate method! !!!!!!!");
        return false;
    }

    public static MethodAction combine(NodeFilter filter2, NodeAction action) {
        return node -> LibLibTransformer.applyOnNode(node, filter2, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter2, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator2 = new InsnArrayIterator(nodes);
        boolean didAny = false;
        while (iterator2.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator2.next();
            if (!filter2.test(anode)) continue;
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    public static MethodAction combineByLast(NodeFilter filter2, NodeAction action) {
        return node -> LibLibTransformer.applyOnNodeByLast(node, filter2, action);
    }

    public static boolean applyOnNodeByLast(MethodNode method, NodeFilter filter2, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator2 = new InsnArrayIterator(nodes, method.instructions.size());
        boolean didAny = false;
        while (iterator2.hasPrevious()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator2.previous();
            if (!filter2.test(anode)) continue;
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    public static MethodAction combineFrontPivot(NodeFilter pivot, NodeFilter filter2, NodeAction action) {
        return node -> LibLibTransformer.applyOnNodeFrontPivot(node, pivot, filter2, action);
    }

    public static boolean applyOnNodeFrontPivot(MethodNode method, NodeFilter pivot, NodeFilter filter2, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator2 = new InsnArrayIterator(nodes);
        int pos2 = 0;
        boolean didAny = false;
        block0: while (iterator2.hasNext()) {
            ++pos2;
            AbstractInsnNode pivotTest = (AbstractInsnNode)iterator2.next();
            if (!pivot.test(pivotTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos2);
            while (internal.hasPrevious()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.previous();
                if (!filter2.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static MethodAction combineBackPivot(NodeFilter pivot, NodeFilter filter2, NodeAction action) {
        return node -> LibLibTransformer.applyOnNodeBackPivot(node, pivot, filter2, action);
    }

    public static boolean applyOnNodeBackPivot(MethodNode method, NodeFilter pivot, NodeFilter filter2, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator2 = new InsnArrayIterator(nodes, method.instructions.size());
        int pos2 = method.instructions.size();
        boolean didAny = false;
        block0: while (iterator2.hasPrevious()) {
            --pos2;
            AbstractInsnNode pivotTest = (AbstractInsnNode)iterator2.previous();
            if (!pivot.test(pivotTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos2);
            while (internal.hasNext()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.next();
                if (!filter2.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static MethodAction combineFrontFocus(NodeFilter focus, NodeFilter filter2, NodeAction action) {
        return node -> LibLibTransformer.applyOnNodeFrontFocus(node, focus, filter2, action);
    }

    public static boolean applyOnNodeFrontFocus(MethodNode method, NodeFilter focus, NodeFilter filter2, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator2 = new InsnArrayIterator(nodes);
        int pos2 = method.instructions.size();
        boolean didAny = false;
        block0: while (iterator2.hasNext()) {
            ++pos2;
            AbstractInsnNode focusTest = (AbstractInsnNode)iterator2.next();
            if (!focus.test(focusTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos2);
            while (internal.hasNext()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.next();
                if (!filter2.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static MethodAction combineBackFocus(NodeFilter focus, NodeFilter filter2, NodeAction action) {
        return node -> LibLibTransformer.applyOnNodeBackFocus(node, focus, filter2, action);
    }

    public static boolean applyOnNodeBackFocus(MethodNode method, NodeFilter focus, NodeFilter filter2, NodeAction action) {
        AbstractInsnNode[] nodes = method.instructions.toArray();
        InsnArrayIterator iterator2 = new InsnArrayIterator(nodes, method.instructions.size());
        int pos2 = method.instructions.size();
        boolean didAny = false;
        block0: while (iterator2.hasPrevious()) {
            --pos2;
            AbstractInsnNode focusTest = (AbstractInsnNode)iterator2.previous();
            if (!focus.test(focusTest)) continue;
            InsnArrayIterator internal = new InsnArrayIterator(nodes, pos2);
            while (internal.hasPrevious()) {
                AbstractInsnNode anode = (AbstractInsnNode)internal.previous();
                if (!filter2.test(anode)) continue;
                didAny = true;
                if (!action.test(method, anode)) continue;
                continue block0;
            }
        }
        return didAny;
    }

    public static void log(String str) {
        LogManager.getLogger((String)"LibrarianLib ASM").info(str);
    }

    public static void prettyPrint(MethodNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        LibLibTransformer.log(sw.toString());
    }

    public static void prettyPrint(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        LibLibTransformer.log(sw.toString());
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            String[] arr = transformedName.split("\\.");
            LibLibTransformer.log("Transforming " + arr[arr.length - 1]);
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        if (transformedName.startsWith(shadedIcuDotNotation)) {
            return LibLibTransformer.transformICU(transformedName, basicClass);
        }
        return basicClass;
    }

    static {
        transformers.put("net.minecraft.client.renderer.RenderItem", LibLibTransformer::transformRenderItem);
        transformers.put("net.minecraft.client.renderer.entity.layers.LayerArmorBase", LibLibTransformer::transformLayerArmorBase);
        transformers.put("net.minecraft.client.renderer.BlockRendererDispatcher", LibLibTransformer::transformBlockRenderDispatcher);
        transformers.put("net.minecraft.client.particle.Particle", LibLibTransformer::transformParticle);
        transformers.put("net.minecraft.world.World", LibLibTransformer::transformWorld);
        transformers.put("net.minecraft.network.NetHandlerPlayServer", LibLibTransformer::transformNetHandlerPlayServer);
    }

    public static class SafeClassWriter
    extends ClassWriter {
        public SafeClassWriter(int flags) {
            super(flags);
        }

        public SafeClassWriter(ClassReader classReader, int flags) {
            super(classReader, flags);
        }

        protected String getCommonSuperClass(String type1, String type2) {
            return "java/lang/Object";
        }
    }

    public static class FieldSignature {
        private final String fieldName;
        private final String srgName;
        private final String fieldDesc;

        public FieldSignature(String fieldName, String srgName, String fieldDesc) {
            this.fieldName = fieldName;
            this.srgName = srgName;
            this.fieldDesc = fieldDesc;
        }

        public String toString() {
            return "Names [" + this.fieldName + ", " + this.srgName + "] Descriptor " + this.fieldDesc;
        }

        public boolean matches(String fieldName, String fieldDesc) {
            return (fieldName.equals(this.fieldName) || fieldName.equals(this.srgName)) && fieldDesc.equals(this.fieldDesc);
        }

        public boolean matches(FieldInsnNode field) {
            return this.matches(field.name, field.desc);
        }

        public boolean matches(FieldNode field) {
            return this.matches(field.name, field.desc);
        }
    }

    public static class MethodSignature {
        private final String funcName;
        private final String srgName;
        private final String funcDesc;

        public MethodSignature(String funcName, String srgName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.funcDesc = funcDesc;
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + "] Descriptor " + this.funcDesc;
        }

        public boolean matches(String methodName, String methodDesc) {
            return (methodName.equals(this.funcName) || methodName.equals(this.srgName)) && methodDesc.equals(this.funcDesc);
        }

        public boolean matches(MethodNode method) {
            return this.matches(method.name, method.desc);
        }

        public boolean matches(MethodInsnNode method) {
            return this.matches(method.name, method.desc);
        }
    }

    private static class InsnArrayIterator
    implements ListIterator<AbstractInsnNode> {
        private final AbstractInsnNode[] array;
        private int index;

        public InsnArrayIterator(AbstractInsnNode[] array) {
            this(array, 0);
        }

        public InsnArrayIterator(AbstractInsnNode[] array, int index) {
            this.array = array;
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.array.length > this.index + 1 && this.index >= 0;
        }

        @Override
        public AbstractInsnNode next() {
            if (this.hasNext()) {
                return this.array[++this.index];
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0 && this.index <= this.array.length;
        }

        @Override
        public AbstractInsnNode previous() {
            if (this.hasPrevious()) {
                return this.array[--this.index];
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.hasNext() ? this.index + 1 : this.array.length;
        }

        @Override
        public int previousIndex() {
            return this.hasPrevious() ? this.index - 1 : 0;
        }

        @Override
        public void remove() {
            throw new Error("Unimplemented");
        }

        @Override
        public void set(AbstractInsnNode e) {
            throw new Error("Unimplemented");
        }

        @Override
        public void add(AbstractInsnNode e) {
            throw new Error("Unimplemented");
        }
    }

    public static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    public static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    public static interface MethodAction
    extends Predicate<MethodNode> {
    }

    public static interface Transformer
    extends Function<byte[], byte[]> {
    }
}

