/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.recipe;

import com.google.common.collect.ImmutableList;
import gregtech.api.GTValues;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.BlastProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.ItemMaterialInfo;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;

public class RecyclingRecipes {
    private static final List<OrePrefix> DUST_ORDER = ImmutableList.of((Object)OrePrefix.dust, (Object)OrePrefix.dustSmall, (Object)OrePrefix.dustTiny);
    private static final List<OrePrefix> INGOT_ORDER = ImmutableList.of((Object)OrePrefix.block, (Object)OrePrefix.ingot, (Object)OrePrefix.nugget);

    public static void init() {
        for (Map.Entry<ItemStack, ItemMaterialInfo> entry : OreDictUnifier.getAllItemInfos()) {
            ItemStack itemStack = entry.getKey();
            ItemMaterialInfo materialInfo = entry.getValue();
            ArrayList<MaterialStack> materialStacks = new ArrayList<MaterialStack>((Collection<MaterialStack>)materialInfo.getMaterials());
            RecyclingRecipes.registerRecyclingRecipes(itemStack, materialStacks, false, null);
        }
    }

    public static void registerRecyclingRecipes(ItemStack input, List<MaterialStack> components, boolean ignoreArcSmelting, @Nullable OrePrefix prefix) {
        List materials = components.stream().filter(stack -> stack.material.hasProperty(PropertyKey.DUST)).filter(stack -> stack.amount >= 403200L).sorted(Comparator.comparingLong(ms -> -ms.amount)).collect(Collectors.toList());
        if (materials.isEmpty()) {
            return;
        }
        int voltageMultiplier = RecyclingRecipes.calculateVoltageMultiplier(components);
        if (prefix != OrePrefix.dust) {
            RecyclingRecipes.registerMaceratorRecycling(input, components, voltageMultiplier);
        }
        if (prefix != null) {
            RecyclingRecipes.registerExtractorRecycling(input, components, voltageMultiplier, prefix);
        }
        if (ignoreArcSmelting) {
            return;
        }
        if (components.size() == 1) {
            Material m = components.get((int)0).material;
            if (!m.hasProperty(PropertyKey.INGOT)) {
                return;
            }
            if (OreDictUnifier.getPrefix(input) == OrePrefix.ingot && m.getProperty(PropertyKey.INGOT).getArcSmeltInto() == m) {
                return;
            }
            if (prefix == OrePrefix.dust && m.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                return;
            }
        }
        RecyclingRecipes.registerArcRecycling(input, components, prefix);
    }

    private static void registerMaceratorRecycling(ItemStack input, List<MaterialStack> materials, int multiplier) {
        List<ItemStack> outputs = RecyclingRecipes.finalizeOutputs(materials, RecipeMaps.MACERATOR_RECIPES.getMaxOutputs(), OreDictUnifier::getDust);
        if (outputs.size() == 0) {
            return;
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.MACERATOR_RECIPES.recipeBuilder().inputs(input.func_77946_l())).outputs(outputs)).duration(RecyclingRecipes.calculateDuration(outputs))).EUt(2 * multiplier)).buildAndRegister();
    }

    private static void registerExtractorRecycling(ItemStack input, List<MaterialStack> materials, int multiplier, @Nullable OrePrefix prefix) {
        if (prefix != null && prefix.secondaryMaterials.isEmpty()) {
            MaterialStack ms2 = OreDictUnifier.getMaterial(input);
            if (ms2 == null || ms2.material == null) {
                return;
            }
            Material m = ms2.material;
            if (m.hasProperty(PropertyKey.INGOT) && m.getProperty(PropertyKey.INGOT).getMacerateInto() != m) {
                m = m.getProperty(PropertyKey.INGOT).getMacerateInto();
            }
            if (!m.hasProperty(PropertyKey.FLUID) || prefix == OrePrefix.dust && m.hasProperty(PropertyKey.BLAST)) {
                return;
            }
            ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(input.func_77946_l())).fluidOutputs(m.getFluid((int)(ms2.amount * 144L / 3628800L)))).duration((int)Math.max(1L, ms2.amount * ms2.material.getMass() / 3628800L))).EUt(GTValues.VA[1] * multiplier)).buildAndRegister();
            return;
        }
        MaterialStack fluidMs = materials.stream().filter(ms -> ms.material.hasProperty(PropertyKey.FLUID)).findFirst().orElse(null);
        if (fluidMs == null) {
            return;
        }
        MaterialStack itemMs = materials.stream().filter(ms -> !ms.material.equals(fluidMs.material)).findFirst().orElse(null);
        long duration = fluidMs.amount * fluidMs.material.getMass();
        if (itemMs != null) {
            duration += itemMs.amount * itemMs.material.getMass();
        }
        duration = Math.max(1L, duration / 3628800L);
        Object extractorBuilder = ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.EXTRACTOR_RECIPES.recipeBuilder().inputs(input.func_77946_l())).fluidOutputs(fluidMs.material.getFluid((int)(fluidMs.amount * 144L / 3628800L)))).duration((int)duration)).EUt(GTValues.VA[1] * multiplier);
        if (itemMs != null) {
            OrePrefix outputPrefix = itemMs.material.hasProperty(PropertyKey.INGOT) ? OrePrefix.ingot : OrePrefix.dust;
            ((RecipeBuilder)extractorBuilder).output(outputPrefix, itemMs.material, (int)(itemMs.amount / 3628800L));
        }
        ((RecipeBuilder)extractorBuilder).buildAndRegister();
    }

    private static void registerArcRecycling(ItemStack input, List<MaterialStack> materials, @Nullable OrePrefix prefix) {
        MaterialStack ms = OreDictUnifier.getMaterial(input);
        if (prefix == OrePrefix.dust && ms != null && ms.material.hasProperty(PropertyKey.BLAST)) {
            return;
        }
        if (prefix == OrePrefix.block) {
            if (ms != null && !ms.material.hasProperty(PropertyKey.GEM)) {
                ItemStack output = OreDictUnifier.get(OrePrefix.ingot, ms.material.getProperty(PropertyKey.INGOT).getArcSmeltInto(), 9);
                ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ARC_FURNACE_RECIPES.recipeBuilder().inputs(input.func_77946_l())).outputs(output)).duration(RecyclingRecipes.calculateDuration(Collections.singletonList(output)))).EUt(GTValues.VA[1])).buildAndRegister();
            }
            return;
        }
        List<ItemStack> outputs = RecyclingRecipes.finalizeOutputs(materials = RecyclingRecipes.combineStacks(materials.stream().map(RecyclingRecipes::getArcSmeltingResult).filter(Objects::nonNull).collect(Collectors.toList())), RecipeMaps.ARC_FURNACE_RECIPES.getMaxOutputs(), RecyclingRecipes::getArcIngotOrDust);
        if (outputs.size() == 0) {
            return;
        }
        ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)RecipeMaps.ARC_FURNACE_RECIPES.recipeBuilder().inputs(input.func_77946_l())).outputs(outputs)).duration(RecyclingRecipes.calculateDuration(outputs))).EUt(GTValues.VA[1])).buildAndRegister();
    }

    private static MaterialStack getArcSmeltingResult(MaterialStack materialStack) {
        Material arcSmelt;
        Material material = materialStack.material;
        long amount = materialStack.amount;
        if (material.hasFlag(MaterialFlags.EXPLOSIVE)) {
            return new MaterialStack(Materials.Ash, amount / 16L);
        }
        if (material.hasFlag(MaterialFlags.FLAMMABLE)) {
            return new MaterialStack(Materials.Ash, amount / 8L);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            return RecyclingRecipes.getGemArcSmeltResult(materialStack);
        }
        if (material.hasFlag(MaterialFlags.NO_SMELTING)) {
            return null;
        }
        if (material.hasProperty(PropertyKey.INGOT) && (arcSmelt = material.getProperty(PropertyKey.INGOT).getArcSmeltInto()) != null) {
            return new MaterialStack(arcSmelt, amount);
        }
        return materialStack;
    }

    private static ItemStack getArcIngotOrDust(@Nonnull MaterialStack stack) {
        if (stack.material == Materials.Carbon) {
            return OreDictUnifier.getDust(stack);
        }
        return OreDictUnifier.getIngotOrDust(stack);
    }

    private static MaterialStack getGemArcSmeltResult(MaterialStack materialStack) {
        Material material = materialStack.material;
        long amount = materialStack.amount;
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material == Materials.Oxygen)) {
            return new MaterialStack(Materials.Ash, amount / 8L);
        }
        if (material.getMaterialComponents().stream().anyMatch(stack -> stack.material == Materials.Carbon)) {
            return new MaterialStack(Materials.Carbon, amount / 8L);
        }
        return new MaterialStack(Materials.DarkAsh, amount / 8L);
    }

    private static int calculateVoltageMultiplier(List<MaterialStack> materials) {
        int highestTemp = 0;
        for (MaterialStack ms : materials) {
            BlastProperty prop;
            Material m = ms.material;
            if (m.hasProperty(PropertyKey.BLAST)) {
                prop = m.getProperty(PropertyKey.BLAST);
                if (prop.getBlastTemperature() <= highestTemp) continue;
                highestTemp = prop.getBlastTemperature();
                continue;
            }
            if (!m.hasFlag(MaterialFlags.IS_MAGNETIC) || !m.hasProperty(PropertyKey.INGOT) || !m.getProperty(PropertyKey.INGOT).getSmeltingInto().hasProperty(PropertyKey.BLAST) || (prop = m.getProperty(PropertyKey.INGOT).getSmeltingInto().getProperty(PropertyKey.BLAST)).getBlastTemperature() <= highestTemp) continue;
            highestTemp = prop.getBlastTemperature();
        }
        if (highestTemp == 0) {
            return 1;
        }
        if (highestTemp < 2000) {
            return 4;
        }
        return 16;
    }

    private static int calculateDuration(List<ItemStack> materials) {
        long duration = 0L;
        for (ItemStack is : materials) {
            MaterialStack ms = OreDictUnifier.getMaterial(is);
            if (ms == null) continue;
            duration += ms.amount * ms.material.getMass() * (long)is.func_190916_E();
        }
        return (int)Math.max(1L, duration / 3628800L);
    }

    private static List<MaterialStack> combineStacks(List<MaterialStack> rawList) {
        HashMap<Material, Long> materialStacksExploded = new HashMap<Material, Long>();
        for (MaterialStack ms : rawList) {
            long amount = materialStacksExploded.getOrDefault(ms.material, 0L);
            materialStacksExploded.put(ms.material, ms.amount + amount);
        }
        return materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue())).collect(Collectors.toList());
    }

    private static List<ItemStack> finalizeOutputs(List<MaterialStack> materials, int maxOutputs, Function<MaterialStack, ItemStack> toItemStackMapper) {
        ArrayList<Tuple<ItemStack, MaterialStack>> outputs = new ArrayList<Tuple<ItemStack, MaterialStack>>();
        for (MaterialStack materialStack : materials) {
            ItemStack itemStack = toItemStackMapper.apply(materialStack);
            if (itemStack == ItemStack.field_190927_a) continue;
            if (itemStack.func_190916_E() > 64) {
                UnificationEntry entry = OreDictUnifier.getUnificationEntry(itemStack);
                if (entry == null) continue;
                OrePrefix prefix = entry.orePrefix;
                if (prefix == OrePrefix.block || prefix == OrePrefix.dust) {
                    RecyclingRecipes.splitStacks(outputs, itemStack, entry);
                    continue;
                }
                ArrayList<Tuple<ItemStack, MaterialStack>> split = new ArrayList<Tuple<ItemStack, MaterialStack>>();
                ArrayList<Tuple<ItemStack, MaterialStack>> shrink = new ArrayList<Tuple<ItemStack, MaterialStack>>();
                RecyclingRecipes.splitStacks(split, itemStack, entry);
                RecyclingRecipes.shrinkStacks(shrink, itemStack, entry);
                if (((MaterialStack)((Tuple)split.get((int)0)).func_76340_b()).amount > ((MaterialStack)((Tuple)shrink.get((int)0)).func_76340_b()).amount) {
                    outputs.addAll(split);
                    continue;
                }
                outputs.addAll(shrink);
                continue;
            }
            outputs.add(new Tuple((Object)itemStack, (Object)materialStack));
        }
        outputs.sort(Comparator.comparingLong(e -> -((MaterialStack)e.func_76340_b()).amount));
        HashMap<Object, Object> temp = new HashMap<Object, Object>();
        for (Tuple tuple : outputs) {
            boolean isInMap = false;
            for (MaterialStack ms : temp.keySet()) {
                if (ms.material != ((MaterialStack)tuple.func_76340_b()).material) continue;
                isInMap = true;
                break;
            }
            if (isInMap) continue;
            temp.put(tuple.func_76340_b(), tuple.func_76341_a());
        }
        temp.putAll(outputs.stream().filter(t -> !temp.containsKey(t.func_76340_b())).collect(Collectors.toMap(Tuple::func_76340_b, Tuple::func_76341_a)));
        List list = temp.entrySet().stream().filter(e -> RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount)).map(Map.Entry::getValue).collect(Collectors.toList());
        List<ItemStack> list2 = temp.entrySet().stream().sorted(Comparator.comparingLong(e -> -((MaterialStack)e.getKey()).amount)).filter(e -> !RecyclingRecipes.isAshMaterial((MaterialStack)e.getKey())).limit(maxOutputs).map(Map.Entry::getValue).collect(Collectors.toList());
        for (int i = 0; i < list.size() && list2.size() < maxOutputs; ++i) {
            list2.add((ItemStack)list.get(i));
        }
        return list2;
    }

    private static void splitStacks(List<Tuple<ItemStack, MaterialStack>> list, ItemStack originalStack, UnificationEntry entry) {
        int amount;
        for (amount = originalStack.func_190916_E(); amount > 64; amount -= 64) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)GTUtility.copyAmount(64, originalStack), (Object)new MaterialStack(entry.material, entry.orePrefix.getMaterialAmount(entry.material) * 64L)));
        }
        list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)GTUtility.copyAmount(amount, originalStack), (Object)new MaterialStack(entry.material, entry.orePrefix.getMaterialAmount(entry.material) * (long)amount)));
    }

    private static void shrinkStacks(List<Tuple<ItemStack, MaterialStack>> list, ItemStack originalStack, UnificationEntry entry) {
        long singleStackAmount;
        Material material = entry.material;
        long materialAmount = (long)originalStack.func_190916_E() * entry.orePrefix.getMaterialAmount(material);
        List<OrePrefix> chosenList = material.hasProperty(PropertyKey.INGOT) ? INGOT_ORDER : DUST_ORDER;
        HashMap<OrePrefix, MaterialStack> tempList = new HashMap<OrePrefix, MaterialStack>();
        for (OrePrefix prefix : chosenList) {
            if (materialAmount / prefix.getMaterialAmount(material) == 0L) continue;
            long newAmount = materialAmount / prefix.getMaterialAmount(material);
            tempList.put(prefix, new MaterialStack(material, newAmount * prefix.getMaterialAmount(material)));
            materialAmount %= prefix.getMaterialAmount(material);
        }
        if (tempList.containsKey(chosenList.get(0))) {
            OrePrefix prefix = chosenList.get(0);
            MaterialStack ms = (MaterialStack)tempList.get(prefix);
            RecyclingRecipes.splitStacks(list, OreDictUnifier.get(chosenList.get(0), ms.material, (int)(ms.amount / prefix.getMaterialAmount(material))), new UnificationEntry(prefix, material));
        }
        OrePrefix mediumPrefix = chosenList.get(1);
        OrePrefix smallestPrefix = chosenList.get(2);
        MaterialStack mediumMS = (MaterialStack)tempList.get(mediumPrefix);
        MaterialStack smallestMS = (MaterialStack)tempList.get(smallestPrefix);
        if (mediumMS != null && smallestMS != null && (singleStackAmount = mediumMS.amount + smallestMS.amount) / smallestPrefix.getMaterialAmount(material) <= 64L) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)OreDictUnifier.get(smallestPrefix, material, (int)(singleStackAmount / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, singleStackAmount)));
            return;
        }
        if (mediumMS != null) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)OreDictUnifier.get(mediumPrefix, material, (int)(mediumMS.amount / mediumPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, mediumMS.amount)));
        }
        if (smallestMS != null) {
            list.add((Tuple<ItemStack, MaterialStack>)new Tuple((Object)OreDictUnifier.get(smallestPrefix, material, (int)(smallestMS.amount / smallestPrefix.getMaterialAmount(material))), (Object)new MaterialStack(material, smallestMS.amount)));
        }
    }

    private static boolean isAshMaterial(MaterialStack ms) {
        return ms.material == Materials.Ash || ms.material == Materials.DarkAsh || ms.material == Materials.Carbon;
    }
}

