/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.theoneprobe.provider;

import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IWorkable;
import gregtech.integration.theoneprobe.provider.CapabilityInfoProvider;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.Capability;

public class WorkableInfoProvider
extends CapabilityInfoProvider<IWorkable> {
    public String getID() {
        return "gregtech:workable_provider";
    }

    @Override
    @Nonnull
    protected Capability<IWorkable> getCapability() {
        return GregtechTileCapabilities.CAPABILITY_WORKABLE;
    }

    @Override
    protected void addProbeInfo(@Nonnull IWorkable capability, @Nonnull IProbeInfo probeInfo, @Nonnull EntityPlayer player, @Nonnull TileEntity tileEntity, @Nonnull IProbeHitData data) {
        String text;
        if (!capability.isActive()) {
            return;
        }
        int currentProgress = capability.getProgress();
        int maxProgress = capability.getMaxProgress();
        if (maxProgress < 20) {
            text = " / " + maxProgress + " t";
        } else {
            currentProgress = Math.round((float)currentProgress / 20.0f);
            maxProgress = Math.round((float)maxProgress / 20.0f);
            text = " / " + maxProgress + " s";
        }
        if (maxProgress > 0) {
            int color = capability.isWorkingEnabled() ? -11748585 : -4514776;
            probeInfo.progress(currentProgress, maxProgress, probeInfo.defaultProgressStyle().suffix(text).filledColor(color).alternateFilledColor(color).borderColor(-11184811));
        }
    }
}

