/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.utils.render;

import gregtech.api.util.TextFormattingUtil;
import gregtech.client.utils.RenderUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.plugins.vanilla.ingredients.fluid.FluidStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackTextRenderer
extends FluidStackRenderer {
    private boolean notConsumed = false;

    public FluidStackTextRenderer(int capacityMb, boolean showCapacity, int width, int height, @Nullable IDrawable overlay) {
        super(capacityMb, showCapacity, width, height, overlay);
    }

    public FluidStackTextRenderer setNotConsumed(boolean notConsumed) {
        this.notConsumed = notConsumed;
        return this;
    }

    public void render(@Nonnull Minecraft minecraft, int xPosition, int yPosition, @Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return;
        }
        GlStateManager.func_179084_k();
        RenderUtil.drawFluidForGui(fluidStack, fluidStack.amount, xPosition, yPosition, 17, 17);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)1.0);
        String s = TextFormattingUtil.formatLongToCompactString(fluidStack.amount, 4) + "L";
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175063_a(s, (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a(s) + 19), (float)((yPosition + 11) * 2), 0xFFFFFF);
        if (this.notConsumed) {
            fontRenderer.func_175063_a("NC", (float)((xPosition + 6) * 2 - fontRenderer.func_78256_a("NC") + 19), (float)((yPosition + 1) * 2), 0xFFFFFF);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
    }
}

