/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe.primitive;

import com.google.common.collect.ImmutableList;
import gregtech.api.recipes.Recipe;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.info.MaterialFlags;
import gregtech.api.unification.material.properties.OreProperty;
import gregtech.api.unification.material.properties.PropertyKey;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.metatileentities.MetaTileEntities;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class OreByProduct
implements IRecipeWrapper {
    private static final List<OrePrefix> ORES = new ArrayList<OrePrefix>();
    private static final ImmutableList<OrePrefix> IN_PROCESSING_STEPS = ImmutableList.of((Object)OrePrefix.crushed, (Object)OrePrefix.crushedPurified, (Object)OrePrefix.dustImpure, (Object)OrePrefix.dustPure, (Object)OrePrefix.crushedCentrifuged);
    private static ImmutableList<ItemStack> ALWAYS_MACHINES;
    private final Int2ObjectMap<Recipe.ChanceEntry> chances = new Int2ObjectOpenHashMap();
    private final List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private final List<List<ItemStack>> outputs = new ArrayList<List<ItemStack>>();
    private final List<List<FluidStack>> fluidInputs = new ArrayList<List<FluidStack>>();
    private boolean hasDirectSmelt = false;
    private boolean hasChemBath = false;
    private boolean hasSeparator = false;
    private boolean hasSifter = false;
    private int currentSlot;

    public static void addOreByProductPrefix(OrePrefix orePrefix) {
        if (!ORES.contains(orePrefix)) {
            ORES.add(orePrefix);
        }
    }

    public OreByProduct(Material material) {
        ArrayList<FluidStack> washedFluid;
        if (ALWAYS_MACHINES == null) {
            ALWAYS_MACHINES = ImmutableList.of((Object)MetaTileEntities.MACERATOR[1].getStackForm(), (Object)MetaTileEntities.MACERATOR[1].getStackForm(), (Object)MetaTileEntities.CENTRIFUGE[1].getStackForm(), (Object)MetaTileEntities.ORE_WASHER[1].getStackForm(), (Object)MetaTileEntities.THERMAL_CENTRIFUGE[1].getStackForm(), (Object)MetaTileEntities.MACERATOR[1].getStackForm(), (Object)MetaTileEntities.MACERATOR[1].getStackForm(), (Object)MetaTileEntities.CENTRIFUGE[1].getStackForm());
        }
        OreProperty property = material.getProperty(PropertyKey.ORE);
        int oreMultiplier = property.getOreMultiplier();
        int byproductMultiplier = property.getByProductMultiplier();
        this.currentSlot = 0;
        Material[] byproducts = new Material[]{GTUtility.selectItemInList(0, material, property.getOreByProducts(), Material.class), GTUtility.selectItemInList(1, material, property.getOreByProducts(), Material.class), GTUtility.selectItemInList(2, material, property.getOreByProducts(), Material.class), GTUtility.selectItemInList(3, material, property.getOreByProducts(), Material.class)};
        Pair<Material, Integer> washedIn = property.getWashedIn();
        List<Material> separatedInto = property.getSeparatedInto();
        ArrayList oreStacks = new ArrayList();
        for (OrePrefix prefix : ORES) {
            oreStacks.addAll(OreDictionary.getOres((String)(prefix.name() + material.toCamelCaseString())));
        }
        this.inputs.add(oreStacks);
        ArrayList<ItemStack> simpleWashers = new ArrayList<ItemStack>();
        simpleWashers.add(new ItemStack(Items.field_151066_bu));
        simpleWashers.add(MetaTileEntities.ORE_WASHER[1].getStackForm());
        if (!material.hasProperty(PropertyKey.BLAST)) {
            this.addToInputs(new ItemStack(Blocks.field_150460_al));
            this.hasDirectSmelt = true;
        } else {
            this.addToInputs(ItemStack.field_190927_a);
        }
        for (ItemStack stack : ALWAYS_MACHINES) {
            this.addToInputs(stack);
        }
        this.inputs.add(simpleWashers);
        this.inputs.add(simpleWashers);
        this.inputs.add(simpleWashers);
        if (washedIn != null && washedIn.getKey() != null) {
            this.hasChemBath = true;
            this.addToInputs(MetaTileEntities.CHEMICAL_BATH[1].getStackForm());
        } else {
            this.addToInputs(ItemStack.field_190927_a);
        }
        if (separatedInto != null && !separatedInto.isEmpty()) {
            this.hasSeparator = true;
            this.addToInputs(MetaTileEntities.ELECTROMAGNETIC_SEPARATOR[1].getStackForm());
        } else {
            this.addToInputs(ItemStack.field_190927_a);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            this.hasSifter = true;
            this.addToInputs(MetaTileEntities.SIFTER[1].getStackForm());
        } else {
            this.addToInputs(ItemStack.field_190927_a);
        }
        for (OrePrefix prefix : IN_PROCESSING_STEPS) {
            ArrayList<ItemStack> tempList = new ArrayList<ItemStack>();
            tempList.add(OreDictUnifier.get(prefix, material));
            this.inputs.add(tempList);
        }
        this.currentSlot += 21;
        if (this.hasDirectSmelt) {
            Material smeltingMaterial;
            Material material2 = smeltingMaterial = property.getDirectSmeltResult() == null ? material : property.getDirectSmeltResult();
            ItemStack smeltingResult = smeltingMaterial.hasProperty(PropertyKey.INGOT) ? OreDictUnifier.get(OrePrefix.ingot, smeltingMaterial) : (smeltingMaterial.hasProperty(PropertyKey.GEM) ? OreDictUnifier.get(OrePrefix.gem, smeltingMaterial) : OreDictUnifier.get(OrePrefix.dust, smeltingMaterial));
            smeltingResult.func_190920_e(smeltingResult.func_190916_E() * oreMultiplier);
            this.addToOutputs(smeltingResult);
        } else {
            this.addEmptyOutputs(1);
        }
        this.addToOutputs(material, OrePrefix.crushed, 2 * oreMultiplier);
        if (!OreDictUnifier.get(OrePrefix.gem, byproducts[0]).func_190926_b()) {
            this.addToOutputs(byproducts[0], OrePrefix.gem, 1);
        } else {
            this.addToOutputs(byproducts[0], OrePrefix.dust, 1);
        }
        this.addChance(1400, 850);
        this.addToOutputs(material, OrePrefix.dustImpure, 1);
        this.addToOutputs(byproducts[0], OrePrefix.dust, byproductMultiplier);
        this.addChance(1400, 850);
        this.addToOutputs(material, OrePrefix.dust, 1);
        this.addToOutputs(byproducts[0], OrePrefix.dustTiny, 1);
        this.addToOutputs(material, OrePrefix.crushedPurified, 1);
        this.addToOutputs(byproducts[0], OrePrefix.dustTiny, 3);
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        fluidStacks.add(Materials.Water.getFluid(1000));
        fluidStacks.add(Materials.DistilledWater.getFluid(100));
        this.fluidInputs.add(fluidStacks);
        this.addToOutputs(material, OrePrefix.crushedCentrifuged, 1);
        this.addToOutputs(byproducts[1], OrePrefix.dustTiny, byproductMultiplier * 3);
        this.addToOutputs(material, OrePrefix.dust, 1);
        this.addToOutputs(byproducts[2], OrePrefix.dust, 1);
        this.addChance(1400, 850);
        this.addToOutputs(material, OrePrefix.dustPure, 1);
        this.addToOutputs(byproducts[1], OrePrefix.dust, 1);
        this.addChance(1400, 850);
        this.addToOutputs(material, OrePrefix.dust, 1);
        this.addToOutputs(byproducts[1], OrePrefix.dustTiny, 1);
        this.addToOutputs(material, OrePrefix.crushed, 1);
        this.addToOutputs(material, OrePrefix.crushedPurified, 1);
        this.addToOutputs(material, OrePrefix.dustImpure, 1);
        this.addToOutputs(material, OrePrefix.dust, 1);
        this.addToOutputs(material, OrePrefix.dustPure, 1);
        this.addToOutputs(material, OrePrefix.dust, 1);
        if (this.hasChemBath) {
            this.addToOutputs(material, OrePrefix.crushedPurified, 1);
            this.addToOutputs(byproducts[3], OrePrefix.dust, byproductMultiplier);
            this.addChance(7000, 580);
            washedFluid = new ArrayList();
            washedFluid.add(((Material)washedIn.getKey()).getFluid((Integer)washedIn.getValue()));
            this.fluidInputs.add(washedFluid);
        } else {
            this.addEmptyOutputs(2);
            washedFluid = new ArrayList<FluidStack>();
            this.fluidInputs.add(washedFluid);
        }
        if (this.hasSeparator) {
            ItemStack separatedStack1 = OreDictUnifier.get(OrePrefix.dustSmall, separatedInto.get(0));
            OrePrefix prefix = separatedInto.get(separatedInto.size() - 1).getBlastTemperature() == 0 && separatedInto.get(separatedInto.size() - 1).hasProperty(PropertyKey.INGOT) ? OrePrefix.nugget : OrePrefix.dustSmall;
            ItemStack separatedStack2 = OreDictUnifier.get(prefix, separatedInto.get(separatedInto.size() - 1), prefix == OrePrefix.nugget ? 2 : 1);
            this.addToOutputs(material, OrePrefix.dust, 1);
            this.addToOutputs(separatedStack1);
            this.addChance(4000, 850);
            this.addToOutputs(separatedStack2);
            this.addChance(2000, 600);
        } else {
            this.addEmptyOutputs(3);
        }
        if (this.hasSifter) {
            boolean highOutput = material.hasFlag(MaterialFlags.HIGH_SIFTER_OUTPUT);
            ItemStack flawedStack = OreDictUnifier.get(OrePrefix.gemFlawed, material);
            ItemStack chippedStack = OreDictUnifier.get(OrePrefix.gemChipped, material);
            this.addToOutputs(material, OrePrefix.gemExquisite, 1);
            this.addGemChance(300, 100, 500, 150, highOutput);
            this.addToOutputs(material, OrePrefix.gemFlawless, 1);
            this.addGemChance(1000, 150, 1500, 200, highOutput);
            this.addToOutputs(material, OrePrefix.gem, 1);
            this.addGemChance(3500, 500, 5000, 1000, highOutput);
            this.addToOutputs(material, OrePrefix.dustPure, 1);
            this.addGemChance(5000, 750, 2500, 500, highOutput);
            if (!flawedStack.func_190926_b()) {
                this.addToOutputs(flawedStack);
                this.addGemChance(2500, 300, 2000, 500, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
            if (!chippedStack.func_190926_b()) {
                this.addToOutputs(chippedStack);
                this.addGemChance(3500, 400, 3000, 350, highOutput);
            } else {
                this.addEmptyOutputs(1);
            }
        } else {
            this.addEmptyOutputs(6);
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setInputLists(VanillaTypes.FLUID, this.fluidInputs);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.outputs);
    }

    public void addTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        if (this.chances.containsKey(slotIndex)) {
            Recipe.ChanceEntry entry = (Recipe.ChanceEntry)this.chances.get(slotIndex);
            double chance = (double)entry.getChance() / 100.0;
            double boost = (double)entry.getBoostPerTier() / 100.0;
            tooltip.add(I18n.func_135052_a((String)"gregtech.recipe.chance", (Object[])new Object[]{chance, boost}));
        }
    }

    public Recipe.ChanceEntry getChance(int slot) {
        return (Recipe.ChanceEntry)this.chances.get(slot);
    }

    public boolean hasSifter() {
        return this.hasSifter;
    }

    public boolean hasSeparator() {
        return this.hasSeparator;
    }

    public boolean hasChemBath() {
        return this.hasChemBath;
    }

    public boolean hasDirectSmelt() {
        return this.hasDirectSmelt;
    }

    private void addToOutputs(Material material, OrePrefix prefix, int size) {
        this.addToOutputs(OreDictUnifier.get(prefix, material, size));
    }

    private void addToOutputs(ItemStack stack) {
        ArrayList<ItemStack> tempList = new ArrayList<ItemStack>();
        tempList.add(stack);
        this.outputs.add(tempList);
        ++this.currentSlot;
    }

    private void addEmptyOutputs(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addToOutputs(ItemStack.field_190927_a);
        }
    }

    private void addToInputs(ItemStack stack) {
        ArrayList<ItemStack> tempList = new ArrayList<ItemStack>();
        tempList.add(stack);
        this.inputs.add(tempList);
    }

    private void addChance(int base, int tier) {
        this.chances.put(this.currentSlot - 1, (Object)new Recipe.ChanceEntry(ItemStack.field_190927_a, base, tier));
    }

    private void addGemChance(int baseLow, int tierLow, int baseHigh, int tierHigh, boolean high) {
        if (high) {
            this.addChance(baseHigh, tierHigh);
        } else {
            this.addChance(baseLow, tierLow);
        }
    }
}

