/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei.recipe;

import gregtech.api.GTValues;
import gregtech.api.gui.GuiTextures;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.recipeproperties.PrimitiveProperty;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.CTRecipeHelper;
import gregtech.api.util.ClipboardUtil;
import gregtech.api.util.GTUtility;
import gregtech.client.utils.TooltipHelper;
import gregtech.integration.GroovyScriptCompat;
import gregtech.integration.jei.utils.AdvancedRecipeWrapper;
import gregtech.integration.jei.utils.JeiButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class GTRecipeWrapper
extends AdvancedRecipeWrapper {
    private static final int LINE_HEIGHT = 10;
    private final RecipeMap<?> recipeMap;
    private final Recipe recipe;

    public GTRecipeWrapper(RecipeMap<?> recipeMap, Recipe recipe) {
        this.recipeMap = recipeMap;
        this.recipe = recipe;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        if (!this.recipe.getInputs().isEmpty()) {
            ArrayList matchingInputs = new ArrayList(this.recipe.getInputs().size());
            for (GTRecipeInput recipeInput : this.recipe.getInputs()) {
                matchingInputs.add(Arrays.stream(recipeInput.getInputStacks()).map(ItemStack::func_77946_l).collect(Collectors.toList()));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, matchingInputs);
        }
        if (!this.recipe.getFluidInputs().isEmpty()) {
            ArrayList matchingFluidInputs = new ArrayList(this.recipe.getFluidInputs().size());
            for (GTRecipeInput fluidInput : this.recipe.getFluidInputs()) {
                FluidStack fluidStack = fluidInput.getInputFluidStack();
                Collections.addAll(matchingFluidInputs, fluidStack);
            }
            ingredients.setInputs(VanillaTypes.FLUID, matchingFluidInputs);
        }
        if (!this.recipe.getOutputs().isEmpty() || !this.recipe.getChancedOutputs().isEmpty()) {
            List recipeOutputs = this.recipe.getOutputs().stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
            List<Recipe.ChanceEntry> chancedOutputs = this.recipe.getChancedOutputs();
            chancedOutputs.sort(Comparator.comparingInt(entry -> entry == null ? 0 : entry.getChance()));
            for (Recipe.ChanceEntry chancedEntry : chancedOutputs) {
                recipeOutputs.add(chancedEntry.getItemStackRaw());
            }
            ingredients.setOutputs(VanillaTypes.ITEM, recipeOutputs);
        }
        if (!this.recipe.getFluidOutputs().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, this.recipe.getFluidOutputs().stream().map(FluidStack::copy).collect(Collectors.toList()));
        }
    }

    public void addItemTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        boolean notConsumed = input && this.isNotConsumedItem(slotIndex);
        Recipe.ChanceEntry entry = null;
        int outputIndex = slotIndex - this.recipeMap.getMaxInputs();
        if (!input && !this.recipe.getChancedOutputs().isEmpty() && outputIndex >= this.recipe.getOutputs().size()) {
            entry = this.recipe.getChancedOutputs().get(outputIndex - this.recipe.getOutputs().size());
        }
        if (entry != null) {
            double chance = (double)entry.getChance() / 100.0;
            double boost = (double)entry.getBoostPerTier() / 100.0;
            tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.chance", (Object[])new Object[]{chance, boost}));
        } else if (notConsumed) {
            tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.not_consumed", (Object[])new Object[0]));
        }
    }

    public void addFluidTooltip(int slotIndex, boolean input, Object ingredient, List<String> tooltip) {
        boolean notConsumed;
        boolean bl = notConsumed = input && this.isNotConsumedFluid(slotIndex);
        if (notConsumed) {
            tooltip.add(TooltipHelper.BLINKING_CYAN + I18n.func_135052_a((String)"gregtech.recipe.not_consumed", (Object[])new Object[0]));
        }
    }

    @Override
    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        int yPosition = recipeHeight - this.getPropertyListHeight();
        if (!this.recipe.hasProperty(PrimitiveProperty.getInstance())) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.total", (Object[])new Object[]{Math.abs((long)this.recipe.getEUt()) * (long)this.recipe.getDuration()}), 0, yPosition, 0x111111);
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)(this.recipe.getEUt() >= 0 ? "gregtech.recipe.eu" : "gregtech.recipe.eu_inverted"), (Object[])new Object[]{Math.abs(this.recipe.getEUt()), GTValues.VN[GTUtility.getTierByVoltage(this.recipe.getEUt())]}), 0, yPosition += 10, 0x111111);
        } else {
            yPosition -= 20;
        }
        minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtech.recipe.duration", (Object[])new Object[]{Float.valueOf((float)this.recipe.getDuration() / 20.0f)}), 0, yPosition += 10, 0x111111);
        for (Map.Entry<RecipeProperty<?>, Object> propertyEntry : this.recipe.getPropertyValues()) {
            if (propertyEntry.getKey().isHidden()) continue;
            propertyEntry.getKey().drawInfo(minecraft, 0, yPosition += 10, 0x111111, propertyEntry.getValue());
        }
    }

    @Override
    public void initExtras() {
        BooleanSupplier creativePlayerCtPredicate = () -> Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184812_l_() && Loader.isModLoaded((String)"crafttweaker");
        String mod = GroovyScriptCompat.isLoaded() ? "GroovyScript" : "CraftTweaker";
        this.buttons.add(new JeiButton(166.0f, 2.0f, 10, 10).setTextures(GuiTextures.BUTTON_CLEAR_GRID).setTooltipBuilder(lines -> lines.add("Copies a " + mod + " script, to remove this recipe, to the clipboard")).setClickAction((minecraft, mouseX, mouseY, mouseButton) -> {
            String recipeLine = GroovyScriptCompat.isLoaded() ? GroovyScriptCompat.getRecipeRemoveLine(this.recipeMap, this.recipe) : CTRecipeHelper.getRecipeRemoveLine(this.recipeMap, this.recipe);
            String output = CTRecipeHelper.getFirstOutputString(this.recipe);
            if (!output.isEmpty()) {
                output = "// " + output + "\n";
            }
            String copyString = output + recipeLine + "\n";
            ClipboardUtil.copyToClipboard(copyString);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("Copied [\u00a76" + recipeLine + "\u00a7r] to the clipboard"));
            return true;
        }).setActiveSupplier(creativePlayerCtPredicate));
    }

    public Recipe.ChanceEntry getOutputChance(int slot) {
        if (slot >= this.recipe.getChancedOutputs().size() || slot < 0) {
            return null;
        }
        return this.recipe.getChancedOutputs().get(slot);
    }

    public boolean isNotConsumedItem(int slot) {
        if (slot >= this.recipe.getInputs().size()) {
            return false;
        }
        return this.recipe.getInputs().get(slot).isNonConsumable();
    }

    public boolean isNotConsumedFluid(int slot) {
        if (slot >= this.recipe.getFluidInputs().size()) {
            return false;
        }
        return this.recipe.getFluidInputs().get(slot).isNonConsumable();
    }

    private int getPropertyListHeight() {
        if (this.recipeMap == RecipeMaps.COKE_OVEN_RECIPES) {
            return 4;
        }
        return (this.recipe.getUnhiddenPropertyCount() + 3) * 10 - 3;
    }
}

