/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei;

import gregtech.api.gui.GuiTextures;
import gregtech.api.util.GTLog;
import gregtech.api.worldgen.config.OreDepositDefinition;
import gregtech.api.worldgen.config.WorldGenRegistry;
import gregtech.integration.jei.GTOreInfo;
import gregtech.integration.jei.recipe.primitive.BasicRecipeCategory;
import gregtech.integration.jei.utils.render.ItemStackTextRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;

public class GTOreCategory
extends BasicRecipeCategory<GTOreInfo, GTOreInfo> {
    protected final IDrawable slot;
    protected OreDepositDefinition definition;
    protected String veinName;
    protected int minHeight;
    protected int maxHeight;
    protected int outputCount;
    protected int weight;
    protected List<Integer> dimensionIDs;
    protected final int FONT_HEIGHT;
    protected final Map<Integer, String> namedDimensions;
    private final Supplier<List<Integer>> dimension;
    private final int NUM_OF_SLOTS = 5;
    private final int SLOT_WIDTH = 18;
    private final int SLOT_HEIGHT = 18;

    public GTOreCategory(IGuiHelper guiHelper) {
        super("ore_spawn_location", "ore.spawnlocation.name", (IDrawable)guiHelper.createBlankDrawable(176, 166), guiHelper);
        this.FONT_HEIGHT = Minecraft.func_71410_x().field_71466_p.field_78288_b;
        this.namedDimensions = WorldGenRegistry.getNamedDimensions();
        this.dimension = this::getAllRegisteredDimensions;
        this.NUM_OF_SLOTS = 5;
        this.SLOT_WIDTH = 18;
        this.SLOT_HEIGHT = 18;
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public void setRecipe(IRecipeLayout recipeLayout, GTOreInfo recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        int baseYPos = 19;
        itemStackGroup.init(0, true, 22, baseYPos);
        itemStackGroup.init(1, true, 22, 73);
        for (int i = 0; i < recipeWrapper.getOutputCount(); ++i) {
            int yPos = baseYPos + i / 5 * 18;
            int xPos = 70 + i % 5 * 18;
            itemStackGroup.init(i + 2, false, (IIngredientRenderer)new ItemStackTextRenderer(recipeWrapper.getOreWeight(i) * 100, -1), xPos + 1, yPos + 1, 16, 16, 0, 0);
        }
        itemStackGroup.addTooltipCallback(recipeWrapper::addTooltip);
        itemStackGroup.set(ingredients);
        this.veinName = recipeWrapper.getVeinName();
        this.minHeight = recipeWrapper.getMinHeight();
        this.maxHeight = recipeWrapper.getMaxHeight();
        this.outputCount = recipeWrapper.getOutputCount();
        this.weight = recipeWrapper.getWeight();
        this.definition = recipeWrapper.getDefinition();
    }

    @Nonnull
    public IRecipeWrapper getRecipeWrapper(@Nonnull GTOreInfo recipe) {
        return recipe;
    }

    @Override
    public void drawExtras(@Nonnull Minecraft minecraft) {
        int i;
        int baseXPos = 70;
        int baseYPos = 19;
        int dimDisplayPos = 70;
        this.slot.draw(minecraft, 22, baseYPos);
        this.slot.draw(minecraft, 22, 73);
        int yPos = 0;
        for (i = 0; i < this.outputCount; ++i) {
            yPos = baseYPos + i / 5 * 18;
            int xPos = baseXPos + i % 5 * 18;
            this.slot.draw(minecraft, xPos, yPos);
        }
        baseYPos = yPos + 18;
        this.drawVeinName(minecraft.field_71466_p);
        if (baseYPos >= 90) {
            minecraft.field_71466_p.func_78276_b("Spawn Range: " + this.minHeight + "-" + this.maxHeight, 70, baseYPos + 1, 0x111111);
        } else {
            minecraft.field_71466_p.func_78276_b("Spawn Range: " + this.minHeight + "-" + this.maxHeight, 70, 73, 0x111111);
            baseYPos = 73;
        }
        minecraft.field_71466_p.func_78276_b("Vein Weight: " + this.weight, 70, baseYPos + this.FONT_HEIGHT, 0x111111);
        minecraft.field_71466_p.func_78276_b("Dimensions: ", 70, baseYPos + 2 * this.FONT_HEIGHT, 0x111111);
        this.dimensionIDs = this.dimension.get();
        for (i = 0; i < this.dimensionIDs.size(); ++i) {
            String fullDimName;
            if (this.namedDimensions.containsKey(this.dimensionIDs.get(i))) {
                String dimName = this.namedDimensions.get(this.dimensionIDs.get(i));
                fullDimName = i == this.dimensionIDs.size() - 1 ? this.dimensionIDs.get(i) + " (" + dimName + ")" : this.dimensionIDs.get(i) + " (" + dimName + "), ";
            } else {
                fullDimName = i == this.dimensionIDs.size() - 1 ? Integer.toString(this.dimensionIDs.get(i)) : this.dimensionIDs.get(i) + ", ";
            }
            int dimDisplayLength = minecraft.field_71466_p.func_78256_a(fullDimName);
            if (dimDisplayLength > 176 - dimDisplayPos) {
                baseYPos += this.FONT_HEIGHT;
                dimDisplayPos = 70;
            }
            minecraft.field_71466_p.func_78276_b(fullDimName, dimDisplayPos, baseYPos + 3 * this.FONT_HEIGHT, 0x111111);
            dimDisplayPos += dimDisplayLength;
        }
        minecraft.field_71466_p.func_78279_b("SurfaceMaterial", 15, 92, minecraft.field_71466_p.func_78256_a("Surface"), 0x111111);
    }

    private void drawVeinName(FontRenderer fontRenderer) {
        int maxVeinNameLength = 176;
        String veinNameToDraw = this.veinName;
        if (fontRenderer.func_78256_a(veinNameToDraw) > 176) {
            veinNameToDraw = fontRenderer.func_78262_a(this.veinName, 173, false) + "...";
        }
        int startPosition = (176 - fontRenderer.func_78256_a(veinNameToDraw)) / 2;
        fontRenderer.func_78276_b(veinNameToDraw, startPosition, 1, 0x111111);
    }

    public List<Integer> getAllRegisteredDimensions() {
        ArrayList<Integer> dims = new ArrayList<Integer>();
        Map dimMap = DimensionManager.getRegisteredDimensions();
        dimMap.values().stream().flatMap(Collection::stream).mapToInt(Integer::intValue).filter(num -> this.definition.getDimensionFilter().test(DimensionManager.createProviderFor((int)num))).forEach(dims::add);
        if (Loader.isModLoaded((String)"advancedrocketry")) {
            try {
                int[] spaceDims;
                for (int spaceDim : spaceDims = DimensionManager.getDimensions((DimensionType)DimensionType.func_193417_a((String)"space"))) {
                    if (!dims.contains(spaceDim)) continue;
                    dims.remove((Object)spaceDim);
                }
            }
            catch (IllegalArgumentException e) {
                GTLog.logger.error("Something went wrong with AR JEI integration, No DimensionType found");
                GTLog.logger.error((Object)e);
            }
        }
        return dims;
    }
}

