/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration;

import com.cleanroommc.groovyscript.GroovyScript;
import com.cleanroommc.groovyscript.api.GroovyLog;
import com.cleanroommc.groovyscript.brackets.BracketHandlerManager;
import com.cleanroommc.groovyscript.compat.mods.ModPropertyContainer;
import com.cleanroommc.groovyscript.compat.mods.ModSupport;
import com.cleanroommc.groovyscript.registry.VirtualizedRegistry;
import gregtech.api.GregTechAPI;
import gregtech.api.block.DelayedStateBlock;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.CTRecipeHelper;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.pipelike.cable.BlockCable;
import gregtech.common.pipelike.fluidpipe.BlockFluidPipe;
import gregtech.common.pipelike.itempipe.BlockItemPipe;
import gregtech.integration.GroovyHandCommand;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;

public class GroovyScriptCompat {
    private static boolean loaded = false;
    private static ModSupport.Container<Container> modSupportContainer;
    private static final Map<String, ItemStack> metaItems;

    private GroovyScriptCompat() {
    }

    public static void init() {
        loaded = Loader.isModLoaded((String)"groovyscript");
        if (!loaded) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(GroovyHandCommand.class);
        BracketHandlerManager.registerBracketHandler((String)"recipemap", RecipeMap::getByName);
        BracketHandlerManager.registerBracketHandler((String)"material", s -> {
            Material material = (Material)GregTechAPI.MATERIAL_REGISTRY.func_82594_a(s);
            if (material == null) {
                GroovyLog.get().errorMC("Could not resolve material('{}')", new Object[]{s});
            }
            return material;
        });
        BracketHandlerManager.registerBracketHandler((String)"oreprefix", OrePrefix::getPrefix);
        BracketHandlerManager.registerBracketHandler((String)"metaitem", GroovyScriptCompat::getMetaItem);
        modSupportContainer = new ModSupport.Container("gregtech", "GregTech", () -> new Container(), new String[]{"gt"});
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isCurrentlyRunning() {
        return loaded && GroovyScript.getSandbox().isRunning();
    }

    public static Container getInstance() {
        return (Container)modSupportContainer.get();
    }

    public static ItemStack getMetaItem(String name) {
        ItemStack item = metaItems.get(name);
        if (item != null) {
            return item.func_77946_l();
        }
        item = GroovyScriptCompat.getMetaTileEntityItem(name);
        if (item != null) {
            return item.func_77946_l();
        }
        if (GroovyScriptCompat.isCurrentlyRunning()) {
            GroovyLog.get().error("Could not resolve metaitem('{}')", new Object[]{name});
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static ItemStack getMetaTileEntityItem(String name) {
        String[] resultName = GroovyScriptCompat.splitObjectName(name);
        MetaTileEntity metaTileEntity = (MetaTileEntity)GregTechAPI.MTE_REGISTRY.func_82594_a(new ResourceLocation(resultName[0], resultName[1]));
        return metaTileEntity == null ? null : metaTileEntity.getStackForm();
    }

    public static String[] splitObjectName(String toSplit) {
        String[] resultSplit = new String[]{"gregtech", toSplit};
        int i = toSplit.indexOf(58);
        if (i >= 0) {
            resultSplit[1] = toSplit.substring(i + 1);
            if (i > 1) {
                resultSplit[0] = toSplit.substring(0, i);
            }
        }
        return resultSplit;
    }

    public static void loadMetaItemBracketHandler() {
        metaItems.clear();
        for (Map.Entry<Material, BlockCompressed> entry : MetaBlocks.COMPRESSED.entrySet()) {
            metaItems.put("block" + entry.getKey().toCamelCaseString(), entry.getValue().getItem(entry.getKey()));
        }
        for (Map.Entry<Material, DelayedStateBlock> entry : MetaBlocks.FRAMES.entrySet()) {
            metaItems.put("frame" + entry.getKey().toCamelCaseString(), ((BlockFrame)entry.getValue()).getItem(entry.getKey()));
        }
        for (Iterator<Map.Entry<Material, DelayedStateBlock>> iterator : MetaBlocks.CABLES) {
            for (Material material : ((BlockCable)((Object)iterator)).getEnabledMaterials()) {
                metaItems.put(((BlockMaterialPipe)((Object)iterator)).getPrefix().name + material.toCamelCaseString(), ((BlockMaterialPipe)((Object)iterator)).getItem(material));
            }
        }
        for (Iterator<Map.Entry<Material, DelayedStateBlock>> iterator : MetaBlocks.ITEM_PIPES) {
            for (Material material : ((BlockItemPipe)((Object)iterator)).getEnabledMaterials()) {
                metaItems.put(((BlockMaterialPipe)((Object)iterator)).getPrefix().name + material.toCamelCaseString(), ((BlockMaterialPipe)((Object)iterator)).getItem(material));
            }
        }
        for (Iterator<Map.Entry<Material, DelayedStateBlock>> iterator : MetaBlocks.FLUID_PIPES) {
            for (Material material : ((BlockFluidPipe)((Object)iterator)).getEnabledMaterials()) {
                metaItems.put(((BlockMaterialPipe)((Object)iterator)).getPrefix().name + material.toCamelCaseString(), ((BlockMaterialPipe)((Object)iterator)).getItem(material));
            }
        }
        for (MetaItem metaItem : MetaItem.getMetaItems()) {
            for (MetaItem.MetaValueItem metaValueItem : metaItem.getAllItems()) {
                if (metaValueItem.unlocalizedName.equals("meta_item")) continue;
                metaItems.put(metaValueItem.unlocalizedName, metaValueItem.getStackForm());
            }
        }
    }

    public static String getRecipeRemoveLine(RecipeMap<?> recipeMap, Recipe recipe) {
        StringBuilder builder = new StringBuilder();
        builder.append("mods.gregtech.").append(recipeMap.unlocalizedName).append(".removeByInput(").append(recipe.getEUt()).append(", ");
        if (recipe.getInputs().size() > 0) {
            builder.append("[");
            for (GTRecipeInput ci : recipe.getInputs()) {
                String ingredient = GroovyScriptCompat.getGroovyItemString(ci);
                builder.append(ingredient);
            }
            builder.delete(builder.length() - 2, builder.length()).append("], ");
        } else {
            builder.append("null, ");
        }
        if (recipe.getFluidInputs().size() > 0) {
            builder.append("[");
            for (GTRecipeInput fluidIngredient : recipe.getFluidInputs()) {
                builder.append("fluid('").append(fluidIngredient.getInputFluidStack().getFluid().getName()).append("')");
                if (fluidIngredient.getAmount() > 1) {
                    builder.append(" * ").append(fluidIngredient.getAmount());
                }
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length()).append("]");
        } else {
            builder.append("null");
        }
        builder.append(")");
        return builder.toString();
    }

    public static String getGroovyItemString(GTRecipeInput recipeInput) {
        StringBuilder builder = new StringBuilder();
        ItemStack itemStack = null;
        String itemId = null;
        for (ItemStack item : recipeInput.getInputStacks()) {
            itemId = CTRecipeHelper.getMetaItemId(item);
            if (itemId != null) {
                builder.append("metaitem('").append(itemId).append("')");
                itemStack = item;
                break;
            }
            if (itemStack != null) continue;
            itemStack = item;
        }
        if (itemStack != null && itemId == null) {
            builder.append("item('").append(itemStack.func_77973_b().getRegistryName()).append("'");
            if (itemStack.func_77960_j() != 0) {
                builder.append(", ").append(itemStack.func_77960_j());
            }
            builder.append(")");
        }
        if (recipeInput.getAmount() > 1) {
            builder.append(" * ").append(recipeInput.getAmount());
        }
        builder.append(", ");
        return builder.toString();
    }

    static {
        metaItems = new Object2ObjectOpenHashMap();
    }

    public static class Container
    extends ModPropertyContainer {
        private Container() {
        }

        protected void addRegistry(VirtualizedRegistry<?> registry) {
            super.addRegistry(registry);
        }
    }
}

