/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration;

import com.cleanroommc.groovyscript.event.GsHandEvent;
import gregtech.api.items.toolitem.IGTTool;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.api.util.CTRecipeHelper;
import gregtech.api.util.ClipboardUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GroovyHandCommand {
    @SubscribeEvent
    public static void onHandCommand(GsHandEvent event) {
        OrePrefix orePrefix;
        MaterialStack material;
        ItemStack stackInHand = event.stack;
        String id = CTRecipeHelper.getMetaItemId(stackInHand);
        if (id != null) {
            String ctId = "metaitem('" + id + "')";
            ClipboardUtil.copyToClipboard((EntityPlayerMP)event.player, ctId);
            event.messages.add(new TextComponentTranslation("gregtech.command.hand.meta_item", new Object[]{id}).func_150257_a(new TextComponentString(" " + id).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(GroovyHandCommand.getCopyStyle(ctId, true)));
        }
        if (stackInHand.func_77973_b() instanceof IGTTool) {
            IGTTool tool = (IGTTool)stackInHand.func_77973_b();
            event.messages.add(new TextComponentTranslation("gregtech.command.hand.tool_stats", new Object[]{tool.getToolClasses(stackInHand)}));
        }
        if ((material = OreDictUnifier.getMaterial(stackInHand)) != null) {
            event.messages.add(new TextComponentTranslation("gregtech.command.hand.material", new Object[0]).func_150257_a(new TextComponentString(" " + material.material).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(GroovyHandCommand.getCopyStyle("material('" + material.material + "')", false)));
        }
        if ((orePrefix = OreDictUnifier.getPrefix(stackInHand)) != null) {
            String ctId = "oreprefix('" + orePrefix.name + "')";
            ClipboardUtil.copyToClipboard((EntityPlayerMP)event.player, ctId);
            event.messages.add(new TextComponentTranslation("gregtech.command.hand.ore_prefix", new Object[0]).func_150257_a(new TextComponentString(" " + orePrefix.name).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN))).func_150255_a(GroovyHandCommand.getCopyStyle(ctId, false)));
        }
    }

    public static Style getCopyStyle(String copyMessage, boolean alreadyCopied) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/gt copy " + copyMessage);
        style.func_150241_a(click);
        ITextComponent text = alreadyCopied ? new TextComponentString("").func_150257_a(new TextComponentString(copyMessage + " ").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD))).func_150257_a((ITextComponent)new TextComponentTranslation("gregtech.command.copy.copied_and_click", new Object[0])) : new TextComponentTranslation("gregtech.command.copy.click_to_copy", new Object[0]).func_150257_a(new TextComponentString(" " + copyMessage).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, text));
        return style;
    }
}

