/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.sound.internal;

import gregtech.api.GregTechAPI;
import gregtech.api.sound.ISoundManager;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoundManager
implements ISoundManager {
    private static final SoundManager INSTANCE = new SoundManager();
    private final Object2ObjectMap<BlockPos, ISound> soundMap = new Object2ObjectOpenHashMap();

    private SoundManager() {
    }

    public static SoundManager getInstance() {
        return INSTANCE;
    }

    @Override
    public SoundEvent registerSound(String modName, String soundName) {
        ResourceLocation location = new ResourceLocation(modName, soundName);
        SoundEvent event = new SoundEvent(location);
        event.setRegistryName(location);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)event);
        return event;
    }

    @Override
    public SoundEvent registerSound(String soundName) {
        String containerId = GregTechAPI.moduleManager.getLoadedContainer().getID();
        if (containerId == null) {
            containerId = "gregtech";
        }
        return this.registerSound(containerId, soundName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound startTileSound(ResourceLocation soundName, float volume, BlockPos pos) {
        ISound sound = (ISound)this.soundMap.get((Object)pos);
        if (sound == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c(sound)) {
            sound = new PositionedSoundRecord(soundName, SoundCategory.BLOCKS, volume, 1.0f, true, 0, ISound.AttenuationType.LINEAR, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
            this.soundMap.put((Object)pos, (Object)sound);
            Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
        }
        return sound;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void stopTileSound(BlockPos pos) {
        ISound sound = (ISound)this.soundMap.get((Object)pos);
        if (sound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(sound);
            this.soundMap.remove((Object)pos);
        }
    }
}

