/*
 * Decompiled with CFR 0.152.
 */
package gregtech.core.advancement.internal;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import gregtech.api.advancement.IAdvancementCriterion;
import gregtech.api.advancement.IAdvancementTrigger;
import gregtech.core.advancement.internal.AdvancementListeners;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;

public class AdvancementTrigger<T extends IAdvancementCriterion>
implements IAdvancementTrigger<T> {
    private final ResourceLocation id;
    private final T criterion;
    private final Map<PlayerAdvancements, AdvancementListeners<T>> listeners = Maps.newHashMap();

    public AdvancementTrigger(String name, @Nonnull T criterion) {
        this.id = new ResourceLocation("gregtech", name);
        this.criterion = criterion;
    }

    @Nonnull
    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<T> listener) {
        AdvancementListeners<T> gtListener = this.listeners.get(playerAdvancementsIn);
        if (gtListener == null) {
            gtListener = new AdvancementListeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, gtListener);
        }
        gtListener.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements playerAdvancementsIn, @Nonnull ICriterionTrigger.Listener<T> listener) {
        AdvancementListeners<T> gtListener = this.listeners.get(playerAdvancementsIn);
        if (gtListener != null) {
            gtListener.remove(listener);
            if (gtListener.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Nonnull
    public T deserializeInstance(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
        return this.criterion;
    }

    @Override
    public void trigger(EntityPlayerMP player) {
        AdvancementListeners<T> listener = this.listeners.get(player.func_192039_O());
        if (listener != null) {
            listener.trigger(player);
        }
    }
}

