/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.hardware;

import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.common.items.MetaItems;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DeviceHardware
extends Hardware {
    private final int slot;

    public DeviceHardware(int slot) {
        this.slot = slot;
    }

    @Override
    public String getRegistryName() {
        return "device" + this.slot;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        return I18n.func_135052_a((String)"terminal.hw.device", (Object[])new Object[0]) + " " + this.slot;
    }

    @Override
    protected Hardware createHardware(ItemStack itemStack) {
        return new DeviceHardware(this.slot);
    }

    @Override
    public NBTTagCompound acceptItemStack(ItemStack itemStack) {
        for (DEVICE device : DEVICE.values()) {
            if (!device.itemStack.func_77969_a(itemStack)) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("d", device.ordinal());
            return nbt;
        }
        return null;
    }

    @Override
    public IGuiTexture getIcon() {
        if (!this.hasHW()) {
            return super.getIcon();
        }
        if (this.isCreative()) {
            return new ItemStackTexture(DEVICE.values()[this.slot % DEVICE.values().length].itemStack, new ItemStack[0]);
        }
        return new ItemStackTexture(this.getDevice().itemStack, new ItemStack[0]);
    }

    @Override
    public boolean isHardwareAdequate(Hardware demand) {
        if (demand instanceof DeviceHardware && this.isCreative()) {
            return DEVICE.values()[this.slot % DEVICE.values().length] == ((DeviceHardware)demand).getDevice();
        }
        return demand instanceof DeviceHardware && ((DeviceHardware)demand).getDevice() == this.getDevice();
    }

    @Override
    public String addInformation() {
        if (this.isCreative()) {
            return DEVICE.values()[this.slot % DEVICE.values().length].itemStack.func_82833_r();
        }
        return this.getDevice().itemStack.func_82833_r();
    }

    public DEVICE getDevice() {
        return DEVICE.values()[this.getNBT().func_74762_e("d") % DEVICE.values().length];
    }

    public static class DeviceDemand
    extends DeviceHardware {
        private final DEVICE device;

        public DeviceDemand(DEVICE device) {
            super(0);
            this.device = device;
        }

        public DeviceDemand(String device) {
            super(0);
            this.device = DEVICE.fromString(device);
        }

        @Override
        public String getLocalizedName() {
            return I18n.func_135052_a((String)"terminal.hw.device", (Object[])new Object[0]);
        }

        @Override
        public DEVICE getDevice() {
            return this.device;
        }
    }

    public static enum DEVICE {
        PROSPECTOR_LV(MetaItems.PROSPECTOR_LV, "prospector"),
        PROSPECTOR_HV(MetaItems.PROSPECTOR_HV, "advanced_prospector"),
        WIRELESS(MetaItems.WIRELESS, "wireless"),
        CAMERA(MetaItems.CAMERA, "camera"),
        FIELD_GENERATOR_UV(MetaItems.FIELD_GENERATOR_UV, "field_generator"),
        SOLAR_LV(MetaItems.COVER_SOLAR_PANEL_LV, "solar_lv");

        ItemStack itemStack;
        String name;

        private DEVICE(ItemStack itemStack, String name) {
            this.itemStack = itemStack;
            this.name = name;
        }

        private DEVICE(MetaItem.MetaValueItem metaItem, String name) {
            this.itemStack = metaItem.getStackForm();
            this.name = name;
        }

        public static DEVICE fromString(String name) {
            for (DEVICE device : DEVICE.values()) {
                if (!device.name.equals(name.toLowerCase())) continue;
                return device;
            }
            return null;
        }
    }
}

