/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.recipechart.widget;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.terminal.gui.IDraggable;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Position;
import gregtech.common.terminal.app.recipechart.widget.PhantomWidget;
import gregtech.common.terminal.app.recipechart.widget.RGContainer;
import gregtech.integration.jei.GTJeiPlugin;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.Focus;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class RGNode
extends WidgetGroup
implements IDraggable {
    protected Object head;
    protected int recipePer;
    protected ItemStack catalyst;
    private boolean isSelected;
    private WidgetGroup toolGroup;
    private WidgetGroup inputsGroup;
    private RGContainer container;
    private SimpleTextWidget textWidget;
    protected Map<RGNode, Integer> parentNodes;
    protected Map<Widget, Set<RGNode>> children;

    public RGNode(int x, int y, RGContainer container, Object head, boolean isPhantom) {
        super(x, y, 18, 18);
        this.init(container);
        this.head = head;
        if (isPhantom) {
            PhantomWidget phantom = new PhantomWidget(0, 0, head).setChangeListener(object -> {
                this.head = object;
                for (Set<RGNode> childs : this.children.values()) {
                    for (RGNode child : childs) {
                        child.removeParent(this);
                    }
                }
                this.children.clear();
                this.inputsGroup.widgets.clear();
            });
            this.addWidget(phantom);
            this.toolGroup.addWidget(new CircleButtonWidget(-11, 49, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), 0).setIcon(GuiTextures.ICON_CALCULATOR).setHoverText("terminal.recipe_chart.calculator").setClickListener(cd -> TerminalDialogWidget.showTextFieldDialog(container.os, "terminal.recipe_chart.demand", s -> {
                try {
                    return Integer.parseInt(s) > 0;
                }
                catch (Exception ignored) {
                    return false;
                }
            }, s -> {
                if (s != null && !s.isEmpty()) {
                    this.updateDemand(Integer.parseInt(s));
                }
            }).setClientSide().open()));
            this.toolGroup.addWidget(new CircleButtonWidget(9, 49, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), 0).setIcon(GuiTextures.ICON_ADD).setHoverText("terminal.recipe_chart.add").setClickListener(cd -> TerminalDialogWidget.showItemSelector(container.os, "terminal.recipe_chart.demand", false, itemStack -> true, itemStack -> {
                if (itemStack != null && !itemStack.func_190926_b()) {
                    FluidStack fluidStack;
                    IFluidHandler handlerItem = (IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                    if (handlerItem != null && handlerItem.getTankProperties().length > 0 && (fluidStack = handlerItem.getTankProperties()[0].getContents()) != null) {
                        phantom.setObject(fluidStack);
                        return;
                    }
                    phantom.setObject((ItemStack)itemStack);
                    for (Set<RGNode> childs : this.children.values()) {
                        for (RGNode child : childs) {
                            child.removeParent(this);
                        }
                    }
                    this.children.clear();
                    this.inputsGroup.widgets.clear();
                }
            }).setClientSide().open()));
        } else if (head instanceof ItemStack) {
            ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, (ItemStack)head);
            this.addWidget(new SlotWidget((IItemHandler)handler, 0, 0, 0, false, false).setBackgroundTexture(TerminalTheme.COLOR_B_2));
        } else if (head instanceof FluidStack) {
            FluidTank tank = new FluidTank((FluidStack)head, Integer.MAX_VALUE);
            this.addWidget(new TankWidget((IFluidTank)tank, 0, 0, 18, 18).setAlwaysShowFull(true).setBackgroundTexture(TerminalTheme.COLOR_B_2).setClient());
        }
    }

    private void init(RGContainer container) {
        this.container = container;
        this.textWidget = new SimpleTextWidget(9, -5, "", -1, () -> {
            if (this.head instanceof ItemStack) {
                return ((ItemStack)this.head).func_82833_r();
            }
            if (this.head instanceof FluidStack) {
                return ((FluidStack)this.head).getLocalizedName();
            }
            return "terminal.recipe_chart.drag";
        }, true).setShadow(true);
        this.textWidget.setVisible(false);
        this.textWidget.setActive(false);
        this.addWidget(this.textWidget);
        this.inputsGroup = new WidgetGroup(0, 0, 0, 0);
        this.addWidget(this.inputsGroup);
        this.toolGroup = new WidgetGroup(0, 0, 0, 0);
        this.addWidget(this.toolGroup);
        this.toolGroup.addWidget(new CircleButtonWidget(-11, 9, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), TerminalTheme.COLOR_3.getColor()).setIcon(GuiTextures.ICON_REMOVE).setHoverText("terminal.guide_editor.remove").setClickListener(cd -> this.remove()));
        this.toolGroup.addWidget(new CircleButtonWidget(-11, 29, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), 0).setIcon(GuiTextures.ICON_VISIBLE).setHoverText("terminal.recipe_chart.visible").setClickListener(cd -> {
            this.textWidget.setActive(!this.textWidget.isActive());
            this.textWidget.setVisible(!this.textWidget.isVisible());
        }));
        this.toolGroup.addWidget(new CircleButtonWidget(9, 29, 8, 1, 12).setColors(0, TerminalTheme.COLOR_7.getColor(), 0).setIcon(GuiTextures.ICON_LOCATION).setHoverText("terminal.recipe_chart.jei").setClickListener(cd -> {
            if (GTJeiPlugin.jeiRuntime != null && this.head != null) {
                GTJeiPlugin.jeiRuntime.getRecipesGui().show((IFocus)new Focus(IFocus.Mode.OUTPUT, this.head));
            }
        }));
        this.inputsGroup.setVisible(false);
        this.inputsGroup.setActive(false);
        this.toolGroup.setVisible(false);
        this.toolGroup.setActive(false);
        this.parentNodes = new HashMap<RGNode, Integer>();
        this.children = new LinkedHashMap<Widget, Set<RGNode>>();
    }

    public int getHeadDemand() {
        if (this.head instanceof ItemStack) {
            return ((ItemStack)this.head).func_190916_E();
        }
        if (this.head instanceof FluidStack) {
            return ((FluidStack)this.head).amount;
        }
        return 0;
    }

    public int getChildDemand(RGNode child) {
        for (Map.Entry<Widget, Set<RGNode>> entry : this.children.entrySet()) {
            if (!entry.getValue().contains(child)) continue;
            int perC = 0;
            if (entry.getKey() instanceof SlotWidget) {
                perC = ((SlotWidget)entry.getKey()).getHandle().func_75211_c().func_190916_E();
            } else if (entry.getKey() instanceof TankWidget) {
                perC = ((TankWidget)entry.getKey()).fluidTank.getFluidAmount();
            }
            int ratioSum = entry.getValue().stream().mapToInt(it -> this.container.getLine((RGNode)this, (RGNode)it).ratio).sum();
            return MathHelper.func_76123_f((float)((float)(perC * MathHelper.func_76123_f((float)((float)this.getHeadDemand() / (float)this.recipePer)) * this.container.getLine((RGNode)this, (RGNode)child).ratio) / (float)ratioSum));
        }
        return 0;
    }

    public boolean canMerge(RGNode node) {
        if (this.head instanceof ItemStack && node.head instanceof ItemStack && ((ItemStack)this.head).func_77969_a((ItemStack)node.head)) {
            return this.checkMergeAvailable(node);
        }
        if (this.head instanceof FluidStack && node.head instanceof FluidStack && ((FluidStack)this.head).isFluidEqual((FluidStack)node.head)) {
            return this.checkMergeAvailable(node);
        }
        return false;
    }

    private boolean checkMergeAvailable(RGNode node) {
        Position pos1 = this.getPosition();
        Position pos2 = node.getPosition();
        return Math.abs(pos1.x - pos2.x) < 18 && Math.abs(pos1.y - pos2.y) < 18 && !this.findAllChildren().contains(node) && !node.findAllChildren().contains(this);
    }

    public Set<RGNode> findAllChildren() {
        HashSet<RGNode> result = new HashSet<RGNode>();
        for (Set<RGNode> nodes : this.children.values()) {
            for (RGNode node : nodes) {
                result.add(node);
                result.addAll(node.findAllChildren());
            }
        }
        return result;
    }

    public void mergeNode(RGNode node) {
        block0: for (RGNode parentNode : node.parentNodes.keySet()) {
            for (Set<RGNode> value : parentNode.children.values()) {
                if (!value.remove(node)) continue;
                value.add(this);
                this.addParent(parentNode);
                parentNode.updateDemand(parentNode.getHeadDemand());
                continue block0;
            }
        }
        node.remove();
    }

    public void remove() {
        if (this.isSelected) {
            this.container.setSelectedNode(null);
        }
        this.container.removeNode(this);
        for (RGNode rGNode : this.parentNodes.keySet()) {
            this.container.removeLine(rGNode, this);
            rGNode.onChildRemoved(this);
        }
        this.parentNodes.clear();
        for (Set set : this.children.values()) {
            for (RGNode child : set) {
                child.removeParent(this);
            }
        }
        this.children.clear();
    }

    public Position getNodePosition(RGNode child) {
        if (child != null && this.isSelected) {
            for (Map.Entry<Widget, Set<RGNode>> nodeEntry : this.children.entrySet()) {
                if (!nodeEntry.getValue().contains(child)) continue;
                return nodeEntry.getKey().getPosition();
            }
        }
        return this.getPosition();
    }

    public void addParent(RGNode parent) {
        this.container.addOrUpdateLine(parent, this);
        this.parentNodes.put(parent, parent.getChildDemand(this));
        this.updateDemand(this.parentNodes.values().stream().mapToInt(it -> it).sum());
    }

    public void updateDemand(int demand) {
        this.dfsUpdateDemand(demand, new Stack<RGNode>());
    }

    private void dfsUpdateDemand(int demand, Stack<RGNode> updated) {
        if (updated.contains(this)) {
            return;
        }
        updated.push(this);
        if (this.head instanceof ItemStack) {
            ((ItemStack)this.head).func_190920_e(demand);
        } else if (this.head instanceof FluidStack) {
            ((FluidStack)this.head).amount = demand;
        }
        for (Set<RGNode> children : this.children.values()) {
            for (RGNode child : children) {
                child.parentNodes.put(this, this.getChildDemand(child));
                child.dfsUpdateDemand(child.parentNodes.values().stream().mapToInt(it -> it).sum(), updated);
            }
        }
        updated.pop();
    }

    public void removeParent(RGNode parent) {
        this.parentNodes.remove(parent);
        if (this.parentNodes.size() == 0) {
            for (Set<RGNode> childs : this.children.values()) {
                for (RGNode child : childs) {
                    child.removeParent(this);
                }
            }
            this.children.clear();
            this.container.removeNode(this);
        } else {
            this.updateDemand(this.parentNodes.values().stream().mapToInt(it -> it).sum());
        }
        this.container.removeLine(parent, this);
    }

    public void onChildRemoved(RGNode child) {
        for (Set<RGNode> childs : this.children.values()) {
            if (!childs.remove(child)) continue;
            this.updateDemand(this.getHeadDemand());
            break;
        }
    }

    @Override
    protected void onPositionUpdate() {
        super.onPositionUpdate();
        for (RGNode rGNode : this.parentNodes.keySet()) {
            this.container.addOrUpdateLine(rGNode, this);
        }
        for (Set set : this.children.values()) {
            for (RGNode child : set) {
                this.container.addOrUpdateLine(this, child);
            }
        }
    }

    public boolean transferRecipe(ModularUIContainer x, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (this.isSelected) {
            IRecipeWrapper recipeWrapper;
            Object obj;
            Object object = obj = recipeLayout.getFocus() == null ? null : recipeLayout.getFocus().getValue();
            if (this.head instanceof ItemStack && obj instanceof ItemStack) {
                if (!((ItemStack)this.head).func_77969_a((ItemStack)obj)) {
                    return false;
                }
            } else if (this.head instanceof FluidStack && obj instanceof FluidStack) {
                if (!((FluidStack)this.head).isFluidEqual((FluidStack)obj)) {
                    return false;
                }
            } else {
                return false;
            }
            if (!doTransfer) {
                return true;
            }
            this.recipePer = 0;
            ArrayList<ItemStack> itemInputs = new ArrayList<ItemStack>();
            recipeLayout.getItemStacks().getGuiIngredients().values().forEach(it -> {
                if (it.isInput() && it.getDisplayedIngredient() != null) {
                    ItemStack input = (ItemStack)it.getDisplayedIngredient();
                    for (ItemStack itemInput : itemInputs) {
                        if (!itemInput.func_77969_a(input)) continue;
                        itemInput.func_190920_e(itemInput.func_190916_E() + input.func_190916_E());
                        return;
                    }
                    itemInputs.add(input.func_77946_l());
                } else if (this.head instanceof ItemStack && !it.isInput()) {
                    for (ItemStack ingredient : it.getAllIngredients()) {
                        if (!((ItemStack)this.head).func_77969_a(ingredient)) continue;
                        this.recipePer += ingredient.func_190916_E();
                        break;
                    }
                }
            });
            ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
            recipeLayout.getFluidStacks().getGuiIngredients().values().forEach(it -> {
                if (it.isInput() && it.getDisplayedIngredient() != null) {
                    FluidStack input = (FluidStack)it.getDisplayedIngredient();
                    for (FluidStack fluidInput : fluidInputs) {
                        if (!fluidInput.isFluidEqual(input)) continue;
                        fluidInput.amount += input.amount;
                        return;
                    }
                    fluidInputs.add(input.copy());
                } else if (this.head instanceof FluidStack && !it.isInput()) {
                    for (FluidStack ingredient : it.getAllIngredients()) {
                        if (!((FluidStack)this.head).isFluidEqual(ingredient)) continue;
                        this.recipePer += ingredient.amount;
                        break;
                    }
                }
            });
            Recipe recipe = null;
            if (recipeLayout instanceof RecipeLayout && (recipeWrapper = (IRecipeWrapper)ObfuscationReflectionHelper.getPrivateValue(RecipeLayout.class, (Object)((RecipeLayout)recipeLayout), (String)"recipeWrapper")) instanceof GTRecipeWrapper) {
                recipe = ((GTRecipeWrapper)recipeWrapper).getRecipe();
            }
            IRecipeCategory category = recipeLayout.getRecipeCategory();
            List catalysts = GTJeiPlugin.jeiRuntime.getRecipeRegistry().getRecipeCatalysts(category);
            ItemStack catalyst = null;
            if (recipe != null) {
                byte tierRequire = GTUtility.getTierByVoltage(recipe.getEUt());
                for (Object o : catalysts) {
                    MetaTileEntity mte;
                    if (!(o instanceof ItemStack) || !((mte = GTUtility.getMetaTileEntity((ItemStack)o)) instanceof SimpleMachineMetaTileEntity) || tierRequire >= ((SimpleMachineMetaTileEntity)mte).getTier()) continue;
                    catalyst = (ItemStack)o;
                    break;
                }
            }
            if (catalyst == null) {
                for (Object o : catalysts) {
                    if (!(o instanceof ItemStack)) continue;
                    catalyst = (ItemStack)o;
                    break;
                }
            }
            this.setRecipe(itemInputs, fluidInputs, catalyst, this.recipePer);
            return true;
        }
        return false;
    }

    public void deserializeRelationNBT(NBTTagList parentsTag, NBTTagList childrenTag) {
        for (NBTBase nbtBase : parentsTag) {
            int[] nbt = ((NBTTagIntArray)nbtBase).func_150302_c();
            this.parentNodes.put(this.container.nodes.get(nbt[0]), nbt[1]);
        }
        Iterator<Widget> iterator = this.children.keySet().iterator();
        for (NBTBase nbtBase : childrenTag) {
            int[] nbt = ((NBTTagIntArray)nbtBase).func_150302_c();
            this.children.get(iterator.next()).addAll(Arrays.stream(nbt).mapToObj(it -> this.container.nodes.get(it)).collect(Collectors.toList()));
        }
    }

    public static RGNode deserializeNodeNBT(NBTTagCompound nodeTag, RGContainer container) {
        byte type = nodeTag.func_74771_c("type");
        ItemStack head = null;
        if (type == 1) {
            head = new ItemStack(nodeTag.func_74775_l("nbt"));
            head.func_190920_e(nodeTag.func_74762_e("count"));
        } else if (type == 2) {
            head = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nodeTag.func_74775_l("nbt"));
            assert (head != null);
            ((FluidStack)head).amount = nodeTag.func_74762_e("count");
        }
        RGNode node = nodeTag.func_74767_n("phantom") ? new RGNode(nodeTag.func_74762_e("x"), nodeTag.func_74762_e("y"), container, head, true) : new RGNode(nodeTag.func_74762_e("x"), nodeTag.func_74762_e("y"), container, head, false);
        NBTTagList itemsList = nodeTag.func_150295_c("items", 10);
        NBTTagList fluidsList = nodeTag.func_150295_c("fluids", 10);
        LinkedList<ItemStack> itemInputs = new LinkedList<ItemStack>();
        itemsList.forEach(base -> {
            if (base instanceof NBTTagCompound) {
                itemInputs.add(new ItemStack((NBTTagCompound)base));
            }
        });
        LinkedList<FluidStack> fluidsInputs = new LinkedList<FluidStack>();
        fluidsList.forEach(base -> {
            if (base instanceof NBTTagCompound) {
                fluidsInputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)base)));
            }
        });
        node.setRecipe(itemInputs, fluidsInputs, nodeTag.func_74764_b("catalyst") ? new ItemStack(nodeTag.func_74775_l("catalyst")) : null, nodeTag.func_74762_e("per"));
        boolean visible = nodeTag.func_74767_n("visible");
        node.textWidget.setVisible(visible);
        node.textWidget.setActive(visible);
        return node;
    }

    public NBTTagCompound serializeNodeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("x", this.getSelfPosition().x + this.container.getScrollXOffset());
        nbt.func_74768_a("y", this.getSelfPosition().y + this.container.getScrollYOffset());
        nbt.func_74774_a("type", (byte)(this.head instanceof ItemStack ? 1 : (this.head instanceof FluidStack ? 2 : 0)));
        if (this.head instanceof ItemStack) {
            nbt.func_74782_a("nbt", (NBTBase)((ItemStack)this.head).serializeNBT());
            nbt.func_74768_a("count", ((ItemStack)this.head).func_190916_E());
        } else if (this.head instanceof FluidStack) {
            nbt.func_74782_a("nbt", (NBTBase)((FluidStack)this.head).writeToNBT(new NBTTagCompound()));
            nbt.func_74768_a("count", ((FluidStack)this.head).amount);
        }
        nbt.func_74757_a("phantom", this.widgets.stream().anyMatch(it -> it instanceof PhantomWidget));
        NBTTagList itemsList = new NBTTagList();
        NBTTagList fluidsList = new NBTTagList();
        NBTTagList childrenList = new NBTTagList();
        for (Map.Entry<Widget, Set<RGNode>> entry : this.children.entrySet()) {
            Widget widget = entry.getKey();
            if (widget instanceof SlotWidget) {
                itemsList.func_74742_a((NBTBase)((SlotWidget)widget).getHandle().func_75211_c().serializeNBT());
            } else {
                if (!(widget instanceof TankWidget)) continue;
                fluidsList.func_74742_a((NBTBase)((TankWidget)widget).fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
            }
            NBTTagIntArray childList = new NBTTagIntArray(entry.getValue().stream().mapToInt(it -> this.container.nodes.indexOf(it)).toArray());
            childrenList.func_74742_a((NBTBase)childList);
        }
        nbt.func_74782_a("items", (NBTBase)itemsList);
        nbt.func_74782_a("fluids", (NBTBase)fluidsList);
        nbt.func_74782_a("children", (NBTBase)childrenList);
        if (this.catalyst != null) {
            nbt.func_74782_a("catalyst", (NBTBase)this.catalyst.serializeNBT());
        }
        nbt.func_74768_a("per", this.recipePer);
        NBTTagList parentsList = new NBTTagList();
        for (Map.Entry<RGNode, Integer> entry : this.parentNodes.entrySet()) {
            parentsList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{this.container.nodes.indexOf(entry.getKey()), entry.getValue()}));
        }
        nbt.func_74782_a("parents", (NBTBase)parentsList);
        nbt.func_74757_a("visible", this.textWidget.isVisible());
        return nbt;
    }

    private void setRecipe(List<ItemStack> itemInputs, List<FluidStack> fluidInputs, ItemStack catalyst, int recipePer) {
        Widget widget;
        this.recipePer = recipePer;
        this.catalyst = catalyst;
        this.inputsGroup.clearAllWidgets();
        for (Set<RGNode> childs : this.children.values()) {
            for (RGNode child : childs) {
                child.removeParent(this);
            }
        }
        this.children.clear();
        AtomicInteger y = new AtomicInteger(-20);
        for (ItemStack itemInput : itemInputs) {
            final ItemStackHandler handler = new ItemStackHandler(1);
            handler.setStackInSlot(0, itemInput);
            widget = new SlotWidget((IItemHandler)handler, 0, 0, y.addAndGet(20), false, false){

                @Override
                public boolean mouseClicked(int mouseX, int mouseY, int button) {
                    return RGNode.this.handleTipsSlotClick(mouseX, mouseY, this, handler.getStackInSlot(0).func_77946_l());
                }
            }.setBackgroundTexture(TerminalTheme.COLOR_B_2);
            this.inputsGroup.addWidget(widget);
            this.children.put(widget, new HashSet());
        }
        for (FluidStack fluidInput : fluidInputs) {
            final FluidTank tank = new FluidTank(fluidInput, Integer.MAX_VALUE);
            widget = new TankWidget((IFluidTank)tank, 0, y.addAndGet(20), 18, 18){

                @Override
                public boolean mouseClicked(int mouseX, int mouseY, int button) {
                    return RGNode.this.handleTipsSlotClick(mouseX, mouseY, this, tank.getFluid().copy());
                }
            }.setAlwaysShowFull(true).setBackgroundTexture(TerminalTheme.COLOR_B_2).setClient();
            this.inputsGroup.addWidget(widget);
            this.children.put(widget, new HashSet());
        }
        this.inputsGroup.setSelfPosition(new Position(25, -(this.inputsGroup.widgets.size() * 20) / 2 + 8));
    }

    private boolean handleTipsSlotClick(int mouseX, int mouseY, Widget slot, Object object) {
        if (slot.isMouseOverElement(mouseX, mouseY)) {
            Position position = this.inputsGroup.getSelfPosition();
            RGNode child = this.container.addNode(this.getSelfPosition().x + 50, this.getSelfPosition().y + position.y + slot.getSelfPosition().y, object);
            Set<RGNode> childs = this.children.get(slot);
            childs.add(child);
            child.addParent(this);
            this.updateDemand(this.getHeadDemand());
            return true;
        }
        return false;
    }

    public void updateSelected(boolean selected) {
        this.isSelected = selected;
        if (selected) {
            this.toolGroup.setActive(true);
            this.toolGroup.setVisible(true);
            this.inputsGroup.setActive(true);
            this.inputsGroup.setVisible(true);
        } else {
            this.toolGroup.setActive(false);
            this.toolGroup.setVisible(false);
            this.inputsGroup.setActive(false);
            this.inputsGroup.setVisible(false);
        }
        this.children.forEach((widget, rgNode) -> rgNode.forEach(child -> this.container.addOrUpdateLine(this, (RGNode)child)));
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.isSelected) {
            RGNode.drawBorder(x, y, width, height, -16711936, 2);
        }
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean allowDrag(int mouseX, int mouseY, int button) {
        return this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (!this.isSelected) {
                this.container.setSelectedNode(this);
            }
            super.mouseClicked(mouseX, mouseY, button);
            return false;
        }
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isSelected) {
            this.container.setSelectedNode(null);
        }
        return false;
    }
}

