/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.recipechart.widget;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.terminal.gui.widgets.DraggableScrollableWidgetGroup;
import gregtech.api.terminal.os.TerminalDialogWidget;
import gregtech.api.terminal.os.TerminalOSWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.common.terminal.app.recipechart.widget.RGLine;
import gregtech.common.terminal.app.recipechart.widget.RGNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RGContainer
extends DraggableScrollableWidgetGroup {
    protected TerminalOSWidget os;
    private RGNode selectedNode;
    private RGLine selectedLine;
    protected final List<RGNode> nodes;
    protected final List<RGLine> lines;

    public RGContainer(int x, int y, int width, int height, TerminalOSWidget os) {
        super(x, y, width, height);
        this.os = os;
        this.setDraggable(true);
        this.setXScrollBarHeight(4);
        this.setYScrollBarWidth(4);
        this.setXBarStyle(null, TerminalTheme.COLOR_F_1);
        this.setYBarStyle(null, TerminalTheme.COLOR_F_1);
        this.nodes = new ArrayList<RGNode>();
        this.lines = new ArrayList<RGLine>();
    }

    public RGNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(RGNode selectedNode) {
        if (this.selectedNode != null) {
            this.selectedNode.updateSelected(false);
        }
        this.selectedNode = selectedNode;
        if (this.selectedNode != null) {
            this.selectedNode.updateSelected(true);
        }
    }

    public RGLine getSelectedLine() {
        return this.selectedLine;
    }

    public void setSelectedLine(RGLine selectedLine) {
        if (this.selectedLine != null) {
            this.selectedLine.updateSelected(false);
        }
        this.selectedLine = selectedLine;
        if (this.selectedLine != null) {
            this.selectedLine.updateSelected(true);
        }
    }

    public RGNode addNode(int x, int y) {
        RGNode node = new RGNode(x + this.getScrollXOffset(), y + this.getScrollYOffset(), this, null, true);
        this.nodes.add(node);
        this.addWidget(node);
        return node;
    }

    public RGNode addNode(int x, int y, Object object) {
        RGNode node = new RGNode(x + this.getScrollXOffset(), y + this.getScrollYOffset(), this, object, false);
        this.nodes.add(node);
        this.addWidget(node);
        return node;
    }

    public void removeNode(RGNode node) {
        this.nodes.remove(node);
        this.waitToRemoved(node);
    }

    public void addOrUpdateLine(RGNode parent, RGNode child) {
        Optional<RGLine> optional = this.lines.stream().filter(line -> line.getParent() == parent && line.getChild() == child).findFirst();
        if (!optional.isPresent()) {
            RGLine line2 = new RGLine(parent, child, this);
            this.lines.add(line2);
            this.addWidget(0, line2);
        } else {
            optional.get().updateLine();
        }
    }

    public RGLine getLine(RGNode parent, RGNode child) {
        Optional<RGLine> optional = this.lines.stream().filter(line -> line.getParent() == parent && line.getChild() == child).findFirst();
        return optional.orElse(null);
    }

    public void removeLine(RGNode parent, RGNode child) {
        this.lines.removeIf(line -> {
            if (line.getParent() == parent && line.getChild() == child) {
                this.waitToRemoved((Widget)line);
                return true;
            }
            return false;
        });
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        try {
            this.clearAllWidgets();
            this.nodes.clear();
            this.lines.clear();
            NBTTagList nodesList = nbt.func_150295_c("nodes", 10);
            for (Object node : nodesList) {
                this.nodes.add(RGNode.deserializeNodeNBT((NBTTagCompound)node, this));
            }
            Iterator iterator = nodesList.iterator();
            for (RGNode node : this.nodes) {
                NBTTagCompound nodeTag = (NBTTagCompound)iterator.next();
                node.deserializeRelationNBT(nodeTag.func_150295_c("parents", 11), nodeTag.func_150295_c("children", 11));
                this.addWidget(node);
            }
            for (RGLine line : this.lines) {
                this.removeWidget(line);
            }
            this.lines.clear();
            NBTTagList linesList = nbt.func_150295_c("lines", 10);
            for (NBTBase node : linesList) {
                RGLine line = RGLine.deserializeLineNBT((NBTTagCompound)node, this);
                this.lines.add(line);
                this.addWidget(0, line);
            }
        }
        catch (Exception e) {
            TerminalDialogWidget.showInfoDialog(this.os, "ERROR", e.getMessage()).setClientSide().open();
        }
    }

    public NBTTagCompound saveAsNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList nodesTag = new NBTTagList();
        for (RGNode node : this.nodes) {
            nodesTag.func_74742_a((NBTBase)node.serializeNodeNBT());
        }
        nbt.func_74782_a("nodes", (NBTBase)nodesTag);
        NBTTagList linesTag = new NBTTagList();
        for (RGLine line : this.lines) {
            linesTag.func_74742_a((NBTBase)line.serializeLineNBT());
        }
        nbt.func_74782_a("lines", (NBTBase)linesTag);
        return nbt;
    }

    @Override
    protected int getMaxHeight() {
        return super.getMaxHeight() + 20;
    }

    @Override
    protected int getMaxWidth() {
        return super.getMaxWidth() + 20;
    }

    @Override
    protected boolean hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        if (this.draggedWidget != null && this.draggedWidget == this.selectedNode) {
            for (RGNode node : this.nodes) {
                if (node == this.selectedNode || !node.canMerge(this.selectedNode)) continue;
                RGContainer.drawBorder(node.getPosition().x, node.getPosition().y, 18, 18, -16776961, 2);
                break;
            }
        }
        return super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.draggedWidget != null && this.draggedWidget == this.selectedNode) {
            for (RGNode node : this.nodes) {
                if (node == this.selectedNode || !node.canMerge(this.selectedNode)) continue;
                node.mergeNode(this.selectedNode);
                break;
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseWheelMove(mouseX, mouseY, wheelDelta)) continue;
            return true;
        }
        return false;
    }
}

