/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.hardwaremanager;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.gui.resources.ResourceHelper;
import gregtech.api.gui.resources.ShaderTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.TerminalRegistry;
import gregtech.api.terminal.app.AbstractApplication;
import gregtech.api.terminal.gui.widgets.RectButtonWidget;
import gregtech.api.terminal.hardware.Hardware;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.client.shader.Shaders;
import gregtech.common.items.MetaItems;
import gregtech.common.terminal.app.hardwaremanager.HardwareSlotWidget;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HardwareManagerApp
extends AbstractApplication {
    private static final TextureArea CIRCUIT_LINE = TextureArea.fullImage("textures/gui/terminal/hardware_manager/circuit.png");
    @SideOnly(value=Side.CLIENT)
    private ShaderTexture circuit;
    private HardwareSlotWidget selected;
    private WidgetGroup apps;

    public HardwareManagerApp() {
        super("hardware");
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(MetaItems.INTEGRATED_CIRCUIT.getStackForm(), new ItemStack[0]);
    }

    @Override
    public AbstractApplication initApp() {
        this.apps = new WidgetGroup();
        this.addWidget(this.apps);
        int x = 10;
        int y = 65;
        for (Hardware hardware : this.os.hardwareProvider.getProviders().values()) {
            HardwareSlotWidget hardwareSlotWidget = new HardwareSlotWidget(x, y, this.os, hardware);
            this.addWidget(hardwareSlotWidget);
            hardwareSlotWidget.setOnSelected(() -> {
                this.selected = hardwareSlotWidget;
                this.apps.clearAllWidgets();
                AtomicInteger index = new AtomicInteger(0);
                for (AbstractApplication installed : this.getOs().installedApps) {
                    TerminalRegistry.getAppHardwareDemand(installed.getRegistryName(), this.getOs().tabletNBT.func_74775_l(installed.getRegistryName()).func_74762_e("_tier")).stream().filter(hardware::isHardwareAdequate).findFirst().ifPresent(X -> {
                        this.apps.addWidget(new RectButtonWidget(162 + index.get() % 4 * 25, 122 + index.get() / 4 * 30, 20, 20, 2).setIcon(installed.getIcon()).setHoverText(installed.getUnlocalizedName()).setColors(0, TerminalTheme.COLOR_7.getColor(), 0));
                        index.getAndIncrement();
                    });
                }
            });
            x += 25;
        }
        return this;
    }

    @Override
    protected void hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        float time = ((float)this.gui.entityPlayer.field_70173_aa + partialTicks) / 20.0f;
        if (Shaders.allowedShader()) {
            if (this.circuit == null) {
                this.circuit = ShaderTexture.createShader("circuit.frag");
            }
            ResourceHelper.bindTexture("textures/gui/terminal/terminal_background.png");
            this.circuit.draw(x, y, width, height, uniformCache -> {
                uniformCache.glUniform1F("u_time", time);
                uniformCache.glUniform2F("u_mouse", (float)(mouseX - x) * this.circuit.getResolution(), (float)(mouseY - y) * this.circuit.getResolution());
            });
        } else {
            HardwareManagerApp.drawSolidRect(x, y, width, height, TerminalTheme.COLOR_B_2.getColor());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        CIRCUIT_LINE.draw(x, y, width, height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.hookDrawInBackground(mouseX, mouseY, partialTicks, context);
        if (this.selected != null) {
            int sX = x + this.selected.getSelfPosition().x;
            int sY = y + this.selected.getSelfPosition().y;
            int sW = this.selected.getSize().width;
            int sH = this.selected.getSize().height;
            HardwareManagerApp.drawBorder(sX, sY, sW, sH, -16732416, 1);
            HardwareManagerApp.drawSolidRect(sX + sW / 2, sY + sH, 1, 10, -16732416);
            HardwareManagerApp.drawSolidRect(sX + sW / 2, sY + sH + 10, x + 210 - sX - sW / 2, 1, -16732416);
            HardwareManagerApp.drawSolidRect(x + 210, sY + sH + 10, 1, y + 110 - sY - sH, -16732416);
        }
        HardwareManagerApp.drawBorder(x + 160, y + 120, 100, 100, this.selected == null ? -1 : -16732416, 1);
    }
}

