/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guideeditor.widget;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.terminal.gui.widgets.CircleButtonWidget;
import gregtech.api.terminal.gui.widgets.CustomPositionSizeWidget;
import gregtech.api.terminal.os.TerminalTheme;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.interpolate.Eases;
import gregtech.api.util.interpolate.Interpolator;
import gregtech.common.terminal.app.guide.widget.GuidePageWidget;
import gregtech.common.terminal.app.guide.widget.IGuideWidget;
import gregtech.common.terminal.app.guideeditor.widget.GuideConfigEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class GuidePageEditorWidget
extends GuidePageWidget {
    private Widget selected;
    private final WidgetGroup toolButtons;
    private final CustomPositionSizeWidget customPositionSizeWidget;
    private GuideConfigEditor configEditor;
    private String section = "default";

    public GuidePageEditorWidget(int xPosition, int yPosition, int width, int height, int margin) {
        super(xPosition, yPosition, width, height, margin);
        this.setDraggable(false);
        this.setTitle("Template");
        this.customPositionSizeWidget = new CustomPositionSizeWidget(-16776961, -65536, 2).setOnUpdated(this::onPosSizeChanged);
        this.toolButtons = new WidgetGroup(Position.ORIGIN, Size.ZERO);
        this.toolButtons.setVisible(false);
        this.toolButtons.addWidget(new CircleButtonWidget(-20, -4, 8, 1, 12).setColors(0, TerminalTheme.COLOR_B_2.getColor(), TerminalTheme.COLOR_1.getColor()).setIcon(GuiTextures.ICON_UP).setHoverText("terminal.guide_editor.up").setClickListener(this::moveUp));
        this.toolButtons.addWidget(new CircleButtonWidget(0, -4, 8, 1, 12).setColors(0, TerminalTheme.COLOR_B_2.getColor(), TerminalTheme.COLOR_2.getColor()).setIcon(GuiTextures.ICON_DOWN).setHoverText("terminal.guide_editor.down").setClickListener(this::moveDown));
        this.toolButtons.addWidget(new CircleButtonWidget(20, -4, 8, 1, 12).setColors(0, TerminalTheme.COLOR_B_2.getColor(), TerminalTheme.COLOR_3.getColor()).setIcon(GuiTextures.ICON_REMOVE).setHoverText("terminal.guide_editor.remove").setClickListener(this::delete));
        this.addWidget(this.customPositionSizeWidget);
        this.addWidget(this.toolButtons);
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getSection() {
        return this.section;
    }

    private void onPosSizeChanged(Position pos, Size size) {
        Widget widget = this.customPositionSizeWidget.getControlled();
        if (widget instanceof IGuideWidget && ((IGuideWidget)((Object)widget)).isFixed()) {
            JsonObject config = ((IGuideWidget)((Object)widget)).getConfig();
            if (config.has("x")) {
                config.addProperty("x", (Number)(pos.x + this.scrollXOffset));
                ((IGuideWidget)((Object)widget)).updateValue("x");
            }
            if (config.has("y")) {
                config.addProperty("y", (Number)(pos.y + this.scrollYOffset));
                ((IGuideWidget)((Object)widget)).updateValue("y");
            }
            if (config.has("width")) {
                config.addProperty("width", (Number)size.width);
                ((IGuideWidget)((Object)widget)).updateValue("width");
            }
            if (config.has("height")) {
                config.addProperty("height", (Number)size.height);
                ((IGuideWidget)((Object)widget)).updateValue("height");
            }
            ((IGuideWidget)((Object)widget)).onFixedPositionSizeChanged(pos, size);
        }
        this.toolButtons.setSelfPosition(new Position(pos.x + size.width / 2, pos.y));
    }

    public void setGuideConfigEditor(GuideConfigEditor configEditor) {
        this.configEditor = configEditor;
    }

    private void setToolButton(Widget widget) {
        this.customPositionSizeWidget.setControlled(widget);
        this.customPositionSizeWidget.setVisible(true);
        this.customPositionSizeWidget.setActive(!(widget instanceof IGuideWidget) || ((IGuideWidget)((Object)widget)).isFixed());
        this.toolButtons.setVisible(true);
        this.toolButtons.setSelfPosition(new Position(widget.getSelfPosition().x + widget.getSize().width / 2, widget.getSelfPosition().y));
    }

    private void delete(Widget.ClickData clickData) {
        this.removeWidget(this.selected);
        this.selected = null;
        this.configEditor.loadConfigurator(null);
        this.toolButtons.setSelfPosition(new Position(-this.scrollYOffset, -this.scrollYOffset));
        this.customPositionSizeWidget.setControlled(null);
        this.toolButtons.setVisible(false);
    }

    private void moveUp(Widget.ClickData clickData) {
        this.moveUp(this.selected);
    }

    private void moveDown(Widget.ClickData clickData) {
        this.moveDown(this.selected);
    }

    public JsonObject getJsonConfig() {
        JsonObject json = new JsonObject();
        json.addProperty("section", this.section);
        json.addProperty("title", this.title.content.get(0));
        JsonArray array = new JsonArray();
        json.add("stream", (JsonElement)array);
        this.stream.forEach(widget -> {
            if (widget instanceof IGuideWidget) {
                array.add((JsonElement)((IGuideWidget)((Object)widget)).getConfig());
            }
        });
        JsonArray array2 = new JsonArray();
        json.add("fixed", (JsonElement)array2);
        this.fixed.forEach(widget -> {
            if (widget instanceof IGuideWidget) {
                array2.add((JsonElement)((IGuideWidget)((Object)widget)).getConfig());
            }
        });
        return json;
    }

    public JsonObject addGuideWidget(IGuideWidget widget, boolean isFixed) {
        int pageWidth = this.getPageWidth();
        int margin = this.getMargin();
        JsonObject widgetConfig = widget.getTemplate(isFixed);
        if (isFixed) {
            int width = widgetConfig.get("width").getAsInt();
            int height = widgetConfig.get("height").getAsInt();
            Widget guideWidget = widget.updateOrCreateFixedWidget((pageWidth - width) / 2 + 5, this.scrollYOffset + (this.getSize().height - height) / 2, width, height, widgetConfig);
            this.fixed.add(guideWidget);
            this.addWidget(guideWidget);
        } else {
            Widget guideWidget;
            int index = this.stream.indexOf(this.selected);
            if (index >= 0) {
                guideWidget = widget.updateOrCreateStreamWidget(margin, this.selected.getSize().height + this.selected.getSelfPosition().y + this.scrollYOffset + 5, pageWidth - 2 * margin, widgetConfig);
                for (int i = index + 1; i < this.stream.size(); ++i) {
                    ((Widget)this.stream.get(i)).addSelfPosition(0, guideWidget.getSize().height + 5);
                }
                this.stream.add(index + 1, guideWidget);
            } else {
                guideWidget = widget.updateOrCreateStreamWidget(margin, this.getStreamBottom() + 5, pageWidth - 2 * margin, widgetConfig);
                this.stream.add(guideWidget);
            }
            this.addWidget(guideWidget);
            this.computeMax();
        }
        return widgetConfig;
    }

    public void moveUp(Widget widget) {
        int index = this.stream.indexOf(widget);
        if (index > 0) {
            Widget target = (Widget)this.stream.get(index - 1);
            if (this.interpolator == null) {
                int offsetD = 5 + widget.getSize().height;
                int offsetU = widget.getPosition().y - target.getPosition().y;
                int y1 = widget.getSelfPosition().y;
                int y2 = target.getSelfPosition().y;
                this.interpolator = new Interpolator(0.0f, 1.0f, 10, Eases.EaseLinear, value -> {
                    widget.setSelfPosition(new Position(widget.getSelfPosition().x, (int)((float)y1 - value.floatValue() * (float)offsetU)));
                    target.setSelfPosition(new Position(target.getSelfPosition().x, (int)((float)y2 + value.floatValue() * (float)offsetD)));
                    if (widget == this.selected) {
                        this.setToolButton(this.selected);
                    }
                    widget.setVisible(widget.getSelfPosition().y < this.scrollYOffset + this.getSize().height && widget.getSelfPosition().y + widget.getSize().height > 0);
                    target.setVisible(target.getSelfPosition().y < this.scrollYOffset + this.getSize().height && target.getSelfPosition().y + target.getSize().height > 0);
                }, value -> {
                    this.interpolator = null;
                    this.stream.remove(widget);
                    this.stream.add(index - 1, widget);
                }).start();
            }
        } else {
            int index2 = this.fixed.indexOf(widget);
            if (index2 >= 0 && index2 < this.fixed.size() - 1) {
                Widget target = (Widget)this.fixed.get(index2 + 1);
                this.fixed.remove(widget);
                this.fixed.add(index2 + 1, widget);
            }
        }
    }

    public void moveDown(Widget widget) {
        int index = this.stream.indexOf(widget);
        if (index >= 0 && index < this.stream.size() - 1) {
            Widget target = (Widget)this.stream.get(index + 1);
            if (this.interpolator == null) {
                int offsetD = 5 + target.getSize().height;
                int offsetU = target.getPosition().y - widget.getPosition().y;
                int y1 = widget.getSelfPosition().y;
                int y2 = target.getSelfPosition().y;
                this.interpolator = new Interpolator(0.0f, 1.0f, 10, Eases.EaseLinear, value -> {
                    widget.setSelfPosition(new Position(widget.getSelfPosition().x, (int)((float)y1 + value.floatValue() * (float)offsetD)));
                    target.setSelfPosition(new Position(target.getSelfPosition().x, (int)((float)y2 - value.floatValue() * (float)offsetU)));
                    if (widget == this.selected) {
                        this.setToolButton(this.selected);
                    }
                    widget.setVisible(widget.getSelfPosition().y < this.getSize().height - this.xBarHeight && widget.getSelfPosition().y + widget.getSize().height > 0);
                    target.setVisible(target.getSelfPosition().y < this.getSize().height - this.xBarHeight && target.getSelfPosition().y + target.getSize().height > 0);
                }, value -> {
                    this.interpolator = null;
                    this.stream.remove(widget);
                    this.stream.add(index + 1, widget);
                }).start();
            }
        } else {
            int index2 = this.fixed.indexOf(widget);
            if (index2 > 0) {
                Widget target = (Widget)this.fixed.get(index2 - 1);
                this.fixed.remove(widget);
                this.fixed.add(index2 - 1, widget);
            }
        }
    }

    @Override
    protected void setScrollYOffset(int scrollYOffset) {
        if (scrollYOffset == this.scrollYOffset) {
            return;
        }
        int offset = scrollYOffset - this.scrollYOffset;
        this.scrollYOffset = scrollYOffset;
        for (Widget widget : this.widgets) {
            Position newPos = widget.addSelfPosition(0, -offset);
            if (widget == this.toolButtons) continue;
            widget.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
        }
    }

    @Override
    public void removeWidget(Widget widget) {
        int index = this.stream.indexOf(widget);
        if (index >= 0) {
            int offset = widget.getSize().height + 5;
            for (int i = this.stream.size() - 1; i > index; --i) {
                Widget bottom = (Widget)this.stream.get(i);
                Position newPos = bottom.addSelfPosition(0, -offset);
                bottom.setVisible(newPos.y < this.getSize().height - this.xBarHeight && newPos.y + widget.getSize().height > 0);
            }
            this.stream.remove(widget);
        } else {
            this.fixed.remove(widget);
        }
        super.removeWidget(widget);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        boolean flag = false;
        for (int i = this.fixed.size() - 1; i >= 0; --i) {
            Widget widget = (Widget)this.fixed.get(i);
            if (!widget.isMouseOverElement(mouseX, mouseY)) continue;
            if (widget instanceof IGuideWidget && widget != this.selected) {
                this.configEditor.loadConfigurator((IGuideWidget)((Object)widget));
                this.selected = widget;
                this.setToolButton(this.selected);
            }
            this.playButtonClickSound();
            flag = true;
            break;
        }
        if (!flag) {
            for (Widget widget : this.stream) {
                if (!widget.isMouseOverElement(mouseX, mouseY)) continue;
                if (widget instanceof IGuideWidget && widget != this.selected) {
                    this.configEditor.loadConfigurator((IGuideWidget)((Object)widget));
                    this.selected = widget;
                    this.setToolButton(this.selected);
                }
                this.playButtonClickSound();
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    protected boolean hookDrawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int width = this.getSize().width;
        if (this.title.isVisible()) {
            this.title.drawInBackground(mouseX, mouseY, partialTicks, context);
        }
        for (Object widget : this.stream) {
            if (!((Widget)widget).isVisible()) continue;
            ((Widget)widget).drawInBackground(mouseX, mouseY, partialTicks, context);
        }
        boolean flag = false;
        for (Widget widget : this.fixed) {
            if (!widget.isVisible()) continue;
            widget.drawInBackground(mouseX, mouseY, partialTicks, context);
            if (!widget.isMouseOverElement(mouseX, mouseY)) continue;
            if (widget != this.selected) {
                this.drawSelectedBorder(x, width, widget);
            }
            flag = true;
        }
        if (!flag) {
            for (Widget widget : this.stream) {
                if (!widget.isVisible() || widget == this.selected || !widget.isMouseOverElement(mouseX, mouseY)) continue;
                this.drawSelectedBorder(x, width, widget);
            }
        }
        if (this.selected != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int index = this.fixed.indexOf(this.selected);
            String layer = "L: " + (index >= 0 ? index : this.stream.indexOf(this.selected));
            fontRenderer.func_175065_a(layer, (float)(this.selected.getPosition().x + (this.selected.getSize().width - fontRenderer.func_78256_a(layer)) / 2), (float)(this.selected.getPosition().y - 20), -65536, true);
        }
        if (this.toolButtons.isVisible()) {
            this.customPositionSizeWidget.drawInBackground(mouseX, mouseY, partialTicks, context);
            this.toolButtons.drawInBackground(mouseX, mouseY, partialTicks, context);
        }
        return true;
    }

    private void drawSelectedBorder(int x, int width, Widget widget) {
        Position pos = widget.getPosition();
        Size s = widget.getSize();
        if (this.stream.contains(widget)) {
            GuidePageEditorWidget.drawSolidRect(x, pos.y, width - this.yBarWidth, s.height, 0x6F000000);
        } else {
            GuidePageEditorWidget.drawSolidRect(pos.x, pos.y, s.width, s.height, 0x6F000000);
        }
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (super.mouseDragged(mouseX, mouseY, button, timeDragged) && this.toolButtons.isVisible()) {
            this.setToolButton(this.selected);
            return true;
        }
        return false;
    }

    @Override
    public void clearAllWidgets() {
        super.clearAllWidgets();
        this.selected = null;
        this.configEditor.loadConfigurator(null);
        this.toolButtons.setSelfPosition(new Position(-this.scrollYOffset, -this.scrollYOffset));
        this.customPositionSizeWidget.setControlled(null);
        this.toolButtons.setVisible(false);
        this.addWidget(this.customPositionSizeWidget);
        this.addWidget(this.toolButtons);
    }
}

