/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.terminal.app.guide;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.ItemStackTexture;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.common.items.MetaItems;
import gregtech.common.terminal.app.guide.GuideApp;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemGuideApp
extends GuideApp<GuideItem> {
    public ItemGuideApp() {
        super("items", new ItemStackTexture(MetaItems.PROSPECTOR_LV.getStackForm(), new ItemStack[0]));
    }

    @Override
    protected String itemName(GuideItem item) {
        return item.stack.func_82833_r();
    }

    @Override
    protected String rawItemName(GuideItem item) {
        if (item.stack.func_77973_b() instanceof MetaItem) {
            return ((MetaItem.MetaValueItem)((MetaItem)item.stack.func_77973_b()).getItem((short)((short)item.stack.func_77960_j()))).unlocalizedName;
        }
        return item.stack.func_77977_a();
    }

    @Override
    protected IGuiTexture itemIcon(GuideItem item) {
        return new ItemStackTexture(item.stack, new ItemStack[0]);
    }

    @Override
    public GuideItem ofJson(JsonObject json) {
        return GuideItem.ofJson(json);
    }

    public static class GuideItem {
        public final ItemStack stack;
        public final String name;

        public GuideItem(ItemStack stack, String name) {
            this.stack = stack;
            this.name = name;
        }

        public GuideItem(ItemStack stack) {
            this(stack, stack.func_77973_b().getRegistryName().toString() + ":" + stack.func_77960_j());
        }

        public GuideItem(MetaItem.MetaValueItem item) {
            this(item.getStackForm(), item.unlocalizedName);
        }

        public static GuideItem ofJson(JsonObject json) {
            JsonElement element;
            if (json.has("item") && (element = json.get("item")).isJsonPrimitive()) {
                String[] s = element.getAsString().split(":");
                if (s.length < 2) {
                    return null;
                }
                Item item = Item.func_111206_d((String)(s[0] + ":" + s[1]));
                if (item == null) {
                    return null;
                }
                int meta = 0;
                if (s.length > 2) {
                    meta = Integer.parseInt(s[2]);
                }
                return new GuideItem(new ItemStack(item, 1, meta));
            }
            if (json.has("metaitem")) {
                String metaItemId = json.get("metaitem").getAsString();
                for (MetaItem<?> metaItem : MetaItem.getMetaItems()) {
                    MetaItem.MetaValueItem metaValueItem = metaItem.getAllItems().stream().filter(m -> m.unlocalizedName.equals(metaItemId)).findFirst().orElse(null);
                    if (metaValueItem == null) continue;
                    return new GuideItem(metaValueItem);
                }
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GuideItem guideItem = (GuideItem)o;
            return Objects.equals(this.stack, guideItem.stack) && Objects.equals(this.name, guideItem.name);
        }

        public int hashCode() {
            return Objects.hash(this.stack, this.name);
        }
    }
}

