/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.net;

import gregtech.api.cover.CoverBehavior;
import gregtech.api.pipenet.PipeNetWalker;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverItemFilter;
import gregtech.common.covers.CoverShutter;
import gregtech.common.covers.ItemFilterMode;
import gregtech.common.pipelike.itempipe.net.ItemPipeNet;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemNetWalker
extends PipeNetWalker {
    private ItemPipeProperties minProperties;
    private final List<ItemPipeNet.Inventory> inventories;
    private final List<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
    private final EnumMap<EnumFacing, List<Predicate<ItemStack>>> nextFilters = new EnumMap(EnumFacing.class);
    private BlockPos sourcePipe;
    private EnumFacing facingToHandler;

    public static List<ItemPipeNet.Inventory> createNetData(World world, BlockPos sourcePipe, EnumFacing faceToSourceHandler) {
        ItemNetWalker walker = new ItemNetWalker(world, sourcePipe, 1, new ArrayList<ItemPipeNet.Inventory>(), null);
        walker.sourcePipe = sourcePipe;
        walker.facingToHandler = faceToSourceHandler;
        walker.traversePipeNet();
        return walker.isFailed() ? null : walker.inventories;
    }

    protected ItemNetWalker(World world, BlockPos sourcePipe, int distance, List<ItemPipeNet.Inventory> inventories, ItemPipeProperties properties) {
        super(world, sourcePipe, distance);
        this.inventories = inventories;
        this.minProperties = properties;
    }

    @Override
    protected PipeNetWalker createSubWalker(World world, EnumFacing facingToNextPos, BlockPos nextPos, int walkedBlocks) {
        ItemNetWalker walker = new ItemNetWalker(world, nextPos, walkedBlocks, this.inventories, this.minProperties);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.filters.addAll(this.filters);
        List<Predicate<ItemStack>> moreFilters = this.nextFilters.get(facingToNextPos);
        if (moreFilters != null && !moreFilters.isEmpty()) {
            walker.filters.addAll(moreFilters);
        }
        return walker;
    }

    @Override
    protected void checkPipe(IPipeTile<?, ?> pipeTile, BlockPos pos) {
        for (List<Predicate<ItemStack>> filters : this.nextFilters.values()) {
            if (filters.isEmpty()) continue;
            this.filters.addAll(filters);
        }
        this.nextFilters.clear();
        ItemPipeProperties pipeProperties = (ItemPipeProperties)((TileEntityItemPipe)pipeTile).getNodeData();
        this.minProperties = this.minProperties == null ? pipeProperties : new ItemPipeProperties(this.minProperties.getPriority() + pipeProperties.getPriority(), Math.min(this.minProperties.getTransferRate(), pipeProperties.getTransferRate()));
    }

    @Override
    protected void checkNeighbour(IPipeTile<?, ?> pipeTile, BlockPos pipePos, EnumFacing faceToNeighbour, @Nullable TileEntity neighbourTile) {
        if (neighbourTile == null || GTUtility.arePosEqual(pipePos, this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        IItemHandler handler = (IItemHandler)neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, faceToNeighbour.func_176734_d());
        if (handler != null) {
            ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>(this.filters);
            List<Predicate<ItemStack>> moreFilters = this.nextFilters.get(faceToNeighbour);
            if (moreFilters != null && !moreFilters.isEmpty()) {
                filters.addAll(moreFilters);
            }
            this.inventories.add(new ItemPipeNet.Inventory(new BlockPos((Vec3i)pipePos), faceToNeighbour, this.getWalkedBlocks(), this.minProperties, filters));
        }
    }

    @Override
    protected boolean isValidPipe(IPipeTile<?, ?> currentPipe, IPipeTile<?, ?> neighbourPipe, BlockPos pipePos, EnumFacing faceToNeighbour) {
        if (!(neighbourPipe instanceof TileEntityItemPipe)) {
            return false;
        }
        CoverBehavior thisCover = currentPipe.getCoverableImplementation().getCoverAtSide(faceToNeighbour);
        CoverBehavior neighbourCover = neighbourPipe.getCoverableImplementation().getCoverAtSide(faceToNeighbour.func_176734_d());
        ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
        if (thisCover instanceof CoverShutter) {
            filters.add(stack -> !thisCover.isValid() || !((CoverShutter)thisCover).isWorkingEnabled());
        } else if (thisCover instanceof CoverItemFilter && ((CoverItemFilter)thisCover).getFilterMode() != ItemFilterMode.FILTER_INSERT) {
            filters.add(((CoverItemFilter)thisCover)::testItemStack);
        }
        if (neighbourCover instanceof CoverShutter) {
            filters.add(stack -> !neighbourCover.isValid() || !((CoverShutter)neighbourCover).isWorkingEnabled());
        } else if (neighbourCover instanceof CoverItemFilter && ((CoverItemFilter)neighbourCover).getFilterMode() != ItemFilterMode.FILTER_EXTRACT) {
            filters.add(((CoverItemFilter)neighbourCover)::testItemStack);
        }
        if (!filters.isEmpty()) {
            this.nextFilters.put(faceToNeighbour, filters);
        }
        return true;
    }
}

