/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FilteredItemHandler;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ThermalFluidHandlerItemStack;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.FluidContainerSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomTankWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MetaTileEntityQuantumTank
extends MetaTileEntity
implements ITieredMetaTileEntity,
IActiveOutputSide {
    private final int VOID_PERCENT = 95;
    private final int tier;
    private final int maxFluidCapacity;
    private final int maxPartialFluidCapacity;
    private FluidTank fluidTank;
    private boolean autoOutputFluids;
    private EnumFacing outputFacing;
    private boolean allowInputFromOutputSide = false;
    protected IFluidHandler outputFluidInventory;
    private boolean isLocked;
    private boolean isVoiding;
    private boolean isPartialVoiding;
    private FluidTank lockedFluid;

    public MetaTileEntityQuantumTank(ResourceLocation metaTileEntityId, int tier, int maxFluidCapacity) {
        super(metaTileEntityId);
        this.tier = tier;
        this.maxFluidCapacity = maxFluidCapacity;
        this.maxPartialFluidCapacity = (int)Math.round((double)maxFluidCapacity * 0.95);
        this.initializeInventory();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.lockedFluid = new FluidTank(1);
        this.fluidTank = new FilteredFluidHandler(this.maxFluidCapacity).setFillPredicate(fs -> this.lockedFluid.getFluid() == null || fs.isFluidEqual(this.lockedFluid.getFluid()));
        this.fluidInventory = this.fluidTank;
        this.importFluids = new FluidTankList(false, new IFluidTank[]{this.fluidTank});
        this.exportFluids = new FluidTankList(false, new IFluidTank[]{this.fluidTank});
        this.outputFluidInventory = new FluidHandlerProxy(new FluidTankList(false, new IFluidTank[0]), this.exportFluids);
    }

    @Override
    public int getActualComparatorValue() {
        FluidTank fluidTank = this.fluidTank;
        int fluidAmount = fluidTank.getFluidAmount();
        int maxCapacity = fluidTank.getCapacity();
        float f = (float)fluidAmount / ((float)maxCapacity * 1.0f);
        return MathHelper.func_76141_d((float)(f * 14.0f)) + (fluidAmount > 0 ? 1 : 0);
    }

    @Override
    public void update() {
        super.update();
        EnumFacing currentOutputFacing = this.getOutputFacing();
        if (!this.getWorld().field_72995_K) {
            if (this.isVoiding) {
                this.fluidTank.setFluid(null);
            } else if (this.isPartialVoiding && this.fluidTank.getFluid() != null && this.fluidTank.getFluidAmount() > this.maxPartialFluidCapacity) {
                this.fluidTank.setFluid(GTUtility.copyAmount(this.maxPartialFluidCapacity, this.fluidTank.getFluid()));
            }
            if (this.isLocked && this.lockedFluid.getFluid() == null && this.fluidTank.getFluid() != null) {
                this.lockedFluid.setFluid(GTUtility.copyAmount(0, this.fluidTank.getFluid()));
            }
            if (this.lockedFluid.getFluid() != null && !this.isLocked) {
                this.setLocked(true);
            }
            this.fillContainerFromInternalTank();
            this.fillInternalTankFromFluidContainer();
            if (this.isAutoOutputFluids()) {
                this.pushFluidsIntoNearbyHandlers(currentOutputFacing);
            }
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("FluidInventory", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        data.func_74757_a("AutoOutputFluids", this.autoOutputFluids);
        data.func_74768_a("OutputFacing", this.getOutputFacing().func_176745_a());
        data.func_74757_a("IsVoiding", this.isVoiding);
        data.func_74757_a("IsPartialVoiding", this.isPartialVoiding);
        data.func_74757_a("IsLocked", this.isLocked);
        data.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
        data.func_74757_a("AllowInputFromOutputSideF", this.allowInputFromOutputSide);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("ContainerInventory")) {
            MetaTileEntityQuantumTank.legacyTankItemHandlerNBTReading(this, data.func_74775_l("ContainerInventory"), 0, 1);
        }
        this.fluidTank.readFromNBT(data.func_74775_l("FluidInventory"));
        this.autoOutputFluids = data.func_74767_n("AutoOutputFluids");
        this.outputFacing = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.isVoiding = data.func_74767_n("IsVoiding");
        this.isPartialVoiding = data.func_74767_n("IsPartialVoiding");
        this.isLocked = data.func_74767_n("IsLocked");
        this.lockedFluid.readFromNBT(data.func_74775_l("LockedFluid"));
        this.allowInputFromOutputSide = data.func_74767_n("AllowInputFromOutputSideF");
    }

    public static void legacyTankItemHandlerNBTReading(MetaTileEntity mte, NBTTagCompound nbt, int inputSlot, int outputSlot) {
        if (mte == null || nbt == null) {
            return;
        }
        NBTTagList items = nbt.func_150295_c("Items", 10);
        if (mte.getExportItems().getSlots() < 1 || mte.getImportItems().getSlots() < 1 || inputSlot < 0 || outputSlot < 0 || inputSlot == outputSlot) {
            return;
        }
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTags = items.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot == inputSlot) {
                mte.getImportItems().setStackInSlot(0, new ItemStack(itemTags));
                continue;
            }
            if (slot != outputSlot) continue;
            mte.getExportItems().setStackInSlot(0, new ItemStack(itemTags));
        }
    }

    @Override
    public void initFromItemStackData(NBTTagCompound itemStack) {
        super.initFromItemStackData(itemStack);
        if (itemStack.func_150297_b("Fluid", 10)) {
            this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("Fluid")));
        }
        if (itemStack.func_74764_b("IsVoiding")) {
            this.setVoiding(true);
        } else if (itemStack.func_74764_b("IsPartialVoiding")) {
            this.setPartialVoid(true);
        }
        if (itemStack.func_74764_b("LockedFluid")) {
            this.setLocked(true);
            if (this.lockedFluid.getFluid() == null) {
                this.lockedFluid.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.func_74775_l("LockedFluid")));
            }
        }
    }

    @Override
    public void writeItemStackData(NBTTagCompound itemStack) {
        super.writeItemStackData(itemStack);
        FluidStack stack = this.fluidTank.getFluid();
        if (stack != null && stack.amount > 0) {
            itemStack.func_74782_a("Fluid", (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        if (this.isVoiding) {
            itemStack.func_74757_a("IsVoiding", this.isVoiding);
        } else if (this.isPartialVoiding) {
            itemStack.func_74757_a("IsPartialVoiding", this.isPartialVoiding);
        }
        if (this.isLocked && this.lockedFluid != null) {
            itemStack.func_74782_a("LockedFluid", (NBTBase)this.lockedFluid.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityQuantumTank(this.metaTileEntityId, this.tier, this.maxFluidCapacity);
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected FluidTankList createExportFluidHandler() {
        return new FluidTankList(false, new IFluidTank[]{this.fluidTank});
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new FilteredItemHandler(1).setFillPredicate(FilteredItemHandler.getCapabilityFilter(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY));
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        Textures.VOLTAGE_CASINGS[this.tier].render(renderState, translation, (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(this.getPaintingColorForRendering()))));
        Textures.QUANTUM_TANK_OVERLAY.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        if (this.outputFacing != null) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            if (this.isAutoOutputFluids()) {
                Textures.FLUID_OUTPUT_OVERLAY.renderSided(this.outputFacing, renderState, translation, pipeline);
            }
        }
    }

    @Override
    public Pair<TextureAtlasSprite, Integer> getParticleTexture() {
        return Pair.of((Object)Textures.VOLTAGE_CASINGS[this.tier].getParticleSprite(), (Object)this.getPaintingColorForRendering());
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        FluidStack fluidStack;
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.quantum_tank.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{this.maxFluidCapacity}));
        NBTTagCompound compound = stack.func_77978_p();
        if (compound != null && compound.func_150297_b("Fluid", 10) && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Fluid"))) != null) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.fluid_stored", (Object[])new Object[]{fluidStack.getLocalizedName(), fluidStack.amount}));
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        TankWidget tankWidget = new PhantomTankWidget((IFluidTank)this.fluidTank, 69, 43, 18, 18, this.lockedFluid).setAlwaysShowFull(true).setDrawHoveringText(false);
        return ModularUI.defaultBuilder().widget(new ImageWidget(7, 16, 81, 46, GuiTextures.DISPLAY)).widget(new LabelWidget(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF)).widget(tankWidget).dynamicLabel(11, 30, tankWidget::getFormattedFluidAmount, 0xFFFFFF).dynamicLabel(11, 40, tankWidget::getFluidLocalizedName, 0xFFFFFF).label(6, 6, this.getMetaFullName()).widget(new FluidContainerSlotWidget(this.importItems, 0, 90, 17, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY)).widget(new SlotWidget((IItemHandler)this.exportItems, 0, 90, 44, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.OUT_SLOT_OVERLAY)).widget(new ToggleButtonWidget(7, 64, 18, 18, GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setTooltipText("gregtech.gui.fluid_auto_output.tooltip", new Object[0]).shouldUseBaseBackground()).widget(new ToggleButtonWidget(25, 64, 18, 18, GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setTooltipText("gregtech.gui.fluid_lock.tooltip", new Object[0]).shouldUseBaseBackground()).widget(new ToggleButtonWidget(43, 64, 18, 18, GuiTextures.BUTTON_VOID_PARTIAL, this::isPartialVoid, this::setPartialVoid).setTooltipText("gregtech.gui.fluid_voiding_partial.tooltip", 95).shouldUseBaseBackground()).widget(new ToggleButtonWidget(61, 64, 18, 18, GuiTextures.BUTTON_VOID, this::isVoiding, this::setVoiding).setTooltipText("gregtech.gui.fluid_voiding_all.tooltip", new Object[0]).shouldUseBaseBackground()).bindPlayerInventory(entityPlayer.field_71071_by).build(this.getHolder(), entityPlayer);
    }

    public EnumFacing getOutputFacing() {
        return this.outputFacing == null ? this.frontFacing.func_176734_d() : this.outputFacing;
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(EnumFacing.UP);
        if (this.outputFacing == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    @Override
    public boolean isAutoOutputItems() {
        return false;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return false;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSide;
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 100) {
            this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == 102) {
            this.autoOutputFluids = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacing;
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacing().func_176745_a());
        buf.writeBoolean(this.autoOutputFluids);
        buf.writeBoolean(this.isLocked);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacing = EnumFacing.field_82609_l[buf.readByte()];
        this.autoOutputFluids = buf.readBoolean();
        this.isLocked = buf.readBoolean();
    }

    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacing = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(100, buf -> buf.writeByte(outputFacing.func_176745_a()));
            this.markDirty();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE) {
            if (side == this.getOutputFacing()) {
                return (T)GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE.cast((Object)this);
            }
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler fluidHandler;
            IFluidHandler iFluidHandler = fluidHandler = side == this.getOutputFacing() && !this.isAllowInputFromOutputSideFluids() ? this.outputFluidInventory : this.fluidInventory;
            if (fluidHandler.getTankProperties().length > 0) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)fluidHandler);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public ICapabilityProvider initItemStackCapabilities(ItemStack itemStack) {
        return new ThermalFluidHandlerItemStack(itemStack, this.maxFluidCapacity, Integer.MAX_VALUE, true, true, true, true);
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing || this.getFrontFacing() == facing) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        EnumFacing hitFacing = ICoverable.determineGridSideHit((RayTraceResult)hitResult);
        if (facing == this.getOutputFacing() || hitFacing == this.getOutputFacing() && playerIn.func_70093_af()) {
            if (!this.getWorld().field_72995_K) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSide(false);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.disallow", new Object[0]));
                } else {
                    this.setAllowInputFromOutputSide(true);
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.allow", new Object[0]));
                }
            }
            return true;
        }
        return super.onScrewdriverClick(playerIn, hand, facing, hitResult);
    }

    public void setAllowInputFromOutputSide(boolean allowInputFromOutputSide) {
        this.allowInputFromOutputSide = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    public void setAutoOutputFluids(boolean autoOutputFluids) {
        this.autoOutputFluids = autoOutputFluids;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(102, buf -> buf.writeBoolean(autoOutputFluids));
            this.markDirty();
        }
    }

    private boolean isLocked() {
        return this.isLocked;
    }

    private void setLocked(boolean locked) {
        this.isLocked = locked;
        if (locked && this.fluidTank.getFluid() != null) {
            this.lockedFluid.setFluid(GTUtility.copyAmount(1, this.fluidTank.getFluid()));
        }
        if (!locked && this.lockedFluid.getFluid() != null) {
            this.lockedFluid.setFluid(null);
        }
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    private boolean isVoiding() {
        return this.isVoiding;
    }

    private void setVoiding(boolean isVoiding) {
        this.isVoiding = isVoiding;
        if (isVoiding && this.isPartialVoiding) {
            this.isPartialVoiding = false;
        }
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    private boolean isPartialVoid() {
        return this.isPartialVoiding;
    }

    private void setPartialVoid(boolean isPartialVoid) {
        this.isPartialVoiding = isPartialVoid;
        if (isPartialVoid && this.isVoiding) {
            this.isVoiding = false;
        }
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }
}

