/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric.generator;

import gregtech.api.GTValues;
import gregtech.api.capability.IRotorHolder;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.FuelMultiblockController;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.metatileentities.multi.electric.generator.LargeTurbineWorkableHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MetaTileEntityLargeTurbine
extends FuelMultiblockController
implements ITieredMetaTileEntity {
    public final int tier;
    public final IBlockState casingState;
    public final IBlockState gearboxState;
    public final ICubeRenderer casingRenderer;
    public final boolean hasMufflerHatch;
    public final ICubeRenderer frontOverlay;
    private static final int MIN_DURABILITY_TO_WARN = 10;
    public IFluidHandler exportFluidHandler;

    public MetaTileEntityLargeTurbine(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, int tier, IBlockState casingState, IBlockState gearboxState, ICubeRenderer casingRenderer, boolean hasMufflerHatch, ICubeRenderer frontOverlay) {
        super(metaTileEntityId, recipeMap, tier);
        this.casingState = casingState;
        this.gearboxState = gearboxState;
        this.casingRenderer = casingRenderer;
        this.hasMufflerHatch = hasMufflerHatch;
        this.frontOverlay = frontOverlay;
        this.tier = tier;
        this.recipeMapWorkable = new LargeTurbineWorkableHandler((RecipeMapMultiblockController)this, tier);
        this.recipeMapWorkable.setMaximumOverclockVoltage(GTValues.V[tier]);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeTurbine(this.metaTileEntityId, this.recipeMap, this.tier, this.casingState, this.gearboxState, this.casingRenderer, this.hasMufflerHatch, this.frontOverlay);
    }

    public IRotorHolder getRotorHolder() {
        List<IRotorHolder> abilities = this.getAbilities(MultiblockAbility.ROTOR_HOLDER);
        if (abilities.isEmpty()) {
            return null;
        }
        return abilities.get(0);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.exportFluidHandler = null;
    }

    public boolean isRotorFaceFree() {
        IRotorHolder rotorHolder = this.getRotorHolder();
        if (rotorHolder != null) {
            return this.isStructureFormed() && this.getRotorHolder().isFrontFaceFree();
        }
        return false;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.exportFluidHandler = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        ((LargeTurbineWorkableHandler)this.recipeMapWorkable).updateTanks();
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        if (this.isStructureFormed()) {
            IRotorHolder rotorHolder = this.getRotorHolder();
            FluidStack fuelStack = ((LargeTurbineWorkableHandler)this.recipeMapWorkable).getInputFluidStack();
            int fuelAmount = fuelStack == null ? 0 : fuelStack.amount;
            TextComponentTranslation fuelName = new TextComponentTranslation(fuelAmount == 0 ? "gregtech.fluid.empty" : fuelStack.getUnlocalizedName(), new Object[0]);
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.fuel_amount", new Object[]{fuelAmount, fuelName}));
            if (rotorHolder.getRotorEfficiency() > 0) {
                long currentProduction;
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.rotor_speed", new Object[]{rotorHolder.getRotorSpeed(), rotorHolder.getMaxRotorHolderSpeed()}));
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.efficiency", new Object[]{rotorHolder.getTotalEfficiency()}));
                long maxProduction = ((LargeTurbineWorkableHandler)this.recipeMapWorkable).getMaxVoltage();
                long l = currentProduction = this.isActive() ? ((LargeTurbineWorkableHandler)this.recipeMapWorkable).boostProduction((int)maxProduction) : 0L;
                if (currentProduction >= maxProduction) {
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.energy_per_tick_maxed", new Object[]{maxProduction}));
                } else {
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.energy_per_tick", new Object[]{currentProduction, maxProduction}));
                }
                int rotorDurability = rotorHolder.getRotorDurabilityPercent();
                if (rotorDurability > 10) {
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.turbine.rotor_durability", new Object[]{rotorDurability}));
                } else {
                    textList.add(new TextComponentTranslation("gregtech.multiblock.turbine.rotor_durability", new Object[]{rotorDurability}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
            if (!this.isRotorFaceFree()) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.turbine.obstructed", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        super.addDisplayText(textList);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.base_production_eut", (Object[])new Object[]{GTValues.V[this.tier] * 2L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.multiblock.turbine.efficiency_tooltip", (Object[])new Object[]{GTValues.VNF[this.tier]}));
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("CCCC", "CHHC", "CCCC").aisle("CHHC", "RGGR", "CHHC").aisle("CCCC", "CSHC", "CCCC").where('S', this.selfPredicate()).where('G', MetaTileEntityLargeTurbine.states(this.getGearBoxState())).where('C', MetaTileEntityLargeTurbine.states(this.getCasingState())).where('R', MetaTileEntityLargeTurbine.metaTileEntities((MetaTileEntity[])MultiblockAbility.REGISTRY.get(MultiblockAbility.ROTOR_HOLDER).stream().filter(mte -> mte instanceof ITieredMetaTileEntity && ((ITieredMetaTileEntity)((Object)mte)).getTier() >= this.tier).toArray(MetaTileEntity[]::new)).addTooltips("gregtech.multiblock.pattern.clear_amount_3").addTooltip("gregtech.multiblock.pattern.error.limited.1", GTValues.VN[this.tier]).setExactLimit(1).or(MetaTileEntityLargeTurbine.abilities(MultiblockAbility.OUTPUT_ENERGY)).setExactLimit(1)).where('H', MetaTileEntityLargeTurbine.states(this.getCasingState()).or(this.autoAbilities(false, true, false, false, true, true, true))).build();
    }

    @Override
    public String[] getDescription() {
        return new String[]{I18n.func_135052_a((String)"gregtech.multiblock.large_turbine.description", (Object[])new Object[0])};
    }

    public IBlockState getCasingState() {
        return this.casingState;
    }

    public IBlockState getGearBoxState() {
        return this.gearboxState;
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return this.casingRenderer;
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return this.frontOverlay;
    }

    @Override
    public boolean hasMufflerMechanics() {
        return this.hasMufflerHatch;
    }

    @Override
    public boolean isStructureObstructed() {
        return super.isStructureObstructed() || !this.isRotorFaceFree();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public boolean canVoidRecipeItemOutputs() {
        return true;
    }

    @Override
    public boolean canVoidRecipeFluidOutputs() {
        return true;
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }
}

