/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.GTValues;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.IFastRenderMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.recipeproperties.FusionEUToStartProperty;
import gregtech.api.util.interpolate.Eases;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.utils.BloomEffectUtil;
import gregtech.client.utils.RenderBufferHelper;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFusionCasing;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaTileEntityFusionReactor
extends RecipeMapMultiblockController
implements IFastRenderMetaTileEntity {
    private final int tier;
    private EnergyContainerList inputEnergyContainers;
    private long heat = 0L;
    private Integer color;
    static BloomEffectUtil.IBloomRenderFast RENDER_HANDLER = new BloomEffectUtil.IBloomRenderFast(){
        float lastBrightnessX;
        float lastBrightnessY;

        @Override
        public int customBloomStyle() {
            return ConfigHolder.client.shader.fusionBloom.useShader ? ConfigHolder.client.shader.fusionBloom.bloomStyle : -1;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void preDraw(BufferBuilder buffer) {
            BloomEffect.strength = (float)ConfigHolder.client.shader.fusionBloom.strength;
            BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.fusionBloom.baseBrightness;
            BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.fusionBloom.highBrightnessThreshold;
            BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.fusionBloom.lowBrightnessThreshold;
            BloomEffect.step = 1.0f;
            this.lastBrightnessX = OpenGlHelper.lastBrightnessX;
            this.lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179090_x();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void postDraw(BufferBuilder buffer) {
            GlStateManager.func_179098_w();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)this.lastBrightnessX, (float)this.lastBrightnessY);
        }
    };

    public MetaTileEntityFusionReactor(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.FUSION_RECIPES);
        this.recipeMapWorkable = new FusionRecipeLogic(this);
        this.tier = tier;
        this.energyContainer = new EnergyContainerHandler(this, Integer.MAX_VALUE, 0L, 0L, 0L, 0L){

            @Override
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFusionReactor(this.metaTileEntityId, this.tier);
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("###############", "######OGO######", "###############").aisle("######ICI######", "####GGAAAGG####", "######ICI######").aisle("####CC###CC####", "###EAAOGOAAE###", "####CC###CC####").aisle("###C#######C###", "##EKEG###GEKE##", "###C#######C###").aisle("##C#########C##", "#GAE#######EAG#", "##C#########C##").aisle("##C#########C##", "#GAG#######GAG#", "##C#########C##").aisle("#I###########I#", "OAO#########OAO", "#I###########I#").aisle("#C###########C#", "GAG#########GAG", "#C###########C#").aisle("#I###########I#", "OAO#########OAO", "#I###########I#").aisle("##C#########C##", "#GAG#######GAG#", "##C#########C##").aisle("##C#########C##", "#GAE#######EAG#", "##C#########C##").aisle("###C#######C###", "##EKEG###GEKE##", "###C#######C###").aisle("####CC###CC####", "###EAAOGOAAE###", "####CC###CC####").aisle("######ICI######", "####GGAAAGG####", "######ICI######").aisle("###############", "######OSO######", "###############").where('S', this.selfPredicate()).where('G', MetaTileEntityFusionReactor.states(MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.FUSION_GLASS)).or(MetaTileEntityFusionReactor.states(this.getCasingState()))).where('E', MetaTileEntityFusionReactor.states(this.getCasingState()).or(MetaTileEntityFusionReactor.metaTileEntities((MetaTileEntity[])Arrays.stream(MetaTileEntities.ENERGY_INPUT_HATCH).filter(mte -> mte != null && this.tier <= mte.getTier() && mte.getTier() <= 8).toArray(MetaTileEntity[]::new)).setMinGlobalLimited(1).setPreviewCount(16))).where('C', MetaTileEntityFusionReactor.states(this.getCasingState())).where('K', MetaTileEntityFusionReactor.states(this.getCoilState())).where('O', MetaTileEntityFusionReactor.states(this.getCasingState()).or(MetaTileEntityFusionReactor.abilities(MultiblockAbility.EXPORT_FLUIDS))).where('A', MetaTileEntityFusionReactor.air()).where('I', MetaTileEntityFusionReactor.states(this.getCasingState()).or(MetaTileEntityFusionReactor.abilities(MultiblockAbility.IMPORT_FLUIDS).setMinGlobalLimited(this.recipeMap.getMinFluidInputs()))).where('#', MetaTileEntityFusionReactor.any()).build();
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder baseBuilder = MultiblockShapeInfo.builder().aisle("###############", "######WGW######", "###############").aisle("######DCD######", "####GG###GG####", "######UCU######").aisle("####CC###CC####", "###w##EGE##s###", "####CC###CC####").aisle("###C#######C###", "##nKeG###GeKn##", "###C#######C###").aisle("##C#########C##", "#G#s#######w#G#", "##C#########C##").aisle("##C#########C##", "#G#G#######G#G#", "##C#########C##").aisle("#D###########D#", "N#S#########N#S", "#U###########U#").aisle("#C###########C#", "G#G#########G#G", "#C###########C#").aisle("#D###########D#", "N#S#########N#S", "#U###########U#").aisle("##C#########C##", "#G#G#######G#G#", "##C#########C##").aisle("##C#########C##", "#G#s#######w#G#", "##C#########C##").aisle("###C#######C###", "##eKnG###GnKe##", "###C#######C###").aisle("####CC###CC####", "###w##WGW##s###", "####CC###CC####").aisle("######DCD######", "####GG###GG####", "######UCU######").aisle("###############", "######EME######", "###############").where('M', MetaTileEntities.FUSION_REACTOR[this.tier - 6], EnumFacing.SOUTH).where('C', this.getCasingState()).where('G', MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.FUSION_GLASS)).where('K', this.getCoilState()).where('W', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.NORTH).where('E', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.SOUTH).where('S', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.EAST).where('N', MetaTileEntities.FLUID_EXPORT_HATCH[this.tier], EnumFacing.WEST).where('w', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.WEST).where('e', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.SOUTH).where('s', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.EAST).where('n', MetaTileEntities.ENERGY_INPUT_HATCH[this.tier], EnumFacing.NORTH).where('U', MetaTileEntities.FLUID_IMPORT_HATCH[this.tier], EnumFacing.UP).where('D', MetaTileEntities.FLUID_IMPORT_HATCH[this.tier], EnumFacing.DOWN).where('#', Blocks.field_150350_a.func_176223_P());
        shapeInfos.add(baseBuilder.shallowCopy().where('G', this.getCasingState()).build());
        shapeInfos.add(baseBuilder.build());
        return shapeInfos;
    }

    @Override
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.recipeMapWorkable.isActive()) {
            return Textures.ACTIVE_FUSION_TEXTURE;
        }
        return Textures.FUSION_TEXTURE;
    }

    private IBlockState getCasingState() {
        if (this.tier == 6) {
            return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_CASING);
        }
        if (this.tier == 7) {
            return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_CASING_MK2);
        }
        return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_CASING_MK3);
    }

    private IBlockState getCoilState() {
        if (this.tier == 6) {
            return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.SUPERCONDUCTOR_COIL);
        }
        return MetaBlocks.FUSION_CASING.getState(BlockFusionCasing.CasingType.FUSION_COIL);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        long energyStored = this.energyContainer.getEnergyStored();
        super.formStructure(context);
        this.initializeAbilities();
        ((EnergyContainerHandler)this.energyContainer).setEnergyStored(energyStored);
    }

    @Override
    protected void initializeAbilities() {
        this.inputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        List<IEnergyContainer> energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.inputEnergyContainers = new EnergyContainerList(energyInputs);
        long euCapacity = this.calculateEnergyStorageFactor(energyInputs.size());
        this.energyContainer = new EnergyContainerHandler(this, euCapacity, GTValues.V[this.tier], 0L, 0L, 0L){

            @Override
            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    private long calculateEnergyStorageFactor(int energyInputAmount) {
        return (long)energyInputAmount * (long)Math.pow(2.0, this.tier - 6) * 10000000L;
    }

    @Override
    protected void updateFormedValid() {
        long energyAdded;
        if (this.inputEnergyContainers.getEnergyStored() > 0L && (energyAdded = this.energyContainer.addEnergy(this.inputEnergyContainers.getEnergyStored())) > 0L) {
            this.inputEnergyContainers.removeEnergy(energyAdded);
        }
        super.updateFormedValid();
        if (this.recipeMapWorkable.isWorking() && this.color == null) {
            int newColor;
            if (this.recipeMapWorkable.getPreviousRecipe() != null && this.recipeMapWorkable.getPreviousRecipe().getFluidOutputs().size() > 0 && !Objects.equals(this.color, newColor = 0xFF000000 | this.recipeMapWorkable.getPreviousRecipe().getFluidOutputs().get(0).getFluid().getColor())) {
                this.color = newColor;
                this.writeCustomData(371, this::writeColor);
            }
        } else if (!this.recipeMapWorkable.isWorking() && this.isStructureFormed() && this.color != null) {
            this.color = null;
            this.writeCustomData(371, this::writeColor);
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.writeColor(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.readColor(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 371) {
            this.readColor(buf);
        }
    }

    private void readColor(PacketBuffer buf) {
        this.color = buf.readBoolean() ? Integer.valueOf(buf.func_150792_a()) : null;
    }

    private void writeColor(PacketBuffer buf) {
        buf.writeBoolean(this.color != null);
        if (this.color != null) {
            buf.func_150787_b(this.color.intValue());
        }
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        super.addDisplayText(textList);
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.fusion_reactor.energy", new Object[]{this.energyContainer.getEnergyStored(), this.energyContainer.getEnergyCapacity()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.fusion_reactor.heat", new Object[]{this.heat}));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fusion_reactor.capacity", (Object[])new Object[]{this.calculateEnergyStorageFactor(16) / 1000000L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fusion_reactor.overclocking", (Object[])new Object[0]));
    }

    @Override
    @Nonnull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FUSION_REACTOR_OVERLAY;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    public long getHeat() {
        return this.heat;
    }

    @Override
    public void renderMetaTileEntity(double x, double y, double z, float partialTicks) {
        if (this.color != null && MinecraftForgeClient.getRenderPass() == 0) {
            int c = this.color;
            BloomEffectUtil.requestCustomBloom(RENDER_HANDLER, buffer -> {
                int color = RenderUtil.colorInterpolator(c, -1).apply(Float.valueOf(Eases.EaseQuadIn.getInterpolation(Math.abs((float)Math.abs(this.getOffsetTimer() % 50L) + partialTicks - 25.0f) / 25.0f)));
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                Entity entity = Minecraft.func_71410_x().func_175606_aa();
                if (entity != null) {
                    buffer.func_181668_a(8, DefaultVertexFormats.field_181706_f);
                    RenderBufferHelper.renderRing(buffer, x + (double)(this.getFrontFacing().func_176734_d().func_82601_c() * 7) + 0.5, y + 0.5, z + (double)(this.getFrontFacing().func_176734_d().func_82599_e() * 7) + 0.5, 6.0, 0.2, 10, 20, r, g, b, a, EnumFacing.Axis.Y);
                    Tessellator.func_178181_a().func_78381_a();
                }
            });
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.getPos().func_177972_a(this.getFrontFacing().func_176734_d()).func_177967_a(this.getFrontFacing().func_176746_e(), 6), this.getPos().func_177967_a(this.getFrontFacing().func_176734_d(), 13).func_177967_a(this.getFrontFacing().func_176746_e().func_176734_d(), 6));
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    @Override
    public boolean isGlobalRenderer() {
        return true;
    }

    private class FusionRecipeLogic
    extends MultiblockRecipeLogic {
        public FusionRecipeLogic(MetaTileEntityFusionReactor tileEntity) {
            super(tileEntity);
        }

        @Override
        protected double getOverclockingDurationDivisor() {
            return 2.0;
        }

        @Override
        protected double getOverclockingVoltageMultiplier() {
            return 2.0;
        }

        @Override
        protected long getMaxVoltage() {
            return Math.min(GTValues.V[MetaTileEntityFusionReactor.this.tier], super.getMaxVoltage());
        }

        @Override
        public void updateWorkable() {
            super.updateWorkable();
            if (!this.isActive && MetaTileEntityFusionReactor.this.heat > 0L) {
                MetaTileEntityFusionReactor.this.heat = MetaTileEntityFusionReactor.this.heat <= 10000L ? 0L : MetaTileEntityFusionReactor.this.heat - 10000L;
            }
        }

        @Override
        protected boolean checkRecipe(@Nonnull Recipe recipe) {
            if (!super.checkRecipe(recipe)) {
                return false;
            }
            if (recipe.getProperty(FusionEUToStartProperty.getInstance(), 0L) > MetaTileEntityFusionReactor.this.energyContainer.getEnergyCapacity()) {
                return false;
            }
            long heatDiff = recipe.getProperty(FusionEUToStartProperty.getInstance(), 0L) - MetaTileEntityFusionReactor.this.heat;
            if (heatDiff <= 0L) {
                return true;
            }
            if (MetaTileEntityFusionReactor.this.energyContainer.getEnergyStored() < heatDiff) {
                return false;
            }
            MetaTileEntityFusionReactor.this.energyContainer.removeEnergy(heatDiff);
            MetaTileEntityFusionReactor.this.heat = MetaTileEntityFusionReactor.this.heat + heatDiff;
            return true;
        }

        @Override
        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74772_a("Heat", MetaTileEntityFusionReactor.this.heat);
            return tag;
        }

        @Override
        public void deserializeNBT(@Nonnull NBTTagCompound compound) {
            super.deserializeNBT(compound);
            MetaTileEntityFusionReactor.this.heat = compound.func_74763_f("Heat");
        }
    }
}

