/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTUtility;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.common.ConfigHolder;
import gregtech.common.pipelike.fluidpipe.tile.TileEntityFluidPipe;
import gregtech.core.sound.GTSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TricorderBehavior
implements IItemBehaviour {
    private final int debugLevel;
    private int energyCost = Integer.MAX_VALUE;

    public TricorderBehavior(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    @Override
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K && !world.func_175623_d(pos)) {
            List<ITextComponent> info = this.getScannerInfo(player, world, pos);
            if (player.func_184812_l_() || this.drainEnergy(player.func_184586_b(hand), this.energyCost, true)) {
                this.drainEnergy(player.func_184586_b(hand), this.energyCost, false);
                for (ITextComponent line : info) {
                    player.func_145747_a(line);
                }
                if (ConfigHolder.client.toolUseSounds) {
                    world.func_184133_a(null, pos, GTSoundEvents.TRICORDER_TOOL, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("behavior.prospector.not_enough_energy", new Object[0]));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public List<ITextComponent> getScannerInfo(EntityPlayer player, World world, BlockPos pos) {
        int energyCost = 100;
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        TileEntity tileEntity = world.func_175625_s(pos);
        IBlockState state = world.func_180495_p(pos);
        state = state.func_177230_c().func_176221_a(state, (IBlockAccess)world, pos);
        Block block = state.func_177230_c();
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.position", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(pos.func_177958_n()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)), new TextComponentTranslation(GTUtility.formatNumbers(pos.func_177956_o()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)), new TextComponentTranslation(GTUtility.formatNumbers(pos.func_177952_p()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)), new TextComponentTranslation(GTUtility.formatNumbers(world.field_73011_w.getDimension()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA))}));
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.block_hardness", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(block.func_176195_g(state, world, pos)), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(GTUtility.formatNumbers(block.func_149638_a((Entity)player)), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
        if (this.debugLevel > 2) {
            for (Map.Entry prop : state.func_177228_b().entrySet()) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.state", new Object[]{new TextComponentTranslation(((IProperty)prop.getKey()).func_177701_a(), new Object[0]), new TextComponentTranslation(((Comparable)prop.getValue()).toString(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA))}));
            }
            if (state instanceof IExtendedBlockState) {
                IExtendedBlockState extState = (IExtendedBlockState)state;
                for (Map.Entry prop : extState.getUnlistedProperties().entrySet()) {
                    if (!((Optional)prop.getValue()).isPresent()) continue;
                    list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.state", new Object[]{new TextComponentTranslation(((IUnlistedProperty)prop.getKey()).getName(), new Object[0]), new TextComponentTranslation(((Optional)prop.getValue()).get().toString(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA))}));
                }
            }
        }
        if (tileEntity instanceof IGregTechTileEntity) {
            IEnergyContainer container;
            IWorkable workable;
            IFluidTank tank;
            int i;
            MetaTileEntity metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
            if (metaTileEntity == null) {
                return list;
            }
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.block_name", new Object[]{new TextComponentTranslation(LocalizationUtils.format(metaTileEntity.getMetaFullName(), new Object[0]), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), new TextComponentTranslation(GTUtility.formatNumbers(GregTechAPI.MTE_REGISTRY.getIdByObjectName(metaTileEntity.metaTileEntityId)), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE))}));
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.divider", new Object[0]));
            FluidTankList tanks = metaTileEntity.getImportFluids();
            int tankIndex = 0;
            boolean allTanksEmpty = true;
            if (tanks != null && !tanks.getFluidTanks().isEmpty()) {
                energyCost += 500;
                for (i = 0; i < tanks.getFluidTanks().size(); ++i) {
                    tank = tanks.getTankAt(i);
                    if (tank.getFluid() == null) continue;
                    allTanksEmpty = false;
                    list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.tank", new Object[]{i, new TextComponentTranslation(GTUtility.formatNumbers(tank.getFluid().amount), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(tank.getCapacity()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(tank.getFluid().getLocalizedName(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD))}));
                }
                tankIndex += tanks.getFluidTanks().size();
            }
            if ((tanks = metaTileEntity.getExportFluids()) != null && !tanks.getFluidTanks().isEmpty()) {
                energyCost += 500;
                for (i = 0; i < tanks.getFluidTanks().size(); ++i) {
                    tank = tanks.getTankAt(i);
                    if (tank.getFluid() == null) continue;
                    allTanksEmpty = false;
                    list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.tank", new Object[]{tankIndex + i, new TextComponentTranslation(GTUtility.formatNumbers(tank.getFluid().amount), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(tank.getCapacity()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), new TextComponentTranslation(tank.getFluid().getLocalizedName(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD))}));
                }
            }
            if (allTanksEmpty && (metaTileEntity.getImportFluids() != null || metaTileEntity.getExportFluids() != null)) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.tanks_empty", new Object[0]));
            }
            energyCost += 500;
            if (metaTileEntity.isMuffled()) {
                list.add(new TextComponentTranslation("behavior.tricorder.muffled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
            if ((workable = metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_WORKABLE, null)) != null) {
                if (!workable.isWorkingEnabled()) {
                    list.add(new TextComponentTranslation("behavior.tricorder.machine_disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
                energyCost += 400;
                if (workable.getMaxProgress() > 0) {
                    list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.machine_progress", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(workable.getProgress()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(workable.getMaxProgress()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
                }
            }
            if ((container = metaTileEntity.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null)) != null && container.getEnergyCapacity() > 0L) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.divider", new Object[0]));
                if (container.getInputVoltage() > 0L) {
                    list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.energy_container_in", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(container.getInputVoltage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(GTValues.VN[GTUtility.getTierByVoltage(container.getInputVoltage())], new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(GTUtility.formatNumbers(container.getInputAmperage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
                }
                if (container.getOutputVoltage() > 0L) {
                    list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.energy_container_out", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(container.getOutputVoltage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(GTValues.VN[GTUtility.getTierByVoltage(container.getOutputVoltage())], new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), new TextComponentTranslation(GTUtility.formatNumbers(container.getOutputAmperage()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED))}));
                }
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.energy_container_storage", new Object[]{new TextComponentTranslation(GTUtility.formatNumbers(container.getEnergyStored()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)), new TextComponentTranslation(GTUtility.formatNumbers(container.getEnergyCapacity()), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
            }
            IDataInfoProvider provider = null;
            if (tileEntity instanceof IDataInfoProvider) {
                provider = (IDataInfoProvider)tileEntity;
            } else if (metaTileEntity instanceof IDataInfoProvider) {
                provider = (IDataInfoProvider)((Object)metaTileEntity);
            }
            if (provider != null) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.divider", new Object[0]));
                list.addAll(provider.getDataInfo());
            }
        } else if (tileEntity instanceof IPipeTile) {
            IPipeTile pipeTile = (IPipeTile)tileEntity;
            if (pipeTile.getPipeBlock().getRegistryName() != null) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.block_name", new Object[]{new TextComponentTranslation(LocalizationUtils.format(pipeTile.getPipeBlock().func_149739_a(), new Object[0]), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), new TextComponentTranslation(GTUtility.formatNumbers(block.func_176201_c(world.func_180495_p(pos))), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE))}));
            }
            if (tileEntity instanceof IDataInfoProvider) {
                IDataInfoProvider provider = (IDataInfoProvider)tileEntity;
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.divider", new Object[0]));
                list.addAll(provider.getDataInfo());
            }
            if (tileEntity instanceof TileEntityFluidPipe) {
                energyCost += 500;
            }
        } else if (tileEntity instanceof IDataInfoProvider) {
            IDataInfoProvider provider = (IDataInfoProvider)tileEntity;
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.divider", new Object[0]));
            list.addAll(provider.getDataInfo());
        } else {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.block_name", new Object[]{new TextComponentTranslation(LocalizationUtils.format(block.func_149732_F(), new Object[0]), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE)), new TextComponentTranslation(GTUtility.formatNumbers(block.func_176201_c(world.func_180495_p(pos))), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE))}));
        }
        list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.divider", new Object[0]));
        Fluid fluid = BedrockFluidVeinHandler.getFluidInChunk(world, pos.func_177958_n() / 16, pos.func_177952_p() / 16);
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, BedrockFluidVeinHandler.getOperationsRemaining(world, pos.func_177958_n() / 16, pos.func_177952_p() / 16));
            double fluidPercent = (double)stack.amount * 100.0 / 100000.0;
            if (player.func_184812_l_()) {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.bedrock_fluid.amount", new Object[]{new TextComponentTranslation(fluid.getLocalizedName(stack), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)), new TextComponentTranslation("" + BedrockFluidVeinHandler.getFluidYield(world, pos.func_177958_n() / 16, pos.func_177952_p() / 16), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)), new TextComponentTranslation("" + fluidPercent, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
            } else {
                list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.bedrock_fluid.amount_unknown", new Object[]{new TextComponentTranslation("" + fluidPercent, new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW))}));
            }
        } else {
            list.add((ITextComponent)new TextComponentTranslation("behavior.tricorder.bedrock_fluid.nothing", new Object[0]));
        }
        if (tileEntity instanceof MetaTileEntityHolder) {
            list.addAll(((MetaTileEntityHolder)tileEntity).getDebugInfo(player, this.debugLevel));
        }
        this.energyCost = energyCost;
        return list;
    }

    private boolean drainEnergy(@Nonnull ItemStack stack, long amount, boolean simulate) {
        if (this.debugLevel > 2) {
            return true;
        }
        IElectricItem electricItem = (IElectricItem)stack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (electricItem == null) {
            return false;
        }
        return electricItem.discharge(amount, Integer.MAX_VALUE, true, false, simulate) >= amount;
    }
}

