/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import codechicken.lib.raytracer.RayTracer;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.common.metatileentities.MetaTileEntityClipboard;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ClipboardBehavior
implements IItemBehaviour,
ItemUIFactory {
    public static final int MAX_PAGES = 25;
    private static final int TEXT_COLOR = 0x1E1E1E;

    @Override
    public ModularUI createUI(PlayerInventoryHolder holder, EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.CLIPBOARD_BACKGROUND, 186, 263);
        ClipboardBehavior.initNBT(holder.getCurrentItem());
        ArrayList<TextFieldWidget2> textFields = new ArrayList<TextFieldWidget2>();
        builder.image(28, 28, 130, 12, GuiTextures.CLIPBOARD_TEXT_BOX);
        textFields.add(new TextFieldWidget2(30, 30, 126, 9, () -> ClipboardBehavior.getTitle(holder), val -> ClipboardBehavior.setTitle(holder, val)).setMaxLength(25).setCentered(true).setTextColor(0x1E1E1E));
        for (int i = 0; i < 8; ++i) {
            int finalI = i;
            builder.widget(new ImageCycleButtonWidget(14, 55 + 22 * i, 15, 15, GuiTextures.CLIPBOARD_BUTTON, 4, () -> ClipboardBehavior.getButtonState(holder, finalI), x -> ClipboardBehavior.setButton(holder, finalI, x)));
            builder.image(32, 58 + 22 * i, 140, 12, GuiTextures.CLIPBOARD_TEXT_BOX);
            textFields.add(new TextFieldWidget2(34, 60 + 22 * i, 136, 9, () -> ClipboardBehavior.getString(holder, finalI), val -> ClipboardBehavior.setString(holder, finalI, val)).setMaxLength(23).setTextColor(0x1E1E1E));
        }
        for (TextFieldWidget2 textField : textFields) {
            builder.widget(textField.setOnFocus(textField2 -> textFields.forEach(textField3 -> {
                if (textField3 != textField2) {
                    textField3.unFocus();
                }
            })));
        }
        builder.widget(new ClickButtonWidget(38, 231, 16, 16, "", x -> ClipboardBehavior.incrPageNum(holder, x.isShiftClick ? -10 : -1)).setButtonTexture(GuiTextures.BUTTON_LEFT).setShouldClientCallback(true));
        builder.widget(new ClickButtonWidget(132, 231, 16, 16, "", x -> ClipboardBehavior.incrPageNum(holder, x.isShiftClick ? 10 : 1)).setButtonTexture(GuiTextures.BUTTON_RIGHT).setShouldClientCallback(true));
        builder.widget(new SimpleTextWidget(93, 240, "", 0x1E1E1E, () -> ClipboardBehavior.getPageNum(holder) + 1 + " / " + 25, true));
        builder.shouldColor(false);
        return builder.build(holder, entityPlayer);
    }

    public ModularUI createMTEUI(PlayerInventoryHolder holder, EntityPlayer entityPlayer) {
        ClipboardBehavior.initNBT(holder.getCurrentItem());
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.CLIPBOARD_PAPER_BACKGROUND, 170, 238);
        builder.image(18, 8, 130, 14, GuiTextures.CLIPBOARD_TEXT_BOX);
        builder.widget(new SimpleTextWidget(20, 10, "", 0x1E1E1E, () -> ClipboardBehavior.getTitle(holder), true).setCenter(false));
        for (int i = 0; i < 8; ++i) {
            int finalI = i;
            builder.widget(new ImageCycleButtonWidget(6, 37 + 20 * i, 15, 15, GuiTextures.CLIPBOARD_BUTTON, 4, () -> ClipboardBehavior.getButtonState(holder, finalI), x -> ClipboardBehavior.setButton(holder, finalI, x)));
            builder.image(22, 38 + 20 * i, 140, 12, GuiTextures.CLIPBOARD_TEXT_BOX);
            builder.widget(new SimpleTextWidget(24, 40 + 20 * i, "", 0x1E1E1E, () -> ClipboardBehavior.getString(holder, finalI), true).setCenter(false));
        }
        builder.widget(new ClickButtonWidget(30, 200, 16, 16, "", x -> ClipboardBehavior.incrPageNum(holder, x.isShiftClick ? -10 : -1)).setButtonTexture(GuiTextures.BUTTON_LEFT).setShouldClientCallback(true));
        builder.widget(new ClickButtonWidget(124, 200, 16, 16, "", x -> ClipboardBehavior.incrPageNum(holder, x.isShiftClick ? 10 : 1)).setButtonTexture(GuiTextures.BUTTON_RIGHT).setShouldClientCallback(true));
        builder.widget(new SimpleTextWidget(85, 208, "", 0x1E1E1E, () -> ClipboardBehavior.getPageNum(holder) + 1 + " / " + 25, true));
        builder.shouldColor(false);
        return builder.build(holder, entityPlayer);
    }

    private static NBTTagCompound getPageCompound(ItemStack stack) {
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return null;
        }
        short pageNum = stack.func_77978_p().func_74765_d("PageIndex");
        return stack.func_77978_p().func_74775_l("Page" + pageNum);
    }

    private static void setPageCompound(ItemStack stack, NBTTagCompound pageCompound) {
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return;
        }
        short pageNum = stack.func_77978_p().func_74765_d("PageIndex");
        stack.func_77978_p().func_74782_a("Page" + pageNum, (NBTBase)pageCompound);
    }

    private static void initNBT(ItemStack stack) {
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            int i;
            tagCompound = new NBTTagCompound();
            tagCompound.func_74777_a("PageIndex", (short)0);
            tagCompound.func_74777_a("TotalPages", (short)0);
            NBTTagCompound pageCompound = new NBTTagCompound();
            pageCompound.func_74777_a("ButStat", (short)0);
            pageCompound.func_74778_a("Title", "");
            for (i = 0; i < 8; ++i) {
                pageCompound.func_74778_a("Task" + i, "");
            }
            for (i = 0; i < 25; ++i) {
                tagCompound.func_74782_a("Page" + i, (NBTBase)pageCompound.func_74737_b());
            }
            stack.func_77982_d(tagCompound);
        }
    }

    private static void setButton(PlayerInventoryHolder holder, int pos, int newState) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tagCompound = ClipboardBehavior.getPageCompound(stack);
        short buttonState = tagCompound.func_74765_d("ButStat");
        short clearedState = (short)(buttonState & ~(3 << pos * 2));
        buttonState = (short)(clearedState | newState << pos * 2);
        tagCompound.func_74777_a("ButStat", buttonState);
        ClipboardBehavior.setPageCompound(stack, tagCompound);
    }

    private static int getButtonState(PlayerInventoryHolder holder, int pos) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return 0;
        }
        NBTTagCompound tagCompound = ClipboardBehavior.getPageCompound(stack);
        short buttonState = tagCompound.func_74765_d("ButStat");
        return buttonState >> pos * 2 & 3;
    }

    private static void setString(PlayerInventoryHolder holder, int pos, String newString) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tagCompound = ClipboardBehavior.getPageCompound(stack);
        tagCompound.func_74778_a("Task" + pos, newString);
        ClipboardBehavior.setPageCompound(stack, tagCompound);
    }

    private static String getString(PlayerInventoryHolder holder, int pos) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return "";
        }
        NBTTagCompound tagCompound = ClipboardBehavior.getPageCompound(stack);
        return tagCompound.func_74779_i("Task" + pos);
    }

    private static void setTitle(PlayerInventoryHolder holder, String newString) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tagCompound = ClipboardBehavior.getPageCompound(stack);
        assert (tagCompound != null);
        tagCompound.func_74778_a("Title", newString);
        ClipboardBehavior.setPageCompound(stack, tagCompound);
    }

    private static String getTitle(PlayerInventoryHolder holder) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return "";
        }
        NBTTagCompound tagCompound = ClipboardBehavior.getPageCompound(stack);
        return tagCompound.func_74779_i("Title");
    }

    private static int getPageNum(PlayerInventoryHolder holder) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return 1;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        return tagCompound.func_74762_e("PageIndex");
    }

    private static void incrPageNum(PlayerInventoryHolder holder, int increment) {
        ItemStack stack = holder.getCurrentItem();
        if (!MetaItems.CLIPBOARD.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        assert (tagCompound != null);
        int currentIndex = tagCompound.func_74762_e("PageIndex");
        tagCompound.func_74768_a("PageIndex", Math.max(Math.min(currentIndex + increment, 24), 0));
        stack.func_77982_d(tagCompound);
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K && RayTracer.retrace((EntityPlayer)player).field_72313_a != RayTraceResult.Type.BLOCK) {
            PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
            holder.openUI();
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    @Override
    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && facing.func_176740_k() != EnumFacing.Axis.Y) {
            BlockPos shiftedPos;
            Block shiftedBlock;
            ItemStack heldItem = player.func_184586_b(hand).func_77946_l();
            heldItem.func_190920_e(1);
            IBlockState testState = world.func_180495_p(pos);
            Block testBlock = testState.func_177230_c();
            if (!testBlock.isAir(world.func_180495_p(pos), (IBlockAccess)world, pos) && testState.isSideSolid((IBlockAccess)world, pos, facing) && (shiftedBlock = world.func_180495_p(shiftedPos = pos.func_177972_a(facing)).func_177230_c()).isAir(world.func_180495_p(shiftedPos), (IBlockAccess)world, shiftedPos)) {
                MetaTileEntityClipboard clipboard;
                IBlockState state = MetaBlocks.MACHINE.func_176223_P();
                world.func_175656_a(shiftedPos, state);
                shiftedBlock.createTileEntity(world, state);
                IGregTechTileEntity holder = (IGregTechTileEntity)world.func_175625_s(shiftedPos);
                if (holder != null && (clipboard = (MetaTileEntityClipboard)holder.setMetaTileEntity(MetaTileEntities.CLIPBOARD_TILE)) != null) {
                    clipboard.initializeClipboard(heldItem);
                    clipboard.setFrontFacing(facing.func_176734_d());
                    ItemStack returnedStack = player.func_184586_b(hand);
                    if (!player.func_184812_l_()) {
                        returnedStack.func_190920_e(player.func_184586_b(hand).func_190916_E() - 1);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)returnedStack);
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }
}

