/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.armor;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.armor.ArmorLogicSuite;
import gregtech.api.util.GTUtility;
import gregtech.api.util.input.KeyBind;
import gregtech.common.items.MetaItems;
import gregtech.common.items.armor.IStepAssist;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NanoMuscleSuite
extends ArmorLogicSuite
implements IStepAssist {
    public NanoMuscleSuite(EntityEquipmentSlot slot, int energyPerUse, long maxCapacity, int tier) {
        super(energyPerUse, maxCapacity, tier, slot);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, @Nonnull ItemStack itemStack) {
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item == null) {
            return;
        }
        NBTTagCompound nbtData = GTUtility.getOrCreateNbtCompound(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (this.SLOT == EntityEquipmentSlot.HEAD) {
            boolean nightvision = nbtData.func_74767_n("Nightvision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                toggleTimer = 5;
                if (!nightvision && item.getCharge() >= 4L) {
                    nightvision = true;
                    if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.nms.nightvision.enabled", new Object[0]), true);
                    }
                } else if (nightvision) {
                    nightvision = false;
                    this.disableNightVision(world, player, true);
                } else if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.nms.nightvision.error", new Object[0]), true);
                }
                if (!world.field_72995_K) {
                    nbtData.func_74757_a("Nightvision", nightvision);
                }
            }
            if (nightvision && !world.field_72995_K && item.getCharge() >= 4L) {
                player.func_184589_d(MobEffects.field_76440_q);
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 999999, 0, true, false));
                item.discharge(4L, this.tier, true, false, false);
            }
            if (!world.field_72995_K && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.func_74774_a("toggleTimer", toggleTimer);
            }
        } else if (this.SLOT == EntityEquipmentSlot.FEET) {
            this.updateStepHeight(player);
        }
        player.field_71069_bz.func_75142_b();
    }

    public void disableNightVision(@Nonnull World world, EntityPlayer player, boolean sendMsg) {
        if (!world.field_72995_K) {
            player.func_184589_d(MobEffects.field_76439_r);
            if (sendMsg) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("metaarmor.nms.nightvision.disabled", new Object[0]), true);
            }
        }
    }

    @Override
    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        return source == DamageSource.field_76379_h;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, EntityEquipmentSlot equipmentSlot) {
        IElectricItem container = (IElectricItem)armor.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        int damageLimit = Integer.MAX_VALUE;
        if (source == DamageSource.field_76379_h && this.getEquipmentSlot(armor) == EntityEquipmentSlot.FEET) {
            if (this.energyPerUse > 0 && container != null) {
                damageLimit = (int)Math.min((double)damageLimit, 25.0 * (double)container.getCharge() / ((double)this.energyPerUse * 10.0));
            }
            return new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, damageLimit);
        }
        return super.getProperties(player, armor, source, damage, equipmentSlot);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        return this.SLOT;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack itemStack, DamageSource source, int damage, EntityEquipmentSlot equipmentSlot) {
        IElectricItem item = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        if (item != null) {
            item.discharge((long)this.energyPerUse / 10L * (long)damage, item.getTier(), true, false, false);
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        ItemStack currentChest = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70440_f(EntityEquipmentSlot.CHEST.func_188454_b());
        ItemStack advancedChest = MetaItems.NANO_CHESTPLATE_ADVANCED.getStackForm();
        String armorTexture = "nano_muscule_suite";
        if (advancedChest.func_77969_a(currentChest)) {
            armorTexture = "advanced_nano_muscle_suite";
        }
        return this.SLOT != EntityEquipmentSlot.LEGS ? String.format("gregtech:textures/armor/%s_1.png", armorTexture) : String.format("gregtech:textures/armor/%s_2.png", armorTexture);
    }

    @Override
    public double getDamageAbsorption() {
        return 1.0;
    }

    @Override
    public float getHeatResistance() {
        return 0.75f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isNeedDrawHUD() {
        return true;
    }

    @Override
    public void drawHUD(ItemStack item) {
        super.addCapacityHUD(item);
        this.HUD.draw();
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<String> lines) {
        super.addInfo(itemStack, lines);
        if (this.SLOT == EntityEquipmentSlot.HEAD) {
            NBTTagCompound nbtData = GTUtility.getOrCreateNbtCompound(itemStack);
            boolean nv = nbtData.func_74767_n("Nightvision");
            if (nv) {
                lines.add(I18n.func_135052_a((String)"metaarmor.message.nightvision.enabled", (Object[])new Object[0]));
            } else {
                lines.add(I18n.func_135052_a((String)"metaarmor.message.nightvision.disabled", (Object[])new Object[0]));
            }
        } else if (this.SLOT == EntityEquipmentSlot.FEET) {
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.stepassist", (Object[])new Object[0]));
            lines.add(I18n.func_135052_a((String)"metaarmor.tooltip.falldamage", (Object[])new Object[0]));
        }
    }
}

