/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CoverSolarPanel
extends CoverBehavior
implements ITickable {
    private final long EUt;

    public CoverSolarPanel(ICoverable coverHolder, EnumFacing attachedSide, long EUt) {
        super(coverHolder, attachedSide);
        this.EUt = EUt;
    }

    @Override
    public boolean canAttach() {
        return this.attachedSide == EnumFacing.UP && this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null) != null;
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox, BlockRenderLayer layer) {
        Textures.SOLAR_PANEL.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    public void func_73660_a() {
        IEnergyContainer energyContainer;
        BlockPos blockPos;
        World world = this.coverHolder.getWorld();
        if (GTUtility.canSeeSunClearly(world, blockPos = this.coverHolder.getPos()) && (energyContainer = this.coverHolder.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, null)) != null) {
            energyContainer.acceptEnergyFromNetwork(null, this.EUt, 1L);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[GTUtility.getTierByVoltage(this.EUt)].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }
}

