/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import gregtech.client.renderer.ICustomRenderFast;
import gregtech.client.shader.Shaders;
import gregtech.client.shader.postprocessing.BloomEffect;
import gregtech.client.utils.DepthTextureUtil;
import gregtech.client.utils.RenderUtil;
import gregtech.common.ConfigHolder;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.reflect.FieldUtils;

@SideOnly(value=Side.CLIENT)
public class BloomEffectUtil {
    public static BlockRenderLayer BLOOM;
    private static Framebuffer BLOOM_FBO;
    private static Map<IBloomRenderFast, List<Consumer<BufferBuilder>>> RENDER_FAST;

    public static BlockRenderLayer getRealBloomLayer() {
        return Shaders.isOptiFineShaderPackLoaded() ? BlockRenderLayer.CUTOUT : BLOOM;
    }

    public static void init() {
        BLOOM = (BlockRenderLayer)EnumHelper.addEnum(BlockRenderLayer.class, (String)"BLOOM", (Class[])new Class[]{String.class}, (Object[])new Object[]{"Bloom"});
        if (Loader.isModLoaded((String)"nothirium")) {
            try {
                Class<?> crp = Class.forName("meldexun.nothirium.api.renderer.chunk.ChunkRenderPass", false, (ClassLoader)Launch.classLoader);
                EnumHelper.addEnum(crp, (String)"BLOOM", (Class[])new Class[0], (Object[])new Object[0]);
                Field all = FieldUtils.getField(crp, (String)"ALL", (boolean)false);
                FieldUtils.removeFinalModifier((Field)all);
                FieldUtils.writeStaticField((Field)all, crp.getEnumConstants());
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        RENDER_FAST = Maps.newHashMap();
    }

    public static void initBloomRenderLayer(BufferBuilder[] worldRenderers) {
        worldRenderers[BloomEffectUtil.BLOOM.ordinal()] = new BufferBuilder(131072);
    }

    public static int renderBloomBlockLayer(RenderGlobal renderglobal, BlockRenderLayer blockRenderLayer, double partialTicks, int pass, Entity entity) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71424_I.func_76318_c("BTLayer");
        if (Shaders.isOptiFineShaderPackLoaded()) {
            int result = renderglobal.func_174977_a(blockRenderLayer, partialTicks, pass, entity);
            RENDER_FAST.clear();
            return result;
        }
        if (!ConfigHolder.client.shader.emissiveTexturesBloom) {
            GlStateManager.func_179132_a((boolean)true);
            renderglobal.func_174977_a(BLOOM, partialTicks, pass, entity);
            if (!RENDER_FAST.isEmpty()) {
                BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
                RENDER_FAST.forEach((handler, list) -> {
                    handler.preDraw(buffer);
                    list.forEach(consumer -> consumer.accept(buffer));
                    handler.postDraw(buffer);
                });
                RENDER_FAST.clear();
            }
            GlStateManager.func_179132_a((boolean)false);
            return renderglobal.func_174977_a(blockRenderLayer, partialTicks, pass, entity);
        }
        Framebuffer fbo = mc.func_147110_a();
        if (BLOOM_FBO == null || BloomEffectUtil.BLOOM_FBO.field_147621_c != fbo.field_147621_c || BloomEffectUtil.BLOOM_FBO.field_147618_d != fbo.field_147618_d || fbo.isStencilEnabled() && !BLOOM_FBO.isStencilEnabled()) {
            if (BLOOM_FBO == null) {
                BLOOM_FBO = new Framebuffer(fbo.field_147621_c, fbo.field_147618_d, false);
                BLOOM_FBO.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
            } else {
                BLOOM_FBO.func_147613_a(fbo.field_147621_c, fbo.field_147618_d);
            }
            if (fbo.isStencilEnabled() && !BLOOM_FBO.isStencilEnabled()) {
                BLOOM_FBO.enableStencil();
            }
            if (DepthTextureUtil.isLastBind() && DepthTextureUtil.isUseDefaultFBO()) {
                RenderUtil.hookDepthTexture(BLOOM_FBO, DepthTextureUtil.framebufferDepthTexture);
            } else {
                RenderUtil.hookDepthBuffer(BLOOM_FBO, fbo.field_147624_h);
            }
            BLOOM_FBO.func_147607_a(9729);
        }
        GlStateManager.func_179132_a((boolean)true);
        fbo.func_147610_a(true);
        if (!RENDER_FAST.isEmpty()) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            RENDER_FAST.forEach((handler, list) -> {
                handler.preDraw(buffer);
                list.forEach(consumer -> consumer.accept(buffer));
                handler.postDraw(buffer);
            });
        }
        BLOOM_FBO.func_147614_f();
        BLOOM_FBO.func_147610_a(false);
        renderglobal.func_174977_a(BLOOM, partialTicks, pass, entity);
        GlStateManager.func_179132_a((boolean)false);
        BLOOM_FBO.func_147612_c();
        Shaders.renderFullImageInFBO(fbo, Shaders.IMAGE_F, null);
        OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)fbo.field_147616_f);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j((int)7425);
        int result = renderglobal.func_174977_a(blockRenderLayer, partialTicks, pass, entity);
        mc.field_71424_I.func_76318_c("bloom");
        fbo.func_147612_c();
        GlStateManager.func_179112_b((int)772, (int)0);
        Shaders.renderFullImageInFBO(BLOOM_FBO, Shaders.IMAGE_F, null);
        GlStateManager.func_179112_b((int)770, (int)771);
        BloomEffect.strength = (float)ConfigHolder.client.shader.strength;
        BloomEffect.baseBrightness = (float)ConfigHolder.client.shader.baseBrightness;
        BloomEffect.highBrightnessThreshold = (float)ConfigHolder.client.shader.highBrightnessThreshold;
        BloomEffect.lowBrightnessThreshold = (float)ConfigHolder.client.shader.lowBrightnessThreshold;
        BloomEffect.step = (float)ConfigHolder.client.shader.step;
        switch (ConfigHolder.client.shader.bloomStyle) {
            case 0: {
                BloomEffect.renderLOG(BLOOM_FBO, fbo);
                break;
            }
            case 1: {
                BloomEffect.renderUnity(BLOOM_FBO, fbo);
                break;
            }
            case 2: {
                BloomEffect.renderUnreal(BLOOM_FBO, fbo);
                break;
            }
            default: {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179084_k();
                return result;
            }
        }
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179084_k();
        Shaders.renderFullImageInFBO(fbo, Shaders.IMAGE_F, null);
        if (!RENDER_FAST.isEmpty()) {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            RENDER_FAST.forEach((handler, list) -> {
                GlStateManager.func_179132_a((boolean)true);
                BLOOM_FBO.func_147614_f();
                BLOOM_FBO.func_147610_a(true);
                handler.preDraw(buffer);
                list.forEach(consumer -> consumer.accept(buffer));
                handler.postDraw(buffer);
                GlStateManager.func_179132_a((boolean)false);
                fbo.func_147612_c();
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)772, (int)0);
                Shaders.renderFullImageInFBO(BLOOM_FBO, Shaders.IMAGE_F, null);
                GlStateManager.func_179112_b((int)770, (int)771);
                switch (handler.customBloomStyle()) {
                    case 0: {
                        BloomEffect.renderLOG(BLOOM_FBO, fbo);
                        break;
                    }
                    case 1: {
                        BloomEffect.renderUnity(BLOOM_FBO, fbo);
                        break;
                    }
                    case 2: {
                        BloomEffect.renderUnreal(BLOOM_FBO, fbo);
                        break;
                    }
                    default: {
                        GlStateManager.func_179084_k();
                        return;
                    }
                }
                GlStateManager.func_179084_k();
                Shaders.renderFullImageInFBO(fbo, Shaders.IMAGE_F, null);
            });
            RENDER_FAST.clear();
        }
        return result;
    }

    public static Framebuffer getBloomFBO() {
        return BLOOM_FBO;
    }

    public static void requestCustomBloom(IBloomRenderFast handler, Consumer<BufferBuilder> render) {
        RENDER_FAST.computeIfAbsent(handler, x -> Lists.newLinkedList()).add(render);
    }

    public static interface IBloomRenderFast
    extends ICustomRenderFast {
        public int customBloomStyle();
    }
}

