/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.particle;

import gregtech.client.particle.IGTParticleHandler;
import java.util.function.Consumer;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GTParticle
extends Particle {
    protected int texturesCount = 1;
    protected int squareRenderRange = -1;
    protected boolean motionless = false;
    protected Consumer<GTParticle> onUpdate;

    public GTParticle(World worldIn, double posXIn, double posYIn, double posZIn) {
        super(worldIn, posXIn, posYIn, posZIn);
    }

    public GTParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
    }

    public int func_70537_b() {
        return this.func_187111_c() ? 1 : 0;
    }

    public boolean shouldRendered(Entity entityIn, float partialTicks) {
        if (this.squareRenderRange < 0) {
            return true;
        }
        return entityIn.func_174824_e(partialTicks).func_186679_c(this.field_187126_f, this.field_187127_g, this.field_187128_h) <= (double)this.squareRenderRange;
    }

    public void setRenderRange(int renderRange) {
        this.squareRenderRange = renderRange * renderRange;
    }

    public void setImmortal() {
        this.field_70546_d = -1;
    }

    public void setMotionless(boolean motionless) {
        this.motionless = motionless;
    }

    public void setColor(int color) {
        this.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        this.func_82338_g((float)(color >> 24 & 0xFF) / 255.0f);
    }

    public void setScale(float scale) {
        this.field_70544_f = scale;
    }

    public void setGravity(float gravity) {
        this.field_70545_g = gravity;
    }

    public void setTexturesIndex(int particleTextureIndexX, int particleTextureIndexY) {
        this.field_94054_b = particleTextureIndexX;
        this.field_94055_c = particleTextureIndexY;
    }

    public void setTexturesCount(int texturesCount) {
        this.texturesCount = texturesCount;
    }

    public void setOnUpdate(Consumer<GTParticle> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void func_70536_a(int particleTextureIndex) {
        this.field_94054_b = particleTextureIndex % this.texturesCount;
        this.field_94055_c = particleTextureIndex / this.texturesCount;
    }

    public float getTexturesCount() {
        return this.texturesCount;
    }

    public boolean isMotionless() {
        return this.motionless;
    }

    public int getRenderRange() {
        return this.squareRenderRange >= 0 ? -1 : (int)Math.sqrt(this.squareRenderRange);
    }

    public void func_189213_a() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this);
        }
        if (this.field_70546_d >= 0 && this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        if (!this.motionless) {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.field_187130_j -= 0.04 * (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.98f;
            this.field_187130_j *= (double)0.98f;
            this.field_187131_k *= (double)0.98f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float minU = (float)this.field_94054_b * 1.0f / (float)this.texturesCount;
        float maxU = minU + 1.0f / (float)this.texturesCount;
        float minV = (float)this.field_94055_c * 1.0f / (float)this.texturesCount;
        float maxV = minV + 1.0f / (float)this.texturesCount;
        float scale = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float renderX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float renderY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float renderZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightnessForRender = this.func_189214_a(partialTicks);
        int j = brightnessForRender >> 16 & 0xFFFF;
        int k = brightnessForRender & 0xFFFF;
        buffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    public IGTParticleHandler getGLHandler() {
        return IGTParticleHandler.DEFAULT_FX_HANDLER;
    }
}

