/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.modelfactories;

import codechicken.lib.render.item.CCRenderItem;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import gregtech.api.block.VariantActiveBlock;
import gregtech.client.model.modelfactories.ActiveVariantBlockBakedModel;
import gregtech.client.model.modelfactories.CompressedBlockBakedModel;
import gregtech.client.model.modelfactories.FrameBakedModel;
import gregtech.client.model.modelfactories.OreBakedModel;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockOre;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class BakedModelHandler {
    private static final StateMapperBase SIMPLE_STATE_MAPPER = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return BakedModelHandler.getSimpleModelLocation(state.func_177230_c());
        }
    };
    private static final ItemMeshDefinition SIMPLE_MESH_DEFINITION = stack -> BakedModelHandler.getSimpleModelLocation(Block.func_149634_a((Item)stack.func_77973_b()));
    private final List<Tuple<Block, String>> builtInBlocks = new ArrayList<Tuple<Block, String>>();
    private final List<BlockFluidBase> fluidBlocks = new ArrayList<BlockFluidBase>();

    private static ModelResourceLocation getSimpleModelLocation(Block block) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), "");
    }

    public void addBuiltInBlock(Block block, String particleTexture) {
        this.builtInBlocks.add((Tuple<Block, String>)new Tuple((Object)block, (Object)particleTexture));
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)SIMPLE_STATE_MAPPER);
        Item itemFromBlock = Item.func_150898_a((Block)block);
        if (itemFromBlock != Items.field_190931_a) {
            ModelLoader.setCustomMeshDefinition((Item)itemFromBlock, (ItemMeshDefinition)SIMPLE_MESH_DEFINITION);
        }
    }

    public void addFluidBlock(BlockFluidBase fluidBase) {
        this.fluidBlocks.add(fluidBase);
        ModelLoader.setCustomStateMapper((Block)fluidBase, (IStateMapper)SIMPLE_STATE_MAPPER);
    }

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        for (BlockFluidBase blockFluidBase : this.fluidBlocks) {
            Fluid fluid = (Fluid)ObfuscationReflectionHelper.getPrivateValue(BlockFluidBase.class, (Object)blockFluidBase, (String)"definedFluid");
            ModelFluid modelFluid = new ModelFluid(fluid);
            IBakedModel bakedModel = modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176599_b, TextureUtils::getTexture);
            ModelResourceLocation resourceLocation = BakedModelHandler.getSimpleModelLocation((Block)blockFluidBase);
            event.getModelRegistry().func_82595_a((Object)resourceLocation, (Object)bakedModel);
        }
        for (Tuple tuple : this.builtInBlocks) {
            ModelResourceLocation resourceLocation = BakedModelHandler.getSimpleModelLocation((Block)tuple.func_76341_a());
            ModelBuiltInRenderer bakedModel = new ModelBuiltInRenderer((String)tuple.func_76340_b());
            event.getModelRegistry().func_82595_a((Object)resourceLocation, (Object)bakedModel);
        }
        event.getModelRegistry().func_82595_a((Object)VariantActiveBlock.MODEL_LOCATION, (Object)new ActiveVariantBlockBakedModel());
        event.getModelRegistry().func_82595_a((Object)BlockOre.MODEL_LOCATION, (Object)new OreBakedModel());
        event.getModelRegistry().func_82595_a((Object)BlockCompressed.MODEL_LOCATION, (Object)new CompressedBlockBakedModel());
        event.getModelRegistry().func_82595_a((Object)BlockFrame.MODEL_LOCATION, (Object)new FrameBakedModel());
    }

    private static class ModelBuiltInRenderer
    implements IBakedModel {
        private final String particleTexture;

        public ModelBuiltInRenderer(String particleTexture) {
            this.particleTexture = particleTexture;
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return Collections.emptyList();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return true;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return TextureUtils.getBlockTexture((String)this.particleTexture);
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        @Nonnull
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(@Nonnull ItemCameraTransforms.TransformType cameraTransformType) {
            CCRenderItem.notifyTransform((ItemCameraTransforms.TransformType)cameraTransformType);
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)TransformUtils.DEFAULT_BLOCK, (ItemCameraTransforms.TransformType)cameraTransformType);
        }
    }
}

