/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.visitors;

import gregtech.asm.util.ObfMapping;
import gregtech.asm.util.SafeMethodVisitor;
import org.objectweb.asm.MethodVisitor;

public class SpecialArmorApplyVisitor
extends SafeMethodVisitor {
    public static final String TARGET_CLASS_NAME = "net/minecraftforge/common/ISpecialArmor$ArmorProperties";
    public static final ObfMapping TARGET_METHOD = new ObfMapping("net/minecraftforge/common/ISpecialArmor$ArmorProperties", "applyArmor", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/util/NonNullList;Lnet/minecraft/util/DamageSource;D)F");
    private static final ObfMapping METHOD_MAPPING = new ObfMapping("net/minecraft/util/CombatRules", "func_189427_a", "(FFF)F").toRuntime();
    private static final String ARMOR_HOOKS_OWNER = "gregtech/asm/hooks/ArmorHooks";
    private static final String ARMOR_HOOKS_SIGNATURE = "(FLnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/util/NonNullList;Lnet/minecraft/util/DamageSource;)V";
    private static final String ARMOR_HOOKS_METHOD_NAME = "damageArmor";

    public SpecialArmorApplyVisitor(MethodVisitor mv) {
        super(327680, mv);
    }

    private boolean checkTargetInsn(int opcode, String owner, String name, String desc) {
        return opcode == 184 && SpecialArmorApplyVisitor.METHOD_MAPPING.s_owner.equals(owner) && METHOD_MAPPING.matches(name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.checkTargetInsn(opcode, owner, name, desc)) {
            this.markPatchedSuccessfully();
            super.visitFieldInsn(179, TARGET_CLASS_NAME, "gregtech__cachedToughness", "F");
            super.visitFieldInsn(179, TARGET_CLASS_NAME, "gregtech__cachedTotalArmor", "F");
            super.visitInsn(89);
            super.visitVarInsn(25, 0);
            super.visitVarInsn(25, 1);
            super.visitVarInsn(25, 2);
            super.visitMethodInsn(184, ARMOR_HOOKS_OWNER, ARMOR_HOOKS_METHOD_NAME, ARMOR_HOOKS_SIGNATURE, false);
            super.visitFieldInsn(178, TARGET_CLASS_NAME, "gregtech__cachedTotalArmor", "F");
            super.visitFieldInsn(178, TARGET_CLASS_NAME, "gregtech__cachedToughness", "F");
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    protected String getInjectTargetString() {
        return String.format("Patch target: %s; injection point: %s; (point not found)", new Object[]{TARGET_METHOD, METHOD_MAPPING});
    }
}

