/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.hooks;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBoxCache;
import com.creativemd.littletiles.client.render.tile.LittleRenderBox;
import gregtech.client.utils.BloomEffectUtil;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.BlockRenderLayer;

public class LittleTilesHooks {
    public static LayeredRenderBoxCache initLayeredRenderBoxCache() {
        return new BloomLayeredRenderBoxCache();
    }

    public static class BloomLayeredRenderBoxCache
    extends LayeredRenderBoxCache {
        private List<LittleRenderBox> solid = null;
        private List<LittleRenderBox> cutout_mipped = null;
        private List<LittleRenderBox> cutout = null;
        private List<LittleRenderBox> bloom = null;
        private List<LittleRenderBox> translucent = null;

        public List<LittleRenderBox> get(BlockRenderLayer layer) {
            if (layer == BloomEffectUtil.BLOOM) {
                return this.bloom;
            }
            switch (layer) {
                case SOLID: {
                    return this.solid;
                }
                case CUTOUT_MIPPED: {
                    return this.cutout_mipped;
                }
                case CUTOUT: {
                    return this.cutout;
                }
                case TRANSLUCENT: {
                    return this.translucent;
                }
            }
            return null;
        }

        public void set(List<LittleRenderBox> cubes, BlockRenderLayer layer) {
            if (layer == BloomEffectUtil.BLOOM) {
                this.bloom = cubes;
            }
            switch (layer) {
                case SOLID: {
                    this.solid = cubes;
                    break;
                }
                case CUTOUT_MIPPED: {
                    this.cutout_mipped = cubes;
                    break;
                }
                case CUTOUT: {
                    this.cutout = cubes;
                    break;
                }
                case TRANSLUCENT: {
                    this.translucent = cubes;
                }
            }
        }

        public boolean needUpdate() {
            return this.solid == null || this.cutout_mipped == null || this.cutout == null || this.translucent == null || this.bloom == null;
        }

        public void clear() {
            this.solid = null;
            this.cutout_mipped = null;
            this.cutout = null;
            this.translucent = null;
            this.bloom = null;
        }

        public void sort() {
            if (!OptifineHelper.isActive()) {
                return;
            }
            Iterator<LittleRenderBox> iterator = this.solid.iterator();
            while (iterator.hasNext()) {
                LittleRenderBox littleRenderingCube = iterator.next();
                if (!littleRenderingCube.needsResorting) continue;
                this.cutout_mipped.add(littleRenderingCube);
                iterator.remove();
            }
        }
    }
}

