/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.block.machines.MachineItemBlock;
import gregtech.api.items.materialitem.MetaPrefixItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockCompressed;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.items.MetaItems;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class GTStringUtils {
    private GTStringUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static String prettyPrintItemStack(@Nonnull ItemStack stack) {
        if (stack.func_77973_b() instanceof MetaItem) {
            MetaItem metaItem = (MetaItem)stack.func_77973_b();
            Object metaValueItem = metaItem.getItem(stack);
            if (metaValueItem == null) {
                if (!(metaItem instanceof MetaPrefixItem)) return stack.func_77973_b().getRegistryName().toString() + " * " + stack.func_190916_E() + " (Meta " + stack.func_77952_i() + ")";
                Material material = ((MetaPrefixItem)metaItem).getMaterial(stack);
                OrePrefix orePrefix = ((MetaPrefixItem)metaItem).getOrePrefix();
                return "(MetaItem) OrePrefix: " + orePrefix.name + ", Material: " + material + " * " + stack.func_190916_E();
            }
            if (!MetaItems.INTEGRATED_CIRCUIT.isItemEqual(stack)) return "(MetaItem) " + ((MetaItem.MetaValueItem)metaValueItem).unlocalizedName + " * " + stack.func_190916_E();
            return "Config circuit #" + IntCircuitIngredient.getCircuitConfiguration(stack);
        }
        if (stack.func_77973_b() instanceof MachineItemBlock) {
            MetaTileEntity mte = GTUtility.getMetaTileEntity(stack);
            if (mte == null) return stack.func_77973_b().getRegistryName().toString() + " * " + stack.func_190916_E() + " (Meta " + stack.func_77952_i() + ")";
            String id = mte.metaTileEntityId.toString();
            if (!mte.metaTileEntityId.func_110624_b().equals("gregtech")) return "(MetaTileEntity) " + id + " * " + stack.func_190916_E();
            id = mte.metaTileEntityId.func_110623_a();
            return "(MetaTileEntity) " + id + " * " + stack.func_190916_E();
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        String id = null;
        if (block instanceof BlockCompressed) {
            id = "block" + ((BlockCompressed)block).getGtMaterial(stack.func_77960_j()).toCamelCaseString();
        } else if (block instanceof BlockFrame) {
            id = "frame" + ((BlockFrame)block).getGtMaterial(stack.func_77960_j()).toCamelCaseString();
        } else if (block instanceof BlockMaterialPipe) {
            id = ((BlockMaterialPipe)block).getPrefix().name + ((BlockMaterialPipe)block).getItemMaterial(stack).toCamelCaseString();
        }
        if (id == null) return stack.func_77973_b().getRegistryName().toString() + " * " + stack.func_190916_E() + " (Meta " + stack.func_77952_i() + ")";
        return "(MetaBlock) " + id + " * " + stack.func_190916_E();
    }

    @Nonnull
    public static String ticksToElapsedTime(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return (seconds %= 60) < 10 ? minutes + ":0" + seconds : minutes + ":" + seconds;
    }
}

